/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.ResultSet;
import javax.swing.JTable;
import oracle.dbtools.raptor.format.ResultsFormatter;

public class HTMLFormatter
extends ResultsFormatter {
    private boolean _result = true;

    public HTMLFormatter(String conn, String sql, OutputStreamWriter out) {
        super(conn, sql, out);
    }

    public HTMLFormatter(JTable table, OutputStreamWriter out) {
        super(table, out);
    }

    public HTMLFormatter(ResultSet rset, OutputStreamWriter out) {
        super(rset, out);
    }

    public void start() throws IOException {
        this.write("<html><body><table>\n");
    }

    public void startRow() throws IOException {
        this.write("\t<tr>\n");
    }

    public void printColumn(Object col, int idx) throws IOException {
        if (idx == 0 && this._result) {
            return;
        }
        this.write("<td>");
        if (col != null) {
            this.write(col.toString());
        }
        this.write("</td>\n");
    }

    public void endRow() throws IOException {
        this.write("\t</tr>\n");
    }

    public void end() throws IOException {
        this.write("</table></body></html>");
    }

    public void setResult(boolean result) {
        this._result = result;
    }
}

