/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import java.io.OutputStreamWriter;
import javax.swing.JTable;
import oracle.dbtools.raptor.format.ResultsFormatter;

public class LoaderFormatter
extends ResultsFormatter {
    String tableName = null;

    public LoaderFormatter(String conn, String sql, OutputStreamWriter out, String tName) {
        super(conn, sql, out);
        this.tableName = tName;
    }

    public LoaderFormatter(JTable table, OutputStreamWriter out, String tName) {
        super(table, out);
        this.tableName = tName;
    }

    public void start() throws IOException {
        this.write("LOAD DATA\n");
        this.write("INFILE *\n");
        this.write("Truncate\n");
        this.write("INTO TABLE '" + this.tableName + "'\n");
        this.write("FIELDS TERMINATED BY ',' optionally enclosed by '\"'\n");
        this.write("TRAILING NULLCOLS\n");
        this.write("(");
        for (int i = 1; i < this._colNames.size(); ++i) {
            if (i == this._colNames.size() - 1) {
                this.write(((String)this._colNames.get(i)).toString() + ")\n");
                continue;
            }
            this.write(((String)this._colNames.get(i)).toString() + ",\n");
        }
        this.write("begindata\n");
    }

    public void startRow() throws IOException {
    }

    public void printColumn(Object col, int idx) throws IOException {
        String colm = "";
        if (idx == 0) {
            return;
        }
        if (col != null && idx == 1) {
            colm = "\"" + this.cleanString(col.toString()) + "\"";
        } else if (col == null && idx == 1) {
            colm = "\"\"";
        } else if (col != null && idx > 1) {
            colm = ",\"" + this.cleanString(col.toString()) + "\"";
        } else if (col == null && idx > 1) {
            colm = ",\"\"";
        }
        this.write(colm);
    }

    public String cleanString(String str) {
        String newStr = "";
        for (int i = 0; i < str.length(); ++i) {
            Character ch = Character.valueOf(str.charAt(i));
            newStr = newStr + ch;
        }
        return newStr;
    }

    public void endRow() throws IOException {
        this.write("\n");
    }

    public void end() throws IOException {
    }
}

