/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.IProgressFeedback;
import oracle.dbtools.raptor.models.ResultSetTableModel;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.Log;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFilter;
import oracle.jdbc.OracleResultSet;
import oracle.sql.DATE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResultsFormatter {
    public static final URLFilter SQL_FILTER = new DefaultURLFilter(Translate.translate("SQL File"), ".sql");
    public static final URLFilter CSV_FILTER = new DefaultURLFilter(Translate.translate("CSV File"), ".csv");
    public static final URLFilter XML_FILTER = new DefaultURLFilter(Translate.translate("XML File"), ".xml");
    public static final URLFilter LDR_FILTER = new DefaultURLFilter(Translate.translate("SQL Loader File"), ".ldr");
    public static final URLFilter TXT_FILTER = new DefaultURLFilter(Translate.translate("Text File"), ".txt");
    public static final int SQLPLUS = 0;
    public static final int CSV = 1;
    public static final int XML = 2;
    public static final int HTML = 3;
    public static final int INSERT = 4;
    public static final int LOADER = 5;
    public static final int TEXT = 6;
    protected int _format;
    protected OutputStreamWriter _out;
    protected int[] _colSizes;
    protected ArrayList<String> _colNames;
    protected JTable _table;
    protected IProgressFeedback _feedback;
    private String _conn;
    private String _sql;
    private ResultSet _rs;
    private ResultSetMetaData _meta;
    private int _max_rows_allowed = -1;
    protected String _nullValue = "";
    private boolean _interrupt = false;

    public abstract void start() throws IOException;

    public abstract void startRow() throws IOException;

    public abstract void printColumn(Object var1, int var2) throws IOException;

    public abstract void endRow() throws IOException;

    public abstract void end() throws IOException;

    public ResultsFormatter(ResultSet rs, OutputStreamWriter out) {
        this._rs = rs;
        this._out = out;
        this.setRSHeaders(rs);
    }

    public ResultsFormatter(JTable table, OutputStreamWriter out) {
        this._table = table;
        this._out = out;
        this.setJTableHeaders();
    }

    public ResultsFormatter(String conn, String sql, OutputStreamWriter out) {
        this._sql = sql;
        this._conn = conn;
        this._out = out;
        this.setSQLHeaders();
    }

    private void setRSHeaders(ResultSet rs) {
        this._rs = rs;
        this.setSQLHeaders();
    }

    private void setSQLHeaders() {
        this._colNames = new ArrayList();
        this._colNames.add("");
        if (this._rs == null && this._conn != null && this._sql != null) {
            this._rs = DBUtil.getInstance().executeQuery(this._conn, this._sql, (ArrayList)null);
        }
        try {
            this._meta = ((PreparedStatement)this._rs.getStatement()).getMetaData();
            this._colSizes = new int[this._meta.getColumnCount() + 1];
            for (int i = 1; i < this._meta.getColumnCount() + 1; ++i) {
                this._colNames.add(this._meta.getColumnName(i));
                this._colSizes[i] = this._meta.getColumnType(i) == 91 || this._meta.getColumnType(i) == 92 || this._meta.getColumnType(i) == 93 ? 25 : this._meta.getColumnName(i).length();
            }
        }
        catch (SQLException e) {
            ExceptionHandler.handleException(e);
        }
    }

    public void setJTableHeaders() {
        ResultSetTableModel model;
        this._colNames = new ArrayList();
        int colCnt = this._table.getModel().getColumnCount();
        this._colSizes = new int[colCnt];
        ResultSetTableModel resultSetTableModel = model = this._table.getModel() instanceof ResultSetTableModel ? (ResultSetTableModel)this._table.getModel() : null;
        if (model != null) {
            this._colSizes[0] = 25;
        }
        for (int i = 0; i < colCnt; ++i) {
            if (model != null) {
                if (model.getTypes().length >= colCnt) {
                    this._colSizes[i] = model.getTypes()[i] == 91 || model.getTypes()[i] == 92 || model.getTypes()[i] == 93 ? 25 : (model.getColSizes()[i] < this._table.getModel().getColumnName(i).length() ? this._table.getModel().getColumnName(i).length() : ((ResultSetTableModel)this._table.getModel()).getColSizes()[i]);
                }
            } else {
                this._colSizes[i] = this._table.getModel().getColumnName(i).length();
            }
            String name = this._table.getModel().getColumnName(i);
            this._colNames.add(name);
        }
    }

    public void print(OutputStreamWriter out) {
        this._out = out;
        this.print();
    }

    public void printWithDialog() {
        final ResultsFormatter finalFormatter = this;
        final OutputStreamWriter out = this._out;
        ProgressRunnable runner = new ProgressRunnable(){

            protected void doCancel() {
                super.doCancel();
                finalFormatter.interrupt();
            }

            protected Object doWork() throws Exception {
                finalFormatter.print();
                out.close();
                return null;
            }
        };
        IProgressFeedback feedback = new IProgressFeedback(){

            public void feedback(String s) {
                Log.status(s);
            }
        };
        finalFormatter.setFeedback(feedback);
        runner.setTitle(Translate.translate("Exporting..."));
        runner.setCancelable(true);
        try {
            runner.start(true);
        }
        catch (ProgressException e) {
            e.printStackTrace();
        }
    }

    public int print() {
        int ret = 0;
        try {
            ret = this._rs != null ? this.printSQL() : (this._table.getModel() instanceof ResultSetTableModel ? this.printResultSetTableModel() : this.printTable());
            if (this._out != null) {
                this._out.flush();
            }
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e);
        }
        return ret;
    }

    public int printSQL() throws IOException {
        int ret = 0;
        this.start();
        try {
            while (this._rs.next() && !this._interrupt) {
                this.log(Translate.translate("Row:" + this._rs.getRow()));
                this.startRow();
                for (int ii = 0; ii < this._meta.getColumnCount(); ++ii) {
                    this.printColumn(this._rs.getObject(ii + 1), ii + 1);
                }
                this.endRow();
                ret = this._rs.getRow();
            }
        }
        catch (SQLException e) {
            ExceptionHandler.handleException(e);
        }
        catch (IOException e) {
            ExceptionHandler.handleException(e);
        }
        this.end();
        return ret;
    }

    public int printResultSetTableModel() throws Exception {
        ResultSetTableModel model = (ResultSetTableModel)this._table.getModel();
        this._rs = model.getResultSet();
        if (model.allFetched()) {
            return this.printTable();
        }
        this._rs = model.getResultSetCopy();
        return this.printResultSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int printResultSet() throws IOException {
        int ret = 0;
        try {
            this.start();
            int i = 0;
            this._rs.setFetchSize(100);
            while (this._rs.next() && !this._interrupt && (this._max_rows_allowed == -1 || this._max_rows_allowed <= this._rs.getRow())) {
                this.log(Translate.translate("Row:" + this._rs.getRow()));
                this.startRow();
                this.printColumn(this._rs.getRow(), 0);
                for (i = 1; i <= this._colNames.size() - 1; ++i) {
                    this.printColumn(this.getValue(((OracleResultSet)this._rs).getOracleObject(i)), i);
                }
                this.endRow();
            }
            ret = this._rs.getRow();
            this.end();
            if (this._max_rows_allowed != -1 && this._max_rows_allowed <= this._rs.getRow()) {
                this.write("Only " + this._max_rows_allowed + " rows currently supported in a script results".getBytes());
            }
        }
        catch (SQLException se) {
            ExceptionHandler.handleException(se);
        }
        finally {
            try {
                this._rs.getStatement().close();
            }
            catch (SQLException e) {}
            try {
                this._rs.close();
            }
            catch (SQLException sQLException) {}
        }
        return ret;
    }

    public int printTable() throws IOException {
        AbstractTableModel model = (AbstractTableModel)this._table.getModel();
        this.start();
        for (int i = 0; i < model.getRowCount() && !this._interrupt; ++i) {
            this.log(Translate.translate("Row:" + i));
            this.startRow();
            for (int ii = 0; ii < model.getColumnCount(); ++ii) {
                this.printColumn(this.getValue(model.getValueAt(i, ii)), ii);
            }
            this.endRow();
        }
        this.end();
        return model.getRowCount();
    }

    protected void write(String s) throws IOException {
        this._out.write(s);
    }

    protected void log(String s) {
        if (this._feedback != null) {
            this._feedback.feedback(s);
        }
    }

    public void setHeaders(ArrayList<String> headers) {
        this._colNames = headers;
    }

    public OutputStreamWriter getOut() {
        return this._out;
    }

    public void setOut(OutputStreamWriter out) {
        this._out = out;
    }

    public JTable getTable() {
        return this._table;
    }

    public void setTable(JTable table) {
        this._table = table;
    }

    public IProgressFeedback getFeedback() {
        return this._feedback;
    }

    public void setFeedback(IProgressFeedback feedback) {
        this._feedback = feedback;
    }

    public void interrupt() {
        this._interrupt = true;
    }

    protected Object getValue(Object obj) {
        try {
            if (this._rs != null) {
                return NLSUtils.getValue(this._rs.getStatement().getConnection(), obj);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return obj;
    }

    public int getDataType(int colIdx) {
        int ret = -1;
        try {
            if (this._table != null && this._table.getModel() instanceof ResultSetTableModel) {
                ret = ((ResultSetTableModel)this._table.getModel()).getType(colIdx - 1);
            } else if (this._rs != null) {
                ret = this._rs.getMetaData().getColumnType(colIdx);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return ret;
    }

    public String getDateFormat() {
        if (this._table == null) {
            try {
                return NLSUtils.getDateFormat(this._rs.getStatement().getConnection());
            }
            catch (SQLException e) {
                e.printStackTrace();
                return null;
            }
        }
        return NLSUtils.getDateFormat(((ResultSetTableModel)this._table.getModel()).getConn());
    }

    public String getFormattedDATE(Object obj) {
        try {
            return NLSUtils.formatDate(((ResultSetTableModel)this._table.getModel()).getConnName(), (DATE)obj);
        }
        catch (SQLException sQLException) {
            return obj.toString();
        }
    }

    public ArrayList<String> getColumns() {
        return this._colNames;
    }
}

