/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.ResultSet;
import javax.swing.JTable;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.ide.util.IdeUtil;

public class XMLFormatter
extends ResultsFormatter {
    private boolean _result = true;

    public XMLFormatter(String conn, String sql, OutputStreamWriter out) {
        super(conn, sql, out);
    }

    public XMLFormatter(JTable table, OutputStreamWriter out) {
        super(table, out);
    }

    public XMLFormatter(ResultSet rset, OutputStreamWriter out) {
        super(rset, out);
    }

    public void start() throws IOException {
        this.write("<?xml version='1.0'  encoding='" + IdeUtil.getIdeEncoding() + "' ?>\n");
        this.write("<results>\n");
    }

    public void startRow() throws IOException {
        this.write("\t<row>\n");
    }

    public void printColumn(Object col, int idx) throws IOException {
        if (idx == 0 && this._result) {
            return;
        }
        this.write("\t\t<" + ((String)this._colNames.get(idx)).replace(' ', '_').replace('/', '_') + ">");
        this.write("<![CDATA[");
        if (col != null) {
            this.write(col.toString());
        }
        this.write("]]>");
        this.write("</" + ((String)this._colNames.get(idx)).replace(' ', '_') + ">\n");
    }

    public void endRow() throws IOException {
        this.write("\t</row>\n");
    }

    public void end() throws IOException {
        this.write("</results>");
    }

    public void setResult(boolean result) {
        this._result = result;
    }
}

