/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metadata;

public class MetaDataSql {
    private static String META_92_SQL_OBJECT = "select dbms_metadata.get_ddl(replace(decode(object_type,'DATABASE LINK','DB_LINK',object_type),' ','_'),object_name,owner) ,owner,object_name \n from sys.all_objects  where owner = :OWNER  and   object_type = :TYPE  {0}  union all  select dbms_metadata.get_ddl('DB_LINK',db_link,owner) ,owner,db_link object_name  from sys.all_db_links  where owner = :OWNER  and    :TYPE = 'DATABASE LINK'  {3} union all  select dbms_metadata.GET_DEPENDENT_DDL ('OBJECT_GRANT', object_name ,o.OWNER ) ,'' object_name,'' owner    from sys.all_tab_privs tp,sys.all_objects o    where table_name = o.object_name     and   table_schema = o.owner     and  table_schema = :OWNER     {1}";
    private static String META_92_SQL_OBJECT_NAME_SINGLE_FILTER = " and table_name = :NAME and rownum =1 ";
    private static String META_92_SQL_OBJECT_NAME_FILTER = " and table_name = :NAME  ";
    private static String META_92_SQL_DBLINK_NAME_FILTER = " and db_link = :NAME  ";
    private static String META_92_NAME_FILTER = " and object_name like :NAME \n";
    private static String META_92_TABLE = " select src,owner,object_name \n from ( \n  select dbms_metadata.get_ddl(replace(object_type,' ','_') ,object_name,owner) src,owner,object_name \n from ( select :TYPE object_type,object_name,owner from all_objects \n\twhere owner = :OWNER \n   and  object_type = :TYPE    and  object_type not in ('TABLE PARTITION') \n   {0}     minus \n    select 'TABLE',object_name,owner from all_objects \n    where owner = :OWNER \n    and object_type <> :TYPE    and  object_type not in ('TABLE PARTITION')   ) \n union all \n select dbms_metadata.GET_DEPENDENT_DDL ('COMMENT', table_NAME, OWNER ) , owner, TABLE_name \n FROM ( \n select table_name,owner from sys.all_COL_comments where owner = :OWNER and table_name = :NAME and comments is not null \n UNION \n select table_name,owner from sys.all_TAB_comments where owner = :OWNER and table_name = :NAME and comments is not null \n ) WHERE ROWNUM = 1 \n union all \n select dbms_metadata.GET_DEPENDENT_DDL ('OBJECT_GRANT', table_name ,:OWNER ) ,'' owner,'' object_name  from sys.all_tab_privs where table_schema = :OWNER {2} and rownum =1 \n union all \n select dbms_metadata.GET_DDL ('TRIGGER', trigger_name ,owner ),owner owner,trigger_name object_name from sys.all_triggers where table_owner = :OWNER {2}  \n union all \n select dbms_metadata.GET_DDL ('INDEX', index_name ,owner ),owner owner,index_name object_name  from sys.all_indexes where table_owner = :OWNER {2}  \n and index_name not in (select constraint_name from sys.all_constraints where table_name = table_name and constraint_type = 'P' ) \n) where OBJECT_NAME not like ('BIN$%') and object_name not like ('I_SNAP%')";
    private static String META_90_TABLE = " select src,owner,object_name \n from ( \n  select dbms_metadata.get_ddl(replace(object_type,' ','_') ,object_name,owner) src,owner,object_name \n from ( select :TYPE object_type,object_name,owner from all_objects \n\twhere owner = :OWNER \n   and  object_type = :TYPE \n   {0}     minus \n    select 'TABLE',object_name,owner from all_objects \n    where owner = :OWNER \n    and object_type <> :TYPE \n  ) \n union all \n select 'comment on table '|| table_name ||' is '''|| comments||''' c,'' owner,'' object_name from sys.all_tab_comments where owner = :OWNER {2} and comments is not null and rownum =1 \n union all \n select dbms_metadata.GET_DEPENDENT_DDL ('OBJECT_GRANT', :NAME ,:OWNER ) ,'' owner,'' object_name  from sys.all_tab_privs where table_schema = :OWNER {2} and rownum =1 \n union all \n select dbms_metadata.GET_DDL ('TRIGGER', trigger_name ,owner ),owner owner,trigger_name object_name from sys.all_triggers where table_owner = :OWNER {2}  \n union all \n select dbms_metadata.GET_DDL ('INDEX', index_name ,owner ),owner owner,index_name object_name  from sys.all_indexes where table_owner = :OWNER {2}  \n) where OBJECT_NAME not like ('BIN$%') and object_name not like ('I_SNAP%')";

    public String getSelect(double dbver, String type, String name, String owner) {
        if (type.equalsIgnoreCase("TABLE")) {
            return this.getTableSql(dbver, name);
        }
        if (type.equalsIgnoreCase("VIEW") || type.equalsIgnoreCase("MATERIALIZED VIEW")) {
            return this.getViewOrMVSql(dbver, name);
        }
        if (type.equalsIgnoreCase("MATERIALIZED VIEW LOG")) {
            return this.getMVLogSql(dbver, name, owner);
        }
        return this.getObjectSql(dbver, name);
    }

    public String getMVLogSql(double dbver, String name, String owner) {
        String sql = "select src,'" + owner + "' owner,'" + name + "' object_name from (" + "select 'CREATE MATERIALIZED VIEW LOG ON \"'||log_owner||'\".\"'||master||'\"'|| \n" + "CASE \n" + "when (primary_key = 'YES' or rowids = 'YES' or sequence = 'YES') then \n" + "' WITH '|| \n" + "case \n" + "when (primary_key = 'YES') then \n" + "'PRIMARY KEY'|| \n" + "case \n" + "when (ROWIDS = 'YES') then \n" + "',ROWID'|| \n" + "case \n" + "when (SEQUENCE = 'YES') then \n" + "',SEQUENCE' \n" + "else \n" + "' ' \n" + "end \n" + "else \n" + "case \n" + "when (SEQUENCE = 'YES') then \n" + "',SEQUENCE' \n" + "else \n" + "' ' \n" + "end \n" + "end \n" + "else \n" + "case \n" + "when (ROWIDS = 'YES') then \n" + "'ROWID'|| \n" + "case \n" + "when (SEQUENCE = 'YES') then \n" + "',SEQUENCE' \n" + "else \n" + "' ' \n" + "end \n" + "else \n" + "case \n" + "when (SEQUENCE = 'YES') then \n" + "'SEQUENCE' \n" + "else \n" + "' ' \n" + "end \n" + "end \n" + "end \n" + "end||';' src\n" + "from all_mview_logs where \n" + "log_owner  = :OWNER and MASTER = :NAME and :TYPE is not null)";
        return sql;
    }

    public void replace(StringBuilder sb, String oldStr, String newStr) {
        while (sb.indexOf(oldStr) > 0) {
            sb.replace(sb.indexOf(oldStr), sb.indexOf(oldStr) + oldStr.length(), newStr);
        }
    }

    public String getTableSql(double dbver, String name) {
        StringBuilder sb = new StringBuilder();
        if (dbver >= 9.2) {
            sb.append(META_92_TABLE);
        } else if (dbver >= 9.0) {
            sb.append(META_90_TABLE);
        }
        if (name != null) {
            this.replace(sb, "{0}", META_92_NAME_FILTER);
            this.replace(sb, "{1}", META_92_SQL_OBJECT_NAME_SINGLE_FILTER);
            this.replace(sb, "{2}", META_92_SQL_OBJECT_NAME_FILTER);
            this.replace(sb, "{3}", META_92_SQL_DBLINK_NAME_FILTER);
        } else {
            this.replace(sb, "{0}", "");
            this.replace(sb, "{1}", "");
            this.replace(sb, "{2}", "");
            this.replace(sb, "{3}", "");
        }
        return sb.toString();
    }

    public String getViewOrMVSql(double dbver, String name) {
        return this.getTableSql(dbver, name);
    }

    public String getObjectSql(double dbver, String name) {
        StringBuilder sb = new StringBuilder();
        sb.append(META_92_SQL_OBJECT);
        if (name != null) {
            this.replace(sb, "{0}", META_92_NAME_FILTER);
            this.replace(sb, "{1}", META_92_SQL_OBJECT_NAME_SINGLE_FILTER);
            this.replace(sb, "{3}", META_92_SQL_DBLINK_NAME_FILTER);
        } else {
            this.replace(sb, "{0}", "");
            this.replace(sb, "{1}", "");
            this.replace(sb, "{3}", "");
        }
        return sb.toString();
    }
}

