/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.nls;

import java.sql.Timestamp;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import oracle.i18n.text.OraSimpleDateFormat;
import oracle.i18n.util.OraLocaleInfo;
import oracle.sql.DATE;

public class OraDATEFormat
extends OraSimpleDateFormat {
    private static final int SIZE_DATE = 7;
    private static final int BYTE_YEAR1 = 0;
    private static final int BYTE_YEAR2 = 1;
    private static final int BYTE_MONTH = 2;
    private static final int BYTE_DAY = 3;
    private static final int BYTE_HOUR = 4;
    private static final int BYTE_MINUTE = 5;
    private static final int BYTE_SECOND = 6;
    private TimeZone UTC = TimeZone.getTimeZone("UTC");

    public OraDATEFormat(String pattern, OraLocaleInfo localeInfo) throws ParseException {
        super(pattern, localeInfo);
    }

    public void applyPattern(String pattern) throws ParseException {
        int cnt;
        int i;
        boolean shrink = false;
        String uc = pattern.toUpperCase(Locale.US);
        StringBuffer pat = new StringBuffer(pattern);
        int pos = -1;
        while ((pos = uc.indexOf("SP", pos + 1)) >= 0) {
            i = -1;
            cnt = 0;
            while ((i = uc.indexOf(34, i + 1)) < pos && i != -1) {
                ++cnt;
            }
            if (cnt % 2 != 0) continue;
            pat.setCharAt(pos, '\uffff');
            pat.setCharAt(pos + 1, '\uffff');
            shrink = true;
        }
        pos = -1;
        while ((pos = uc.indexOf("TH", pos + 1)) >= 0) {
            if (pos > 2 && uc.substring(pos - 3, pos + 2).equals("MONTH")) continue;
            i = -1;
            cnt = 0;
            while ((i = uc.indexOf(34, i + 1)) < pos && i != -1) {
                ++cnt;
            }
            if (cnt % 2 != 0) continue;
            pat.setCharAt(pos, '\uffff');
            pat.setCharAt(pos + 1, '\uffff');
            shrink = true;
        }
        pos = -1;
        while ((pos = uc.indexOf("X", pos + 1)) >= 0) {
            if (pos > 0 && uc.charAt(pos - 1) == 'F') continue;
            i = -1;
            cnt = 0;
            while ((i = uc.indexOf(34, i + 1)) < pos && i != -1) {
                ++cnt;
            }
            if (cnt % 2 != 0) continue;
            throw new ParseException("Radix format element not allowed in DATE formatting", pos);
        }
        pos = -1;
        while ((pos = uc.indexOf("FF", pos + 1)) >= 0) {
            i = -1;
            cnt = 0;
            while ((i = uc.indexOf(34, i + 1)) < pos && i != -1) {
                ++cnt;
            }
            if (cnt % 2 != 0) continue;
            throw new ParseException("Fractional seconds format element not allowed in DATE formatting", pos);
        }
        pos = -1;
        while ((pos = uc.indexOf("TZ", pos + 1)) >= 0 && pos <= uc.length() - 3) {
            char c = uc.charAt(pos + 2);
            if (c != 'R' && c != 'D' && c != 'H' && c != 'M') continue;
            i = -1;
            cnt = 0;
            while ((i = uc.indexOf(34, i + 1)) < pos && i != -1) {
                ++cnt;
            }
            if (cnt % 2 != 0) continue;
            throw new ParseException("Time zone related format elements not allowed in DATE formatting", pos);
        }
        super.applyPattern(shrink ? pat.toString().replace("\uffff", "") : pat.toString());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof OraDATEFormat && super.equals(object);
    }

    public String format(DATE date) {
        return this.format(date, new StringBuffer(), new FieldPosition(1000)).toString();
    }

    public StringBuffer format(DATE date, StringBuffer toAppendTo, FieldPosition pos) {
        byte[] bytes = date.shareBytes();
        if (bytes.length != 7) {
            throw new IllegalArgumentException("DATE to be formatted is of wrong length");
        }
        Calendar cal = (Calendar)this.calendar.clone();
        cal.clear();
        cal.setTimeZone(this.UTC);
        int year = ((bytes[0] & 0xFF) - 100) * 100 + ((bytes[1] & 0xFF) - 100);
        cal.set(1, year);
        cal.set(2, bytes[2] - 1);
        cal.set(5, bytes[3]);
        cal.set(11, bytes[4] - 1);
        cal.set(12, bytes[5] - 1);
        cal.set(13, bytes[6] - 1);
        cal.set(14, 0);
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        ts.setNanos(0);
        this.calendar.setTimeZone(this.UTC);
        return super.format((Date)ts, toAppendTo, pos);
    }

    public DATE parseDATE(String text, ParsePosition pos) {
        this.calendar.setTimeZone(this.UTC);
        this.calendar.setTimeInMillis(new Date().getTime());
        Date date = super.parse(text, pos);
        long time = date.getTime();
        byte[] bytes = new byte[7];
        Calendar cal = Calendar.getInstance(this.UTC, Locale.US);
        cal.setTimeInMillis(time);
        int year = cal.get(1);
        bytes[0] = (byte)(year / 100 + 100);
        bytes[1] = (byte)(year % 100 + 100);
        bytes[2] = (byte)(cal.get(2) + 1);
        bytes[3] = (byte)cal.get(5);
        bytes[4] = (byte)(cal.get(11) + 1);
        bytes[5] = (byte)(cal.get(12) + 1);
        bytes[6] = (byte)(cal.get(13) + 1);
        return new DATE(bytes);
    }
}

