/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.nls;

import java.sql.Timestamp;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import oracle.i18n.text.OraSimpleDateFormat;
import oracle.i18n.util.OraLocaleInfo;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;

public class OraTIMESTAMPFormat
extends OraSimpleDateFormat {
    private static final int SIZE_TIMESTAMP = 11;
    private static final int SIZE_TIMESTAMP_NOFRAC = 7;
    private static final int BYTE_YEAR1 = 0;
    private static final int BYTE_YEAR2 = 1;
    private static final int BYTE_MONTH = 2;
    private static final int BYTE_DAY = 3;
    private static final int BYTE_HOUR = 4;
    private static final int BYTE_MINUTE = 5;
    private static final int BYTE_SECOND = 6;
    private static final int BYTE_NANOS1 = 7;
    private static final int BYTE_NANOS2 = 8;
    private static final int BYTE_NANOS3 = 9;
    private static final int BYTE_NANOS4 = 10;
    private TimeZone UTC = TimeZone.getTimeZone("UTC");
    private OraLocaleInfo localeInfo = null;
    private TimeZone dbTimeZone;

    public OraTIMESTAMPFormat(String pattern, OraLocaleInfo localeInfo) throws ParseException {
        this(pattern, localeInfo, null);
    }

    public OraTIMESTAMPFormat(String pattern, OraLocaleInfo localeInfo, String dbTZ) throws ParseException {
        super(pattern, localeInfo);
        this.localeInfo = localeInfo;
        this.applyPattern(pattern);
        if (dbTZ != null) {
            if (dbTZ.charAt(0) == '+' || dbTZ.charAt(0) == '-' ? (this.dbTimeZone = TimeZone.getTimeZone("GMT" + dbTZ)) == null : (this.dbTimeZone = TimeZone.getTimeZone(dbTZ)) == null) {
                throw new ParseException("Unrecognized DB time zone (" + dbTZ + ")", 0);
            }
        } else {
            this.dbTimeZone = null;
        }
    }

    public void applyPattern(String pattern) throws ParseException {
        if (this.localeInfo != null) {
            int cnt;
            int i;
            boolean shrink = false;
            String uc = pattern.toUpperCase(Locale.US);
            StringBuffer pat = new StringBuffer(pattern);
            int pos = -1;
            while ((pos = uc.indexOf("X", pos + 1)) >= 0) {
                if (pos > 0 && uc.charAt(pos - 1) == 'F') continue;
                i = -1;
                cnt = 0;
                while ((i = uc.indexOf(34, i + 1)) < pos && i != -1) {
                    ++cnt;
                }
                if (cnt % 2 != 0) continue;
                pat.setCharAt(pos, this.localeInfo.getOraTerritory().getDecimalCharacter().charAt(0));
            }
            pos = -1;
            while ((pos = uc.indexOf("SP", pos + 1)) >= 0) {
                i = -1;
                cnt = 0;
                while ((i = uc.indexOf(34, i + 1)) < pos && i != -1) {
                    ++cnt;
                }
                if (cnt % 2 != 0) continue;
                pat.setCharAt(pos, '\uffff');
                pat.setCharAt(pos + 1, '\uffff');
                shrink = true;
            }
            pos = -1;
            while ((pos = uc.indexOf("TH", pos + 1)) >= 0) {
                if (pos > 2 && uc.substring(pos - 3, pos + 2).equals("MONTH")) continue;
                i = -1;
                cnt = 0;
                while ((i = uc.indexOf(34, i + 1)) < pos && i != -1) {
                    ++cnt;
                }
                if (cnt % 2 != 0) continue;
                pat.setCharAt(pos, '\uffff');
                pat.setCharAt(pos + 1, '\uffff');
                shrink = true;
            }
            pos = -1;
            while ((pos = uc.indexOf("TZ", pos + 1)) >= 0 && pos <= uc.length() - 3) {
                char c = uc.charAt(pos + 2);
                if (c != 'R' && c != 'D' && c != 'H' && c != 'M') continue;
                i = -1;
                cnt = 0;
                while ((i = uc.indexOf(34, i + 1)) < pos && i != -1) {
                    ++cnt;
                }
                if (cnt % 2 != 0) continue;
                throw new ParseException("Time zone related format elements not allowed in TIMESTAMP formatting", pos);
            }
            super.applyPattern(shrink ? pat.toString().replace("\uffff", "") : pat.toString());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof OraTIMESTAMPFormat && super.equals(object);
    }

    public String format(TIMESTAMP date) {
        return this.format(date, new StringBuffer(), new FieldPosition(1000)).toString();
    }

    public StringBuffer format(TIMESTAMP date, StringBuffer toAppendTo, FieldPosition pos) {
        byte[] bytes = date.shareBytes();
        if (bytes.length != 7 && bytes.length != 11) {
            throw new IllegalArgumentException("TIMESTAMP to be formatted is of wrong length");
        }
        Calendar cal = (Calendar)this.calendar.clone();
        cal.clear();
        cal.setTimeZone(this.UTC);
        int year = ((bytes[0] & 0xFF) - 100) * 100 + ((bytes[1] & 0xFF) - 100);
        cal.set(1, year);
        cal.set(2, bytes[2] - 1);
        cal.set(5, bytes[3]);
        cal.set(11, bytes[4] - 1);
        cal.set(12, bytes[5] - 1);
        cal.set(13, bytes[6] - 1);
        cal.set(14, 0);
        int nanos = 0;
        if (bytes.length == 11) {
            nanos = ((bytes[7] & 0xFF) << 24) + ((bytes[8] & 0xFF) << 16) + ((bytes[9] & 0xFF) << 8) + (bytes[10] & 0xFF);
        }
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        ts.setNanos(nanos);
        this.calendar.setTimeZone(this.UTC);
        return super.format((Date)ts, toAppendTo, pos);
    }

    public String format(TIMESTAMPLTZ date) {
        return this.format(date, new StringBuffer(), new FieldPosition(1000)).toString();
    }

    public StringBuffer format(TIMESTAMPLTZ date, StringBuffer toAppendTo, FieldPosition pos) {
        byte[] bytes = date.shareBytes();
        if (bytes.length != 7 && bytes.length != 11) {
            throw new IllegalArgumentException("TIMESTAMPLTZ to be formatted is of wrong length");
        }
        Calendar cal = (Calendar)this.calendar.clone();
        cal.clear();
        if (this.dbTimeZone == null) {
            throw new IllegalArgumentException("Internal error: DB time zone not set");
        }
        cal.setTimeZone(this.dbTimeZone);
        int year = ((bytes[0] & 0xFF) - 100) * 100 + ((bytes[1] & 0xFF) - 100);
        cal.set(1, year);
        cal.set(2, bytes[2] - 1);
        cal.set(5, bytes[3]);
        cal.set(11, bytes[4] - 1);
        cal.set(12, bytes[5] - 1);
        cal.set(13, bytes[6] - 1);
        cal.set(14, 0);
        int nanos = 0;
        if (bytes.length == 11) {
            nanos = ((bytes[7] & 0xFF) << 24) + ((bytes[8] & 0xFF) << 16) + ((bytes[9] & 0xFF) << 8) + (bytes[10] & 0xFF);
        }
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        ts.setNanos(nanos);
        this.calendar.setTimeZone(TimeZone.getDefault());
        return super.format((Date)ts, toAppendTo, pos);
    }

    public TIMESTAMP parseTIMESTAMP(String text, ParsePosition pos) {
        this.calendar.setTimeZone(this.UTC);
        this.calendar.setTimeInMillis(new Date().getTime());
        Date date = super.parse(text, pos);
        long time = date.getTime();
        int nanos = date instanceof Timestamp ? ((Timestamp)date).getNanos() : 0;
        byte[] bytes = nanos > 0 ? new byte[11] : new byte[7];
        Calendar cal = Calendar.getInstance(this.UTC, Locale.US);
        cal.setTimeInMillis(time);
        int year = cal.get(1);
        bytes[0] = (byte)(year / 100 + 100);
        bytes[1] = (byte)(year % 100 + 100);
        bytes[2] = (byte)(cal.get(2) + 1);
        bytes[3] = (byte)cal.get(5);
        bytes[4] = (byte)(cal.get(11) + 1);
        bytes[5] = (byte)(cal.get(12) + 1);
        bytes[6] = (byte)(cal.get(13) + 1);
        if (nanos > 0) {
            bytes[7] = (byte)(nanos >> 24 & 0xFF);
            bytes[8] = (byte)(nanos >> 16 & 0xFF);
            bytes[9] = (byte)(nanos >> 8 & 0xFF);
            bytes[10] = (byte)(nanos & 0xFF);
        }
        return new TIMESTAMP(bytes);
    }

    public TIMESTAMPLTZ parseTIMESTAMPLTZ(String text, ParsePosition pos) {
        this.calendar.setTimeZone(TimeZone.getDefault());
        this.calendar.setTimeInMillis(new Date().getTime());
        Date date = super.parse(text, pos);
        long time = date.getTime();
        int nanos = date instanceof Timestamp ? ((Timestamp)date).getNanos() : 0;
        byte[] bytes = nanos > 0 ? new byte[11] : new byte[7];
        Calendar cal = Calendar.getInstance(this.dbTimeZone, Locale.US);
        cal.setTimeInMillis(time);
        int year = cal.get(1);
        bytes[0] = (byte)(year / 100 + 100);
        bytes[1] = (byte)(year % 100 + 100);
        bytes[2] = (byte)(cal.get(2) + 1);
        bytes[3] = (byte)cal.get(5);
        bytes[4] = (byte)(cal.get(11) + 1);
        bytes[5] = (byte)(cal.get(12) + 1);
        bytes[6] = (byte)(cal.get(13) + 1);
        if (nanos > 0) {
            bytes[7] = (byte)(nanos >> 24 & 0xFF);
            bytes[8] = (byte)(nanos >> 16 & 0xFF);
            bytes[9] = (byte)(nanos >> 8 & 0xFF);
            bytes[10] = (byte)(nanos & 0xFF);
        }
        return new TIMESTAMPLTZ(bytes);
    }
}

