/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql;

import java.awt.event.ActionEvent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.plsql.CompileArb;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controller.MenuManager;
import oracle.ide.controls.Toolbar;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.util.ArrayResourceBundle;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.browser.jdbc.PlSqlBaseNode;
import oracle.jdeveloper.cm.dt.browser.jdbc.TriggerNode;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.JCompiler;
import oracle.jdevimpl.cm.dt.config.ConnectionOptions;

public class PLSQLController
implements Controller {
    private static final Object LOCK = new Object();
    private static PLSQLController _controller;
    public static final int COMPILE_DEBUG_COMMAND;
    public JMenuItem compileMenu;
    public IdeAction actionCompileDebug;
    public JMenuItem compileDebugMenu = null;

    private PLSQLController() {
        this.createActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PLSQLController getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (_controller == null) {
                _controller = new PLSQLController();
            }
        }
        return _controller;
    }

    private void createActions() {
        JMenu runMenu = MenuManager.getJMenu((String)"Run");
        IdeAction action = IdeAction.get((int)JCompiler.MAKE_SELECTED_CMD_ID, null, (String)ConnectionArb.getString((int)304), (String)runMenu.getText(), null, (ArrayResourceBundle)CompArb.getInstance(), (int)6, null, (boolean)true);
        action.addController((Controller)this);
        this.actionCompileDebug = IdeAction.get((int)COMPILE_DEBUG_COMMAND, (String)StringUtils.stripMnemonic((String)CompileArb.getString(0)), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)CompileArb.getString(0))));
        this.actionCompileDebug.addController((Controller)this);
    }

    public void toggleButtons(Context context) {
        PlSqlBaseNode n;
        if (context.getNode() instanceof PlSqlBaseNode && !(n = (PlSqlBaseNode)context.getNode()).getObjectType().equals("TYPE")) {
            Toolbar t = context.getView().getToolbar();
            if (context.getNode() instanceof PlSqlBaseNode && n.isValid()) {
                t.getComponent(0).setEnabled(true);
                t.getComponent(1).setEnabled(true);
            } else if (context.getNode() instanceof TriggerNode) {
                t.getComponent(0).setEnabled(true);
                t.getComponent(1).setEnabled(true);
            } else {
                t.getComponent(0).setEnabled(false);
                t.getComponent(1).setEnabled(false);
            }
        }
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        return cmdId == JCompiler.MAKE_SELECTED_CMD_ID || cmdId == COMPILE_DEBUG_COMMAND;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == JCompiler.MAKE_SELECTED_CMD_ID || cmdId == COMPILE_DEBUG_COMMAND) {
            Element[] selection = context.getSelection();
            for (int i = 0; i < selection.length; ++i) {
                Node node = (Node)selection[i];
                node.markDirty(true);
            }
            IdeSettings settings = Ide.getSettings();
            ConnectionOptions opts = (ConnectionOptions)settings.getData("ConnectionOptions");
            boolean oldDebug = opts.isGeneratePlSqlDebugInfo();
            opts.setGeneratePlSqlDebugInfo(cmdId == COMPILE_DEBUG_COMMAND);
            IdeAction fileSaveAction = IdeActions.getFileSaveAction();
            fileSaveAction.setEnabled(true);
            fileSaveAction.actionPerformed(new ActionEvent(this, 1001, ""));
            opts.setGeneratePlSqlDebugInfo(oldDebug);
            this.toggleButtons(context);
            return true;
        }
        return false;
    }

    static {
        COMPILE_DEBUG_COMMAND = Ide.findOrCreateCmdID((String)"oracle.dbdev.compilemenu.CompileAddin.COMPILE_DEBUG");
    }
}

