/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.text.JTextComponent;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.controls.RaptorDnD;
import oracle.dbtools.raptor.plsql.CompileArb;
import oracle.dbtools.raptor.plsql.PLSQLController;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.JCompiler;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.run.RunArb;

public class PLSQLEditorToolbar
implements EditorPlugin {
    private Toolbar _toolbar;

    public void install(BasicEditorPane basicEditorPane) {
        CodeEditor parent = CodeEditor.getCodeEditor((BasicEditorPane)basicEditorPane);
        Toolbar toolbar = parent.getToolbar();
        RaptorDnD dnd = new RaptorDnD((JTextComponent)basicEditorPane);
        DBObject dbObject = new DBObject(parent.getContext().getNode());
        int runCmd = Ide.findOrCreateCmdID((String)"RunSelectionCommand");
        int debugCmd = Ide.findOrCreateCmdID((String)"DebugSelectionCommand");
        IdeAction a = IdeAction.get((int)runCmd);
        if (dbObject.getObjectType() != null) {
            if (!dbObject.getObjectType().equals("TRIGGER") && !dbObject.getObjectType().equals("TYPE")) {
                toolbar.add((Component)this.createButton(RunArb.getIcon((int)3), Translate.translate("Run"), runCmd, dbObject.getSchemaObject() != null));
                toolbar.add((Component)this.createButton(DbgArb.getIcon((int)5), Translate.translate("Debug"), debugCmd, dbObject.getSchemaObject() != null));
                toolbar.addSeparator();
            }
            toolbar.add((Component)this.createButton(CompArb.getIcon((int)19), Translate.translate("Compile"), JCompiler.MAKE_SELECTED_CMD_ID, true));
            toolbar.add((Component)this.createButton(CompileArb.getIcon(1), StringUtils.stripMnemonic((String)CompileArb.getString(0)), PLSQLController.COMPILE_DEBUG_COMMAND, true));
            PLSQLController.getInstance().toggleButtons(parent.getContext());
        }
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    public JButton createButton(Icon icon, String toolTip, int cmdid, boolean enabled) {
        JButton ret = new JButton();
        ret.setIcon(icon);
        ret.setToolTipText(toolTip);
        ret.addActionListener((ActionListener)IdeAction.get((int)cmdid));
        ret.setEnabled(enabled);
        IdeAction.get((int)cmdid).setEnabled(enabled);
        return ret;
    }
}

