/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.query;

public class Column {
    private String _name;
    private String _onClickClass;
    private String _format;
    private float _align;
    private float _vAlign;

    public Column() {
    }

    public Column(String name, String onClick, String align, String vAlign, String format) {
        this._name = name;
        if (onClick != null) {
            this._onClickClass = onClick;
        }
        if (align != null) {
            this.setAlign(align);
        }
        if (vAlign != null) {
            this.setVAlign(vAlign);
        }
        if (format != null) {
            this._format = format;
        }
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setOnClickClass(String onClickClass) {
        this._onClickClass = onClickClass;
    }

    public String getOnClickClass() {
        return this._onClickClass;
    }

    public void setAlign(String align) {
        if (align.equals("LEFT")) {
            this._align = 0.0f;
        } else if (align.equals("RIGHT")) {
            this._align = 1.0f;
        } else if (align.equals("CENTER")) {
            this._align = 0.5f;
        }
    }

    public float getAlign() {
        return this._align;
    }

    public void setVAlign(String vAlign) {
        if (vAlign.equals("TOP")) {
            this._vAlign = 0.0f;
        } else if (vAlign.equals("BOTTOM")) {
            this._vAlign = 1.0f;
        }
    }

    public float getVAlign() {
        return this._vAlign;
    }

    public void setFormat(String format) {
        this._format = format;
    }

    public String getFormat() {
        return this._format;
    }

    public String toXML() {
        StringBuilder sb = new StringBuilder();
        sb.append("<column");
        if (this._format != null) {
            sb.append(" colFormat=\"" + this._format + "\"");
        }
        if (this._align == 0.0f) {
            sb.append(" align=\"LEFT\"");
        } else if (this._align == 1.0f) {
            sb.append(" align=\"RIGHT\"");
        } else if (this._align == 0.5f) {
            sb.append(" align=\"CENTER\"");
        }
        if (this._vAlign == 0.0f) {
            sb.append(" valign=\"TOP\"");
        } else if (this._vAlign == 1.0f) {
            sb.append(" valign=\"BOTTOM\"");
        }
        sb.append(">");
        sb.append("<colName><![CDATA[" + this._name + "]]></colName>");
        sb.append("</column>");
        return sb.toString();
    }
}

