/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.query;

import java.util.ArrayList;
import java.util.HashMap;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Column;
import oracle.dbtools.raptor.query.Parser;
import oracle.dbtools.raptor.utils.XMLHelper;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Query {
    private float minversion = 0.0f;
    private float maxversion = 0.0f;
    private String sql;
    private ArrayList<Column> cols;
    private ArrayList<Bind> binds;
    private ArrayList<String> _skipCols;

    public Query(Node node) {
        this.buildQuery(node);
    }

    public Query() {
        this.binds = new ArrayList();
        this.cols = new ArrayList();
    }

    public void setMinversion(float minversion) {
        this.minversion = minversion;
    }

    public float getMinversion() {
        return this.minversion;
    }

    public void setMaxversion(float maxversion) {
        this.maxversion = maxversion;
    }

    public float getMaxversion() {
        return this.maxversion;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    public void setBinds(ArrayList<Bind> binds) {
        this.binds = binds;
    }

    public ArrayList<Bind> getBinds() {
        if (this.binds != null) {
            return this.binds;
        }
        return Parser.getInstance().getBinds(this.sql);
    }

    public HashMap getBindValues() {
        HashMap<String, Object> bindVals = new HashMap<String, Object>();
        ArrayList<Bind> sqlBinds = Parser.getInstance().getBinds(this.sql);
        if (this.binds.isEmpty()) {
            this.binds = sqlBinds;
        }
        if (this.binds.isEmpty()) {
            return bindVals;
        }
        for (int i = 0; i < this.binds.size(); ++i) {
            String name = this.binds.get(i).getName();
            String value = this.binds.get(i).getValue();
            if (value.equals("NULL_VALUE")) {
                bindVals.put(name, DBUtil.NULL_VALUE);
                continue;
            }
            bindVals.put(name, value);
        }
        return bindVals;
    }

    public void setCols(ArrayList<Column> cols) {
        this.cols = cols;
    }

    public ArrayList<Column> getCols() {
        return this.cols;
    }

    public HashMap getColValues() {
        HashMap<String, Column> colVals = new HashMap<String, Column>();
        if (this.cols.isEmpty()) {
            return colVals;
        }
        for (int i = 0; i < this.cols.size(); ++i) {
            String name = this.cols.get(i).getName();
            colVals.put(name, this.cols.get(i));
        }
        return colVals;
    }

    public void buildQuery(Node node) {
        String sql;
        String max;
        String min = XMLHelper.getAttributeNode(node, "minversion");
        if (min != null && !min.equals("")) {
            this.setMinversion(Float.valueOf(min).floatValue());
        }
        if ((max = XMLHelper.getAttributeNode(node, "maxversion")) != null && !max.equals("")) {
            this.setMaxversion(Float.valueOf(max).floatValue());
        }
        if ((sql = XMLHelper.getNodeValue(node, "sql")) != null) {
            this.setSql(sql);
        }
        ArrayList<Bind> binds = this.getNodeBinds(node);
        this.setBinds(binds);
        ArrayList<Column> cols = this.getNodeCols(node);
        this.setCols(cols);
        String skipCols = XMLHelper.getNodeValue(node, "nodisplay");
        this.setSkipCols(skipCols);
    }

    public void setSkipCols(String skipCols) {
        String[] cols = skipCols.split(",");
        ArrayList<String> colArr = new ArrayList<String>();
        for (int i = 0; i < cols.length; ++i) {
            colArr.add(cols[i]);
        }
        this.setSkipCols(colArr);
    }

    public void setSkipCols(ArrayList<String> skipCols) {
        this._skipCols = skipCols;
    }

    public ArrayList<String> getSkipCols() {
        return this._skipCols;
    }

    private ArrayList<Bind> getNodeBinds(Node node) {
        ArrayList<Bind> binds = new ArrayList<Bind>();
        if (XMLHelper.getChildNode(node, "binds") == null) {
            return binds;
        }
        Node n1 = XMLHelper.getChildNode(node, "binds");
        NodeList children = n1.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!children.item(i).getNodeName().equals("bind")) continue;
            String name = XMLHelper.getAttributeNode(children.item(i), "id");
            String type = XMLHelper.getNodeValue(children.item(i), "type");
            String prompt = XMLHelper.getNodeValue(children.item(i), "prompt");
            String value = XMLHelper.getNodeValue(children.item(i), "value");
            String tooltip = XMLHelper.getNodeValue(children.item(i), "tooltip");
            Bind oBind = new Bind(name, type, prompt, value, tooltip);
            binds.add(oBind);
        }
        return binds;
    }

    private ArrayList<Column> getNodeCols(Node node) {
        ArrayList<Column> cols = new ArrayList<Column>();
        if (XMLHelper.getChildNode(node, "columns") == null) {
            return cols;
        }
        Node n1 = XMLHelper.getChildNode(node, "columns");
        NodeList children = n1.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String name = XMLHelper.getNodeValue(children.item(i), "colName");
            String onClick = XMLHelper.getAttributeNode(children.item(i), "onClickClass");
            String align = XMLHelper.getAttributeNode(children.item(i), "hAlign");
            String vAlign = XMLHelper.getAttributeNode(children.item(i), "vAlign");
            String format = XMLHelper.getAttributeNode(children.item(i), "colFormat");
            Column oCol = new Column(name, onClick, align, vAlign, format);
            cols.add(oCol);
        }
        return cols;
    }

    public static ArrayList<Query> getQueries(Node node) {
        ArrayList<Query> ret = new ArrayList<Query>();
        if (node != null) {
            NodeList children = node.getChildNodes();
            for (int i = 0; children != null && i < children.getLength(); ++i) {
                if (!children.item(i).getNodeName().equalsIgnoreCase("query")) continue;
                Query qObject = new Query(children.item(i));
                ret.add(qObject);
            }
        }
        return ret;
    }

    public String toXML() {
        StringBuilder sb = new StringBuilder();
        sb.append("\t\t<query");
        if (this.minversion > 0.0f) {
            sb.append(" minversion=\"" + this.minversion + "\"");
        }
        if (this.maxversion > 0.0f) {
            sb.append(" maxversion=\"" + this.maxversion + "\"");
        }
        sb.append(">\n");
        sb.append("\t\t\t<sql><![CDATA[" + this.sql + "]]></sql>\n");
        if (this.binds.size() > 0) {
            sb.append("\t\t\t<binds>");
            for (Bind bind : this.binds) {
                sb.append(bind.toXML());
            }
            sb.append("</binds>\n");
        }
        if (this.cols.size() > 0) {
            sb.append("\t\t\t<columns>");
            for (Column col : this.cols) {
                sb.append(col.toXML());
            }
            sb.append("</columns>\n");
        }
        sb.append("\t\t</query>\n");
        return sb.toString();
    }
}

