/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetFormatter;
import oracle.dbtools.raptor.scriptrunner.SQLCommand;
import oracle.dbtools.raptor.scriptrunner.SQLCommandRunner;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.util.Debug;
import oracle.javatools.db.ora.OracleDatabase;

public class SQL
extends SQLCommandRunner {
    public SQL(SQLCommand cmd, BufferedOutputStream out) {
        super(cmd, out);
    }

    public void run() {
        try {
            Debug.debug(this.cmd);
            if (this.cmd.getResultsType() == null) {
                this.execute(true);
            } else if (this.cmd.getResultsType().equals("2")) {
                this.reportDML(this.cmd.getStmtId(), this.processDML());
            } else if (this.cmd.getResultsType().equals("1")) {
                this.executeQuery();
            } else if (this.cmd.getStmtId().equals("21")) {
                this.conn.commit();
                this.report(Translate.translate("commited"));
            } else if (this.cmd.getStmtId().equals("68")) {
                this.conn.rollback();
                this.report(Translate.translate("rolledback"));
            } else if (this.cmd.getResultsType().equals("3")) {
                this.execute(false);
                this.reportThreeWord();
            } else {
                Debug.error("else in SQL was reached with " + this.cmd);
                this.execute(true);
            }
        }
        catch (SQLException se) {
            int offset;
            boolean defaultErrorHandling = true;
            StringBuffer sb = new StringBuffer();
            if ((this.cmd.getResultsType() != null && this.cmd.getResultsType().equals("1") || this.cmd.getStmtId().equals("48") || this.cmd.getStmtId().equals("88") || this.cmd.getStmtId().equals("31") || this.cmd.getStmtId().equals("72") || this.cmd.getStmtId().equals("51") || this.cmd.getStmtId().equals("92")) && !this.cmd.getSQLOrig().toUpperCase().startsWith("DESC") && (offset = DBUtil.getInstance().getErrorOffset(this.conn, this.cmd.getSql())) >= 0) {
                String[] lines = this.cmd.getSql().substring(0, offset).split("\n");
                int col = lines[lines.length - 1].length();
                int line = lines.length;
                Object[] oarray = new Object[]{new Integer(this.cmd.startLine + 1), this.cmd.getSql(), new Integer(line), new Integer(col), ScriptRunnerDbArb.format(23, se.getMessage())};
                this.report(ScriptRunnerDbArb.format(39, oarray));
                defaultErrorHandling = false;
            }
            if (defaultErrorHandling) {
                this.report(ScriptRunnerDbArb.format(16, new Integer(this.cmd.startLine + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format(23, se.getMessage())));
            }
            this.doWhenever(true);
        }
        catch (IOException ioe) {
            this.report(ScriptRunnerDbArb.format(16, new Integer(this.cmd.startLine + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format(15, ioe.getMessage())));
            this.doWhenever(false);
        }
    }

    public void reportDML(String dmlType, int num) throws IOException {
        String action = null;
        if (dmlType.equals("48")) {
            action = Translate.translate("inserted");
        } else if (dmlType.equals("88")) {
            action = Translate.translate("updated");
        } else if (dmlType.equals("31")) {
            action = Translate.translate("deleted");
        } else if (dmlType.equals("51")) {
            action = Translate.translate("merged");
        }
        action = num + " " + Translate.translate("rows") + " " + action;
        this.report(action);
    }

    public int processDML() throws SQLException {
        int rowsEffected;
        try {
            this.stmt = this.conn.prepareStatement(this.cmd.getSql());
            this.stmt.setEscapeProcessing(false);
            this.dbUtil.bind(this.stmt, this.cmd.getBinds());
            rowsEffected = this.stmt.executeUpdate();
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            if (this.stmt != null) {
                this.stmt.close();
            }
        }
        return rowsEffected;
    }

    public void executeQuery() throws SQLException, IOException {
        ResultSet rset = null;
        try {
            this.stmt = this.conn.prepareStatement(this.cmd.getSql());
            this.stmt.setEscapeProcessing(false);
            this.dbUtil.bind(this.stmt, this.cmd.getBinds());
            rset = this.stmt.executeQuery();
            ResultSetFormatter rFormat = new ResultSetFormatter();
            int cnt = this.cmd.getSql().indexOf("/*html*/") > 0 ? rFormat.rset2html(rset, this.out) : (this.cmd.getSql().indexOf("/*csv*/") > 0 ? rFormat.rset2csv(rset, this.out) : (this.cmd.getSql().indexOf("/*xml*/") > 0 ? rFormat.rset2xml(rset, this.out) : rFormat.rset2sqlplus(rset, this.out)));
            this.report("\n" + cnt + " " + Translate.translate("rows_selected") + "\n");
            rset.close();
            this.stmt.close();
        }
        catch (SQLException se) {
            if (this.stmt != null) {
                this.stmt.close();
            }
            if (rset != null) {
                rset.close();
            }
            throw se;
        }
    }

    private String firstTwo(String command) {
        String retVal = "";
        String[] stringArray = command.trim().split("[ \t\n\r]");
        if (stringArray != null) {
            if (stringArray.length > 0) {
                retVal = stringArray[0];
            }
            if (stringArray.length > 1) {
                retVal = retVal + " " + stringArray[1];
            }
        }
        return retVal;
    }

    public void execute(boolean status) throws SQLException, IOException {
        try {
            SQLWarning warn;
            this.st = this.conn.createStatement();
            this.st.setEscapeProcessing(false);
            boolean retVal = this.st.execute(this.cmd.getSql().trim());
            if (this.cmd.getSql().toLowerCase().indexOf(" set nls") > 0) {
                NLSUtils.populateNLS((OracleDatabase)Connections.getInstance().getDatabase(this.conn));
            }
            if ((warn = this.st.getWarnings()) == null && status) {
                this.report(ScriptRunnerDbArb.format(24, this.firstTwo(this.cmd.getSql())));
            } else if (warn != null) {
                String warnText = ScriptRunnerDbArb.format(22, this.firstTwo(this.cmd.getSql()));
                while (warn != null) {
                    warnText = warnText + "\n" + ScriptRunnerDbArb.format(12, warn.getMessage());
                    warn = warn.getNextWarning();
                }
                this.report(ScriptRunnerDbArb.format(16, new Integer(this.cmd.startLine + 1), this.cmd.getSQLOrig(), warnText));
            }
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            if (this.st != null) {
                this.st.close();
            }
        }
    }

    public void reportObjectAction() {
    }

    public void reportThreeWord() {
        String[] tokens = null;
        tokens = this.cmd.getSql().split("[ \n\r\t]");
        this.report(ScriptRunnerDbArb.format(24, tokens[0] + " " + tokens[1] + " " + tokens[2]));
    }
}

