/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ScriptRunnerContext {
    private Connection baseConnection = null;
    private boolean closeConnection = false;
    private boolean topLevel = false;
    private Map map = null;
    private boolean exited = false;
    private int osError = 0;
    private int sqlError = 0;
    private boolean escape = false;
    private char escapeChar = (char)92;
    private char substitutionChar = (char)38;
    private boolean substitutionOn = true;
    private boolean scanOn = true;
    private char terminateChar = (char)46;
    private URL _lastUrl = null;

    public ScriptRunnerContext() {
        this.reInitOnExit();
    }

    public void reInitOnExit() {
        this.closeConnection = false;
        this.topLevel = false;
        this.map = Collections.synchronizedMap(new HashMap());
        this.exited = false;
        this.osError = 0;
        this.sqlError = 0;
        this.escape = false;
        this.substitutionChar = (char)38;
        this.substitutionOn = true;
        this.scanOn = true;
    }

    public void reInitNoExit() {
        this.closeConnection = false;
        this.topLevel = false;
        this.exited = false;
    }

    public Connection getBaseConnection() {
        return this.baseConnection;
    }

    public void setBaseConnection(Connection baseConnection) {
        this.baseConnection = baseConnection;
    }

    public boolean getExited() {
        return this.exited;
    }

    public void setExited(boolean exited) {
        this.exited = exited;
    }

    public boolean getEscape() {
        return this.escape;
    }

    public void setEscape(boolean escape) {
        this.escape = escape;
    }

    public boolean getCloseConnection() {
        return this.closeConnection;
    }

    public void setCloseConnection(boolean closeConnection) {
        this.closeConnection = closeConnection;
    }

    public boolean getTopLevel() {
        return this.topLevel;
    }

    public void setTopLevel(boolean topLevel) {
        this.topLevel = topLevel;
    }

    public int getOsError() {
        return this.osError;
    }

    public void setOsError(int osError) {
        this.osError = osError;
    }

    public int getSqlError() {
        return this.sqlError;
    }

    public void setSqlError(int sqlError) {
        this.sqlError = sqlError;
    }

    public Map getMap() {
        return this.map;
    }

    public void setMap(Map map) {
        this.map = map;
    }

    public char getSubstitutionChar() {
        return this.substitutionChar;
    }

    public void setSubstitutionChar(char substitutionChar) {
        this.substitutionChar = substitutionChar;
    }

    public boolean getSubstitutionOn() {
        return this.substitutionOn;
    }

    public void setSubstitutionOn(boolean substitutionOn) {
        this.substitutionOn = substitutionOn;
    }

    public boolean getScanOn() {
        return this.scanOn;
    }

    public void setScanOn(boolean scanOn) {
        this.scanOn = scanOn;
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }

    public void setEscapeChar(char escapeChar) {
        this.escapeChar = escapeChar;
    }

    public char getTerminateChar() {
        return this.terminateChar;
    }

    public void setTerminateChar(char terminateChar) {
        this.terminateChar = terminateChar;
    }

    public String getLastDirName() throws IOException {
        if (this._lastUrl == null) {
            throw new IOException("_lastUrl==null");
        }
        File file = new File(this._lastUrl.getFile());
        String pathname = file.getCanonicalPath();
        try {
            if (!file.isDirectory()) {
                if (pathname.indexOf(File.separator) == -1) {
                    throw new IOException("No directory in" + pathname);
                }
                pathname = pathname.substring(0, pathname.lastIndexOf(File.separator));
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return pathname;
    }

    public URL getLastUrl() {
        return this._lastUrl;
    }

    public void setLastUrl(URL lastUrl) {
        this._lastUrl = lastUrl;
    }
}

