/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.IOException;
import java.io.InputStream;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.ide.util.Assert;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class AbstractFolderedXml {
    public abstract void openFolder(String var1, String var2, String var3, Node var4);

    public abstract void closeFolder();

    public abstract void newItem(Node var1);

    private void processFolder(Node node) {
        String name = XMLHelper.getNodeValue(node, "name");
        String desc = XMLHelper.getNodeValue(node, "description");
        String tip = XMLHelper.getNodeValue(node, "tip");
        this.openFolder(name, desc, tip, node);
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeName().equalsIgnoreCase("folder")) {
                this.processFolder(children.item(i));
                continue;
            }
            if (children.item(i).getNodeName().equalsIgnoreCase("item")) {
                this.newItem(children.item(i));
                continue;
            }
            if (children.item(i).getNodeName().equalsIgnoreCase("description") || children.item(i).getNodeName().equalsIgnoreCase("name")) continue;
            Assert.println((String)("Folder:Unsupported node in report.xml:" + children.item(i).getNodeName()));
        }
    }

    private void processNode(Node node) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeName().equalsIgnoreCase("folder")) {
                this.processFolder(children.item(i));
                this.closeFolder();
                continue;
            }
            if (children.item(i).getNodeName().equalsIgnoreCase("item")) {
                this.newItem(children.item(i));
                continue;
            }
            Assert.println((String)("Unknown Node:" + children.item(i).getNodeType() + ":" + children.item(i).getNodeValue()));
        }
    }

    public void processXML(InputStream in) {
        DOMParser parser = new DOMParser();
        parser.setPreserveWhitespace(false);
        try {
            parser.parse(in);
        }
        catch (XMLParseException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        XMLDocument document = parser.getDocument();
        NodeList rootNodes = document.getChildNodes();
        for (int i = 0; i < rootNodes.getLength(); ++i) {
            this.processNode(rootNodes.item(i));
        }
    }

    public static void main(String[] args) {
    }
}

