/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;
import oracle.dbtools.raptor.utils.TCPTNSEntry;
import oracle.ide.natives.NativeHandler;
import oracle.ide.natives.registry.RegistryException;
import oracle.ide.natives.registry.RegistryKey;
import oracle.ide.natives.registry.RegistryNotAvailableException;
import oracle.ide.util.Assert;
import oracle.javatools.util.EnvironmentVariables;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdeveloper.cm.ConnectionWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TNSHelper {
    public static final String ENV_OH = "ORACLE_HOME";
    public static final String ENV_TA = "TNS_ADMIN";
    private static final String ITEM_END = ")))";
    private static long lastModified = 0L;
    public static final String FILE_TNS = System.getProperty("file.separator") + "network" + System.getProperty("file.separator") + "admin" + System.getProperty("file.separator") + "tnsnames.ora";
    private static ArrayList<TCPTNSEntry> entries = null;
    private static Logger logger = Logger.getLogger("oracle.dbtools.raptor.utils");
    private static boolean decision = true;
    private static boolean remember = false;

    private static File getTNSFileContent() throws IOException, NotDirtyException {
        logger.finest("getTNSFileContent - START");
        File tnsFile = null;
        tnsFile = new File(System.getProperty("user.home") + System.getProperty("file.separator") + ".tnsnames.ora");
        if (!tnsFile.exists()) {
            String ta = EnvironmentVariables.getVariable((String)ENV_TA);
            tnsFile = new File(ta + System.getProperty("file.separator") + "tnsnames.ora");
        }
        if (!tnsFile.exists() && !System.getProperty("os.name").startsWith("Windows")) {
            tnsFile = new File("/etc/tnsnames.ora");
        }
        if (!tnsFile.exists()) {
            String oh = EnvironmentVariables.getVariable((String)ENV_OH);
            tnsFile = new File(oh + System.getProperty("file.separator") + "network" + System.getProperty("file.separator") + "admin" + System.getProperty("file.separator") + "tnsnames.ora");
        }
        if (!tnsFile.exists() && System.getProperty("os.name").startsWith("Windows")) {
            String OH = null;
            try {
                RegistryKey rk2;
                String key = "SOFTWARE\\ORACLE";
                String homeKey = null;
                RegistryKey rk = NativeHandler.getRegistry().getLocalMachineKey().openKey(key, 131097L);
                Iterator iter = rk.iterateSubKeys();
                while (iter.hasNext()) {
                    Object o = iter.next();
                    o.toString();
                    try {
                        String temp = key + "\\" + o.toString();
                        rk2 = NativeHandler.getRegistry().getLocalMachineKey().openKey(temp, 131097L);
                        homeKey = rk2.getStringValue("ORACLE_HOME_KEY");
                    }
                    catch (RegistryException e) {
                        System.err.println("Error:" + e.getMessage());
                    }
                }
                if (homeKey != null) {
                    rk2 = NativeHandler.getRegistry().getLocalMachineKey().openKey(homeKey, 131097L);
                    OH = rk2.getStringValue(ENV_OH);
                }
            }
            catch (RegistryNotAvailableException e) {
            }
            catch (RegistryException e) {
                System.out.println("Error:" + e.getMessage());
            }
            if (OH != null) {
                tnsFile = new File(OH + System.getProperty("file.separator") + "network" + System.getProperty("file.separator") + "admin" + System.getProperty("file.separator") + "tnsnames.ora");
            }
        }
        if (!tnsFile.exists()) {
            return null;
        }
        if (tnsFile.lastModified() == lastModified) {
            throw new NotDirtyException();
        }
        lastModified = tnsFile.lastModified();
        logger.finest("getTNSFileContent - END");
        return tnsFile;
    }

    private static ArrayList<TCPTNSEntry> getTNSEntries(File fileContent) throws IOException {
        logger.finest("getTNSItems - START");
        boolean startOfItem = false;
        ArrayList<TCPTNSEntry> lstItems = new ArrayList<TCPTNSEntry>();
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(fileContent)));
        int bracketCount = 0;
        String buffer = null;
        StringBuilder currentEntry = new StringBuilder();
        TCPTNSEntry entry = null;
        String name = null;
        String desc = null;
        while ((buffer = in.readLine()) != null) {
            if (buffer.indexOf(35) == 0) continue;
            for (int i = 0; i < buffer.length(); ++i) {
                if (buffer.charAt(i) == '(') {
                    ++bracketCount;
                    continue;
                }
                if (buffer.charAt(i) != ')') continue;
                --bracketCount;
            }
            currentEntry.append(buffer);
            if (bracketCount != 0) continue;
            try {
                name = currentEntry.substring(0, currentEntry.indexOf("=")).trim();
                if (name.indexOf(40) > -1) {
                    String s = "1";
                    s = "2";
                }
                desc = currentEntry.substring(currentEntry.indexOf("=") + 1);
                if (name.trim().toLowerCase().equals("ifile")) {
                    try {
                        String cwd = fileContent.getParent() + File.separator;
                        File iFile = new File(cwd + desc);
                        if (!iFile.exists()) {
                            iFile = new File(desc);
                        }
                        if (iFile.exists()) {
                            lstItems.addAll(TNSHelper.getTNSEntries(iFile));
                        } else {
                            System.err.print("ifile not found" + desc);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    currentEntry.setLength(0);
                    continue;
                }
                if (name.indexOf(40) != -1 || name.length() <= 0 || desc.trim().length() <= 0) continue;
                entry = new TCPTNSEntry(name, desc);
                lstItems.add(entry);
                currentEntry.setLength(0);
            }
            catch (Exception e) {}
        }
        in.close();
        entries = lstItems;
        logger.finest("getTNSItems - END");
        return lstItems;
    }

    public static ArrayList<TCPTNSEntry> getTNSEntries() {
        logger.finest("getTNSEntries - START");
        Assert.startTiming((String)TNSHelper.class.toString(), (String)".getTNSEntries", (boolean)false);
        if (entries == null) {
            entries = new ArrayList();
        }
        ArrayList<TCPTNSEntry> ret = entries;
        try {
            File contents = TNSHelper.getTNSFileContent();
            if (contents != null) {
                ret = TNSHelper.getTNSEntries(contents);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.endTiming((String)TNSHelper.class.toString(), (String)".getTNSEntries", (String)TNSHelper.class.toString(), (boolean)false);
        logger.finest("getTNSEntries - END");
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        System.out.println("OH=" + EnvironmentVariables.getVariable((String)ENV_OH));
        System.out.println("TA=" + EnvironmentVariables.getVariable((String)ENV_TA));
        File contents = TNSHelper.getTNSFileContent();
        TCPTNSEntry[] entries = (TCPTNSEntry[])TNSHelper.getTNSEntries(contents).toArray();
        for (int i = 0; i < entries.length; ++i) {
            System.out.println(i + ":" + entries[i].getJDBCUrl());
            ConnectionWrapper wrapper = null;
            try {
                ConnectionDescriptor cd = new ConnectionDescriptor();
                cd.put((Object)"ConnectionType", (Object)"JDBC");
                cd.put((Object)"DeployPassword", (Object)"false");
                cd.put((Object)"JdbcDriver", (Object)"oracle.jdbc.driver.OracleDriver");
                cd.put((Object)"ORACLE_JDBC_TYPE", (Object)"thin");
                cd.put((Object)"user", (Object)"scott");
                cd.put((Object)"password", (Object)"tiger");
                cd.put((Object)"Role", (Object)"");
                cd.put((Object)"URL", (Object)entries[i].getJDBCUrl());
                ConnectionManager cm = ConnectionManager.getInstance();
                wrapper = cm.getConnection(cd);
                Iterator iter = wrapper.getPresentationIterator();
                while (iter.hasNext()) {
                    wrapper.testPresentation((String)iter.next());
                }
                wrapper.closeConnection();
                wrapper = null;
                continue;
            }
            catch (Throwable t) {
                System.out.println(t.getMessage());
                continue;
            }
            finally {
                if (wrapper != null) {
                    try {
                        wrapper.closeConnection();
                    }
                    catch (Exception ex) {}
                }
            }
        }
    }

    private static class NotDirtyException
    extends Exception {
        private NotDirtyException() {
        }
    }
}

