/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;

public class Translate {
    private static Properties props = null;
    private static BufferedOutputStream out = null;
    private static final String propName = "raptor.translate";
    private static boolean writable = false;
    private static boolean pendingWrite = false;
    private static Timer writeTimer = null;

    public static synchronized void init() {
        boolean bl = writable = System.getProperty(propName) != null;
        if (writeTimer == null && writable) {
            writeTimer = new Timer();
        }
        if (props != null && !writable) {
            return;
        }
        try {
            if (props == null) {
                props = new Properties();
            }
            props.loadFromXML(Translate.class.getResourceAsStream("prompts.xml"));
            if (writable) {
                props.loadFromXML(new FileInputStream(System.getProperty(propName)));
            }
        }
        catch (Exception e) {
            System.err.println("Could not load Transation file.");
        }
    }

    public static String translate(String s) {
        String ret;
        if (s == null) {
            return null;
        }
        Translate.init();
        String string = ret = props == null ? null : (String)props.get(s);
        if (ret == null) {
            ret = s.replace('_', ' ');
            props.put(s, ret);
            if (writable && !pendingWrite) {
                pendingWrite = true;
                writeTimer.schedule((TimerTask)Translate.getWriteTask(), 1000L);
            }
        }
        return ret;
    }

    public static WriteTask getWriteTask() {
        Translate t = new Translate();
        return t.getNewWriteTask();
    }

    public WriteTask getNewWriteTask() {
        return new WriteTask();
    }

    public static void main(String[] args) {
        System.out.println("file:" + Translate.translate("file"));
        System.out.println("help_me:" + Translate.translate("help_me"));
    }

    public class WriteTask
    extends TimerTask {
        public void run() {
            try {
                out = new BufferedOutputStream(new FileOutputStream(System.getProperty(Translate.propName)));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            if (out != null) {
                try {
                    props.storeToXML((OutputStream)out, "Generated On:", "UTF-8");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            pendingWrite = false;
        }
    }
}

