/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.raptor.dialogs.actions.ActionHelpProvider;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditorAddin;
import oracle.ide.ceditor.options.FontSizeOptions;
import oracle.ide.config.ClientSetting;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.util.IdeUtil;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Database;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.editor.EditorProperties;
import oracle.jdeveloper.cm.dt.browser.jdbc.DatabaseNode;
import oracle.jdeveloper.cm.dt.browser.jdbc.OCBBaseNode;
import oracle.jdeveloper.cm.dt.wizard.DBWizardFactoryRegistry;

public class UIUtils {
    public static void showPanelAsDialog(JPanel panel, String title, ActionListener listener) {
        UIUtils.showPanelAsDialog(panel, title, listener, 14);
    }

    public static void showPanelAsTabbedDialog(JPanel[] panel, String[] title, String dialogTitle, ActionListener listener) {
        UIUtils.showPanelAsTabbedDialog(panel, title, dialogTitle, listener, null, null);
    }

    public static void showPanelAsTabbedDialog(JPanel[] panel, String[] title, String dialogTitle, ActionListener listener, ActionHelpProvider provider) {
        UIUtils.showPanelAsTabbedDialog(panel, title, dialogTitle, listener, provider, null);
    }

    public static void showPanelAsTabbedDialog(JPanel[] panel, String[] title, String dialogTitle, ActionListener listener, ActionHelpProvider provider, ChangeListener chgListener) {
        final CustomTabbedPane tabbed = new CustomTabbedPane();
        for (int i = 0; i < panel.length; ++i) {
            panel[i].setBorder(BorderFactory.createEtchedBorder());
            tabbed.addTab(null, title[i], panel[i]);
        }
        if (provider != null) {
            tabbed.putClientProperty("JEWT.HelpProvider", provider);
        } else {
            HelpProvider help = new HelpProvider(){

                public void showHelp(Component arg0) throws HelpUnavailableException {
                    HelpSystem.getHelpSystem().showHelp(tabbed.getActivePanel());
                }
            };
            tabbed.putClientProperty("JEWT.HelpProvider", help);
        }
        JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)tabbed, null, (String)dialogTitle, (int)14);
        if (listener != null) {
            dlg.addActionListener(listener);
        }
        if (chgListener != null) {
            tabbed.addChangeListener(chgListener);
        }
        dlg.setSize(600, 300);
        dlg.pack();
        dlg.setPreferredSize(tabbed.getPreferredSize());
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)dlg);
        dlg.setVisible(true);
    }

    public static void showPanelAsDialog(JPanel panel, String title, ActionListener listener, int buttonMask) {
        Dimension d = panel.getPreferredSize();
        d.setSize(d.getWidth() + 150.0, d.getHeight() + 100.0);
        JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, null, (String)title, (int)buttonMask);
        if (listener != null) {
            dlg.addActionListener(listener);
        }
        dlg.setPreferredSize(d);
        dlg.setSize(d);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)dlg);
        dlg.setVisible(true);
    }

    public static void setClipboard(String str) {
        StringSelection ss = new StringSelection(str);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
    }

    public static void editNodeWizard(DatabaseNode node) {
        Context ctx = Context.newIdeContext((Element)((Element)node));
        SchemaObject obj = ((OCBBaseNode)node).getSchemaObject();
        ctx.setProperty("ParentObject", (Object)obj);
        DBWizardFactoryRegistry.getDBWizardFactory((Database)node.getDatabase()).editDBObject(ctx, node.getDatabase(), (DBObject)obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void editNode(DatabaseNode node) {
        Context context = Context.newIdeContext((Element)((Element)node));
        OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
        openEditorOptions.setFlags(1);
        WaitCursor waitCursor = Ide.getWaitCursor();
        try {
            waitCursor.show(0L);
            EditorManager.getEditorManager().openEditor(openEditorOptions);
        }
        finally {
            waitCursor.hide();
        }
    }

    public static void makeTitledBorder(JComponent component, String title) {
        TitledBorder titledBorder = new TitledBorder(title);
        component.setBorder(titledBorder);
    }

    public static void addFontListener(Component comp) {
        final Component textComp = comp;
        ClientSetting settings = ClientSetting.findOrCreate((String)AddinManager.getAddinManager().getExtensionIDForAddin(CodeEditorAddin.class));
        FontSizeOptions fontSizeOptions = (FontSizeOptions)settings.getData("FontSizeOptions");
        Font f = new Font(fontSizeOptions.getFontFamily(), 0, fontSizeOptions.getFontSize());
        comp.setFont(f);
        EditorProperties.getProperties().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() != "editor-font-size" && evt.getPropertyName() != "editor-font-family") {
                    String newFamily = null;
                    Object newFont = null;
                    int newSize = 10;
                    newSize = evt.getPropertyName() == "editor-font-size" ? ((Integer)evt.getNewValue()).intValue() : textComp.getFont().getSize();
                    newFamily = evt.getPropertyName() == "editor-font-family" ? (String)evt.getNewValue() : textComp.getFont().getFamily();
                    Font f = null;
                    f = evt.getPropertyName() == "editor-font" ? (Font)evt.getNewValue() : new Font(newFamily, 0, newSize);
                    textComp.setFont(f);
                }
            }
        });
    }
}

