/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbtools.util.Debug;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLHelper {
    private static DocumentBuilderFactory factory = null;
    private static DocumentBuilder builder = null;
    private static Document document = null;
    private static Element root = null;

    public static Node getChildNode(Node node, String s) {
        NodeList children = node.getChildNodes();
        Node ret = null;
        for (int i = 0; ret == null && i < children.getLength(); ++i) {
            if (!children.item(i).getNodeName().equalsIgnoreCase(s)) continue;
            ret = children.item(i);
        }
        return ret;
    }

    public static String getNodeValue(Node node, String name) {
        String value = null;
        if (node != null) {
            if (XMLHelper.getChildNode(node, name) == null) {
                return "";
            }
            Node n1 = XMLHelper.getChildNode(node, name).getFirstChild();
            value = n1 == null ? XMLHelper.getChildNode(node, name).getNodeValue() : n1.getNodeValue();
        }
        return value;
    }

    public static String getAttributeNode(Node node, String s) {
        String ret = null;
        if (node != null) {
            String name = node.getNodeName();
            if (node.getAttributes() != null && node.getAttributes().getNamedItem(s) != null) {
                ret = node.getAttributes().getNamedItem(s).getNodeValue();
            }
        }
        return ret;
    }

    public static Element NewDocument() {
        try {
            factory = DocumentBuilderFactory.newInstance();
            factory.setCoalescing(true);
            builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            root = document.createElement("reports");
            document.appendChild(root);
            return root;
        }
        catch (ParserConfigurationException pce) {
            Debug.debug(pce.toString());
            return null;
        }
    }

    public static Element addFolder(Element parent, String iName, String iDesc, String iTip) {
        Element folder = document.createElement("folder");
        Element name = document.createElement("name");
        name.appendChild(document.createCDATASection(iName.trim()));
        folder.appendChild(name);
        Element desc = document.createElement("description");
        desc.appendChild(document.createCDATASection(iDesc.trim()));
        folder.appendChild(desc);
        Element tip = document.createElement("tooltip");
        tip.appendChild(document.createCDATASection(iTip.trim()));
        folder.appendChild(tip);
        parent.appendChild(folder);
        return folder;
    }

    public static void addReport(Element parent, String iName, String iDesc, String iTip, String iSql) {
        Element report = document.createElement("report");
        report.setAttribute("type", "report");
        report.setAttribute("enabled", "true");
        Element name = document.createElement("name");
        name.appendChild(document.createCDATASection(iName.trim()));
        report.appendChild(name);
        Element desc = document.createElement("description");
        desc.appendChild(document.createCDATASection(iDesc.trim()));
        report.appendChild(desc);
        Element tip = document.createElement("tooltip");
        tip.appendChild(document.createCDATASection(iTip.trim()));
        report.appendChild(tip);
        Element query = document.createElement("query");
        report.appendChild(query);
        Element sql = document.createElement("sql");
        sql.appendChild(document.createCDATASection(iSql.trim()));
        query.appendChild(sql);
        parent.appendChild(report);
    }

    public static Document getDocument() {
        return document;
    }
}

