/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.util.Assert;
import oracle.xml.parser.v2.DOMParser;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Resource {
    public static boolean DEV_MODE = false;
    public static String devDir = null;
    public static String home = System.getenv("HOME");
    public static File raptorDir;
    public static File raptorUser;
    public static File raptorUserTmp;

    public static boolean saveUserDocument(String fileName, OutputStream in) {
        return false;
    }

    public static Document getUserDoucment(String file) {
        DOMParser parser = new DOMParser();
        parser.setPreserveWhitespace(false);
        try {
            String fullPath = raptorDir.getAbsolutePath() + File.separator + file;
            FileInputStream in = null;
            try {
                File f = new File(fullPath);
                if (f.exists()) {
                    in = new FileInputStream(f);
                }
            }
            catch (IOException ioe) {
                System.err.println("Could not load requested file:" + file);
            }
            parser.parse(in);
        }
        catch (SAXException e) {
            ExceptionHandler.handleException(e);
        }
        catch (IOException e) {
            ExceptionHandler.handleException(e);
        }
        return parser.getDocument();
    }

    public static Document getDoucment(Class className, String file) {
        DOMParser parser = new DOMParser();
        parser.setPreserveWhitespace(false);
        try {
            parser.parse(Resource.getResourceAsStream(className, file));
        }
        catch (SAXException e) {
            ExceptionHandler.handleException(e);
        }
        catch (IOException e) {
            ExceptionHandler.handleException(e);
        }
        return parser.getDocument();
    }

    public static synchronized File getResource(Class className, String name) {
        String s = System.getProperty("raptor.devdir");
        File ret = null;
        if (s == null) {
            s = System.getenv("raptor.devdir");
        }
        if (devDir == null && s != null) {
            DEV_MODE = true;
            devDir = s + File.separator;
        }
        if (DEV_MODE) {
            ret = new File(devDir + name);
        }
        if (ret == null || !ret.exists()) {
            ret = new File(className.getResource(name).getFile());
        }
        return ret;
    }

    public static synchronized InputStream getResourceAsStream(Class className, String name) {
        String s = System.getProperty("raptor.devdir");
        if (s == null) {
            s = System.getenv("raptor.devdir");
        }
        if (devDir == null && s != null) {
            DEV_MODE = true;
            devDir = s + File.separator;
        }
        if (DEV_MODE) {
            Assert.print((String)("Reading  XML:" + devDir + File.separator + name + "\n"));
        }
        InputStream in = null;
        try {
            File f = Resource.getResource(className, name);
            in = f.exists() && f.canRead() ? new FileInputStream(f) : className.getResourceAsStream(name);
        }
        catch (IOException ioe) {
            System.err.println("Could not load requested file:" + name);
            ioe.printStackTrace();
        }
        return in;
    }

    static {
        if (home == null) {
            home = System.getenv("HOMEPATH");
        }
        if (!(raptorDir = new File(home + File.separator + ".sqldeveloper")).exists()) {
            raptorDir.mkdir();
        }
        if (!(raptorUser = new File(System.getProperty("user.home") + File.separator + ".sqldeveloper")).exists()) {
            raptorUser.mkdir();
        }
        if (!(raptorUserTmp = new File(System.getProperty("user.home") + File.separator + ".sqldeveloper" + File.separator + "tmp")).exists()) {
            raptorUserTmp.mkdir();
        }
    }
}

