/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.rowset.OracleRowSetMetaData;

public class OracleJDBCRowSet
implements RowSet {
    private String dataSource;
    private String dataSourceName;
    private String url;
    private String username;
    private String password;
    private Connection connection;
    private static boolean driverManagerInitialized;
    private PreparedStatement preparedStatement;
    private ResultSet resultSet;
    private int fetchSize;
    private int fetchDirection;
    private int rowsetType;
    private RowSetEvent rowsetEvent;
    private Vector listener = new Vector();
    private boolean escapeProcessing;
    private String command;
    private boolean readOnly;
    private int concurrency;
    private int transactionIsolation;
    private int maxFieldSize;
    private int maxRows;
    private int queryTimeout;
    private Map typeMap;

    public OracleJDBCRowSet() {
        this.rowsetEvent = new RowSetEvent(this);
        driverManagerInitialized = false;
        this.escapeProcessing = false;
        this.rowsetType = 1005;
        this.fetchDirection = 1002;
        this.readOnly = true;
        this.maxFieldSize = 0;
        this.maxRows = 0;
        this.fetchSize = 0;
        this.queryTimeout = 0;
        this.url = "";
        this.username = "";
        this.password = "";
        this.command = "";
        this.typeMap = new HashMap();
        this.concurrency = 1007;
        this.transactionIsolation = 2;
    }

    public boolean absolute(int n) throws SQLException {
        boolean bl = this.resultSet.absolute(n);
        if (bl) {
            this.notifyCursorMovement();
        }
        return bl;
    }

    public void addRowSetListener(RowSetListener rowSetListener) {
        int n = 0;
        while (n < this.listener.size()) {
            if (this.listener.elementAt(n).equals(rowSetListener)) {
                return;
            }
            ++n;
        }
        this.listener.add(rowSetListener);
    }

    public void afterLast() throws SQLException {
        if (!this.isAfterLast()) {
            this.resultSet.afterLast();
            this.notifyCursorMovement();
        }
    }

    public void beforeFirst() throws SQLException {
        if (!this.isBeforeFirst()) {
            this.resultSet.beforeFirst();
            this.notifyCursorMovement();
        }
    }

    public void cancelRowUpdates() throws SQLException {
        this.resultSet.cancelRowUpdates();
        this.notifyRowChanged();
    }

    public void clearParameters() throws SQLException {
        this.preparedStatement.clearParameters();
    }

    public void clearWarnings() throws SQLException {
        this.resultSet.clearWarnings();
    }

    public void close() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
        }
        if (this.preparedStatement != null) {
            this.preparedStatement.close();
        }
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.commit();
            this.connection.close();
        }
        this.notifyRowSetChanged();
    }

    public void deleteRow() throws SQLException {
        this.resultSet.deleteRow();
        this.notifyRowSetChanged();
    }

    public void execute() throws SQLException {
        this.connection = this.getConnection(this);
        this.connection.setTransactionIsolation(this.getTransactionIsolation());
        this.connection.setTypeMap(this.getTypeMap());
        this.preparedStatement = this.connection.prepareStatement(this.getCommand(), this.getType(), this.getConcurrency());
        this.preparedStatement.setFetchSize(this.getFetchSize());
        this.preparedStatement.setFetchDirection(this.getFetchDirection());
        this.preparedStatement.setMaxFieldSize(this.getMaxFieldSize());
        this.preparedStatement.setMaxRows(this.getMaxRows());
        this.preparedStatement.setQueryTimeout(this.getQueryTimeout());
        this.preparedStatement.setEscapeProcessing(this.getEscapeProcessing());
        this.resultSet = this.preparedStatement.executeQuery();
        this.notifyRowSetChanged();
    }

    public int findColumn(String string) throws SQLException {
        return this.resultSet.findColumn(string);
    }

    public boolean first() throws SQLException {
        boolean bl = this.resultSet.first();
        if (bl) {
            this.notifyCursorMovement();
        }
        return bl;
    }

    public Array getArray(int n) throws SQLException {
        return this.resultSet.getArray(n);
    }

    public Array getArray(String string) throws SQLException {
        return this.resultSet.getArray(string);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        return this.resultSet.getAsciiStream(n);
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.resultSet.getAsciiStream(string);
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.resultSet.getBigDecimal(n);
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.resultSet.getBigDecimal(n, n2);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.resultSet.getBigDecimal(string);
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.resultSet.getBigDecimal(string, n);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        return this.resultSet.getBinaryStream(n);
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.resultSet.getBinaryStream(string);
    }

    public Blob getBlob(int n) throws SQLException {
        return this.resultSet.getBlob(n);
    }

    public Blob getBlob(String string) throws SQLException {
        return this.resultSet.getBlob(string);
    }

    public boolean getBoolean(int n) throws SQLException {
        return this.resultSet.getBoolean(n);
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.resultSet.getBoolean(string);
    }

    public byte getByte(int n) throws SQLException {
        return this.resultSet.getByte(n);
    }

    public byte getByte(String string) throws SQLException {
        return this.resultSet.getByte(string);
    }

    public byte[] getBytes(int n) throws SQLException {
        return this.resultSet.getBytes(n);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.resultSet.getBytes(string);
    }

    public Reader getCharacterStream(int n) throws SQLException {
        return this.resultSet.getCharacterStream(n);
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.resultSet.getCharacterStream(string);
    }

    public Clob getClob(int n) throws SQLException {
        return this.resultSet.getClob(n);
    }

    public Clob getClob(String string) throws SQLException {
        return this.resultSet.getClob(string);
    }

    public String getCommand() {
        return this.command;
    }

    public int getConcurrency() throws SQLException {
        return this.concurrency;
    }

    private Connection getConnection(RowSet rowSet) throws SQLException {
        Connection connection = this.connection;
        if (connection != null && !connection.isClosed()) {
            return connection;
        }
        if (rowSet.getDataSourceName() != null) {
            try {
                InitialContext initialContext = new InitialContext();
                DataSource dataSource = (DataSource)initialContext.lookup(rowSet.getDataSourceName());
                return dataSource.getConnection(rowSet.getUsername(), rowSet.getPassword());
            }
            catch (NamingException namingException) {
                throw new SQLException("Unable to connect through the DataSource\n" + namingException.getMessage());
            }
        }
        if (rowSet.getUrl() != null) {
            if (!driverManagerInitialized) {
                DriverManager.registerDriver((Driver)new OracleDriver());
                driverManagerInitialized = true;
            }
            String string = rowSet.getUrl();
            String string2 = rowSet.getUsername();
            String string3 = rowSet.getPassword();
            if (string.equals("") || string2.equals("") || string3.equals("")) {
                throw new SQLException("One or more of the authenticating parameter not set");
            }
            return DriverManager.getConnection(string, string2, string3);
        }
        return null;
    }

    public String getCursorName() throws SQLException {
        return this.resultSet.getCursorName();
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public Date getDate(int n) throws SQLException {
        return this.resultSet.getDate(n);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.resultSet.getDate(n, calendar);
    }

    public Date getDate(String string) throws SQLException {
        return this.resultSet.getDate(string);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.resultSet.getDate(string, calendar);
    }

    public double getDouble(int n) throws SQLException {
        return this.resultSet.getDouble(n);
    }

    public double getDouble(String string) throws SQLException {
        return this.resultSet.getDouble(string);
    }

    public boolean getEscapeProcessing() throws SQLException {
        return this.escapeProcessing;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public float getFloat(int n) throws SQLException {
        return this.resultSet.getFloat(n);
    }

    public float getFloat(String string) throws SQLException {
        return this.resultSet.getFloat(string);
    }

    public int getInt(int n) throws SQLException {
        return this.resultSet.getInt(n);
    }

    public int getInt(String string) throws SQLException {
        return this.resultSet.getInt(string);
    }

    public long getLong(int n) throws SQLException {
        return this.resultSet.getLong(n);
    }

    public long getLong(String string) throws SQLException {
        return this.resultSet.getLong(string);
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return new OracleRowSetMetaData(this.resultSet.getMetaData());
    }

    public Object getObject(int n) throws SQLException {
        return this.resultSet.getObject(n);
    }

    public Object getObject(int n, Map map) throws SQLException {
        return this.resultSet.getObject(n, map);
    }

    public Object getObject(String string) throws SQLException {
        return this.resultSet.getObject(string);
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.resultSet.getObject(string, map);
    }

    public String getPassword() {
        return this.password;
    }

    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    public Ref getRef(int n) throws SQLException {
        return this.resultSet.getRef(n);
    }

    public Ref getRef(String string) throws SQLException {
        return this.resultSet.getRef(string);
    }

    public int getRow() throws SQLException {
        return this.resultSet.getRow();
    }

    public short getShort(int n) throws SQLException {
        return this.resultSet.getShort(n);
    }

    public short getShort(String string) throws SQLException {
        return this.resultSet.getShort(string);
    }

    public Statement getStatement() throws SQLException {
        return this.resultSet.getStatement();
    }

    public String getString(int n) throws SQLException {
        return this.resultSet.getString(n);
    }

    public String getString(String string) throws SQLException {
        return this.resultSet.getString(string);
    }

    public Time getTime(int n) throws SQLException {
        return this.resultSet.getTime(n);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.resultSet.getTime(n, calendar);
    }

    public Time getTime(String string) throws SQLException {
        return this.resultSet.getTime(string);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.resultSet.getTime(string, calendar);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.resultSet.getTimestamp(n);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.resultSet.getTimestamp(n, calendar);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.resultSet.getTimestamp(string);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.resultSet.getTimestamp(string, calendar);
    }

    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public int getType() throws SQLException {
        return this.rowsetType;
    }

    public Map getTypeMap() throws SQLException {
        return this.typeMap;
    }

    public URL getURL(int n) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public URL getURL(String string) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        return this.resultSet.getUnicodeStream(n);
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.resultSet.getUnicodeStream(string);
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.resultSet.getWarnings();
    }

    public void insertRow() throws SQLException {
        this.resultSet.insertRow();
        this.notifyRowSetChanged();
    }

    public boolean isAfterLast() throws SQLException {
        return this.resultSet.isAfterLast();
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.resultSet.isBeforeFirst();
    }

    public boolean isFirst() throws SQLException {
        return this.resultSet.isFirst();
    }

    public boolean isLast() throws SQLException {
        return this.resultSet.isLast();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean last() throws SQLException {
        boolean bl = this.resultSet.last();
        if (bl) {
            this.notifyCursorMovement();
        }
        return bl;
    }

    public void moveToCurrentRow() throws SQLException {
        this.resultSet.moveToCurrentRow();
    }

    public void moveToInsertRow() throws SQLException {
        this.resultSet.moveToInsertRow();
    }

    public boolean next() throws SQLException {
        boolean bl = this.resultSet.next();
        if (bl) {
            this.notifyCursorMovement();
        }
        return bl;
    }

    private final void notifyCursorMovement() {
        int n = this.listener.size();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                ((RowSetListener)this.listener.elementAt(n2)).cursorMoved(this.rowsetEvent);
                ++n2;
            }
        }
    }

    private final void notifyRowChanged() {
        int n = this.listener.size();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                ((RowSetListener)this.listener.elementAt(n2)).rowChanged(this.rowsetEvent);
                ++n2;
            }
        }
    }

    private final void notifyRowSetChanged() {
        int n = this.listener.size();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                ((RowSetListener)this.listener.elementAt(n2)).rowSetChanged(this.rowsetEvent);
                ++n2;
            }
        }
    }

    private final void notifyUpdateListeners() {
        int n = this.listener.size();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                ((RowSetListener)this.listener.elementAt(n2)).rowChanged(this.rowsetEvent);
                ++n2;
            }
        }
    }

    public boolean previous() throws SQLException {
        boolean bl = this.resultSet.previous();
        if (bl) {
            this.notifyCursorMovement();
        }
        return bl;
    }

    public void refreshRow() throws SQLException {
        this.resultSet.refreshRow();
    }

    public boolean relative(int n) throws SQLException {
        boolean bl = this.resultSet.relative(n);
        if (bl) {
            this.notifyCursorMovement();
        }
        return bl;
    }

    public void removeRowSetListener(RowSetListener rowSetListener) {
        int n = 0;
        while (n < this.listener.size()) {
            if (this.listener.elementAt(n).equals(rowSetListener)) {
                this.listener.remove(n);
            }
            ++n;
        }
    }

    public boolean rowDeleted() throws SQLException {
        return this.resultSet.rowDeleted();
    }

    public boolean rowInserted() throws SQLException {
        return this.resultSet.rowInserted();
    }

    public boolean rowUpdated() throws SQLException {
        return this.resultSet.rowUpdated();
    }

    public void setArray(int n, Array array) throws SQLException {
        this.preparedStatement.setArray(n, array);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.preparedStatement.setAsciiStream(n, inputStream, n2);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.preparedStatement.setBigDecimal(n, bigDecimal);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.preparedStatement.setBinaryStream(n, inputStream, n2);
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.preparedStatement.setBlob(n, blob);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.preparedStatement.setBoolean(n, bl);
    }

    public void setByte(int n, byte by) throws SQLException {
        this.preparedStatement.setByte(n, by);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.preparedStatement.setBytes(n, byArray);
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.preparedStatement.setCharacterStream(n, reader, n2);
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.preparedStatement.setClob(n, clob);
    }

    public void setCommand(String string) throws SQLException {
        this.command = string;
    }

    public void setConcurrency(int n) throws SQLException {
        this.concurrency = n;
    }

    public void setDataSource(String string) {
        this.dataSource = string;
    }

    public void setDataSourceName(String string) throws SQLException {
        this.dataSourceName = string;
    }

    public void setDate(int n, Date date) throws SQLException {
        this.preparedStatement.setDate(n, date);
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.preparedStatement.setDate(n, date, calendar);
    }

    public void setDouble(int n, double d) throws SQLException {
        this.preparedStatement.setDouble(n, d);
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.escapeProcessing = bl;
    }

    public void setFetchDirection(int n) throws SQLException {
        this.fetchDirection = n;
        this.resultSet.setFetchDirection(this.fetchDirection);
    }

    public void setFetchSize(int n) throws SQLException {
        this.fetchSize = n;
    }

    public void setFloat(int n, float f) throws SQLException {
        this.preparedStatement.setFloat(n, f);
    }

    public void setInt(int n, int n2) throws SQLException {
        this.preparedStatement.setInt(n, n2);
    }

    public void setLong(int n, long l) throws SQLException {
        this.preparedStatement.setLong(n, l);
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.maxFieldSize = n;
    }

    public void setMaxRows(int n) throws SQLException {
        this.maxRows = n;
    }

    public void setNull(int n, int n2) throws SQLException {
        this.preparedStatement.setNull(n, n2);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.preparedStatement.setNull(n, n2, string);
    }

    public void setObject(int n, Object object) throws SQLException {
        this.preparedStatement.setObject(n, object);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.preparedStatement.setObject(n, object, n2);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.preparedStatement.setObject(n, object, n2, n3);
    }

    public void setPassword(String string) throws SQLException {
        this.password = string;
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.queryTimeout = n;
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.readOnly = bl;
        this.connection.setReadOnly(bl);
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.preparedStatement.setRef(n, ref);
    }

    public void setShort(int n, short s) throws SQLException {
        this.preparedStatement.setShort(n, s);
    }

    public void setString(int n, String string) throws SQLException {
        this.preparedStatement.setString(n, string);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.preparedStatement.setTime(n, time);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.preparedStatement.setTime(n, time, calendar);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.preparedStatement.setTimestamp(n, timestamp);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.preparedStatement.setTimestamp(n, timestamp, calendar);
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.transactionIsolation = n;
    }

    public void setType(int n) throws SQLException {
        this.rowsetType = n;
    }

    public void setTypeMap(Map map) throws SQLException {
        this.typeMap = map;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public void setUsername(String string) throws SQLException {
        this.username = string;
    }

    public void updateArray(int n, Array array) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
    }

    public void updateArray(String string, Array array) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.resultSet.updateAsciiStream(n, inputStream, n2);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.resultSet.updateAsciiStream(string, inputStream, n);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.resultSet.updateBigDecimal(n, bigDecimal);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.resultSet.updateBigDecimal(string, bigDecimal);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.resultSet.updateBinaryStream(n, inputStream, n2);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.resultSet.updateBinaryStream(string, inputStream, n);
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.resultSet.updateBoolean(n, bl);
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.resultSet.updateBoolean(string, bl);
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.resultSet.updateByte(n, by);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.resultSet.updateByte(string, by);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.resultSet.updateBytes(n, byArray);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.resultSet.updateBytes(string, byArray);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.resultSet.updateCharacterStream(n, reader, n2);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.resultSet.updateCharacterStream(string, reader, n);
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.resultSet.updateDate(n, date);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.resultSet.updateDate(string, date);
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.resultSet.updateDouble(n, d);
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.resultSet.updateDouble(string, d);
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.resultSet.updateFloat(n, f);
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.resultSet.updateFloat(string, f);
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.resultSet.updateInt(n, n2);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.resultSet.updateInt(string, n);
    }

    public void updateLong(int n, long l) throws SQLException {
        this.resultSet.updateLong(n, l);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.resultSet.updateLong(string, l);
    }

    public void updateNull(int n) throws SQLException {
        this.resultSet.updateNull(n);
    }

    public void updateNull(String string) throws SQLException {
        this.resultSet.updateNull(string);
    }

    public void updateObject(int n, Object object) throws SQLException {
        this.resultSet.updateObject(n, object);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.resultSet.updateObject(n, object, n2);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.resultSet.updateObject(string, object);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.resultSet.updateObject(string, object, n);
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
    }

    public void updateRow() throws SQLException {
        this.resultSet.updateRow();
        this.notifyUpdateListeners();
        this.notifyRowSetChanged();
        this.notifyRowChanged();
    }

    public void updateShort(int n, short s) throws SQLException {
        this.resultSet.updateShort(n, s);
    }

    public void updateShort(String string, short s) throws SQLException {
        this.resultSet.updateShort(string, s);
    }

    public void updateString(int n, String string) throws SQLException {
        this.resultSet.updateString(n, string);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.resultSet.updateString(string, string2);
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.resultSet.updateTime(n, time);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.resultSet.updateTime(string, time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.resultSet.updateTimestamp(n, timestamp);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.resultSet.updateTimestamp(string, timestamp);
    }

    public boolean wasNull() throws SQLException {
        return this.resultSet.wasNull();
    }
}

