/*
 * Decompiled with CFR 0.152.
 */
package javax.ide;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.ide.IDEEvent;
import javax.ide.IDEListener;
import javax.ide.Service;
import javax.ide.build.BuildSystem;
import javax.ide.command.CommandProcessor;
import javax.ide.debug.Debugger;
import javax.ide.editor.EditorManager;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.log.LogManager;
import javax.ide.menu.ActionRegistry;
import javax.ide.model.DocumentFactory;
import javax.ide.property.PropertyPageRegistry;
import javax.ide.spi.IDEListenerHook;
import javax.ide.spi.ProviderNotFoundException;
import javax.ide.util.MetaClass;
import javax.ide.util.Version;
import javax.ide.view.GUIUtilities;
import javax.ide.view.View;
import javax.ide.wizard.WizardManager;

public abstract class IDE
extends Service {
    private static final Version EDK_VERSION = new Version("1.0");
    private final Collection _listeners = new ArrayList();

    public abstract String getProductName();

    public abstract View getMainWindow();

    public abstract View getActiveView();

    public Version getEDKVersion() {
        return EDK_VERSION;
    }

    public abstract URI getUserHome();

    public ActionRegistry getActionRegistry() {
        return ActionRegistry.getActionRegistry();
    }

    public ExtensionRegistry getExtensionRegistry() {
        return ExtensionRegistry.getExtensionRegistry();
    }

    public DocumentFactory getDocumentFactory() {
        return DocumentFactory.getDocumentFactory();
    }

    public EditorManager getEditorManager() {
        return EditorManager.getEditorManager();
    }

    public CommandProcessor getCommandProcessor() {
        return CommandProcessor.getCommandProcessor();
    }

    public LogManager getLogManager() {
        return LogManager.getLogManager();
    }

    public WizardManager getWizardManager() {
        return WizardManager.getWizardManager();
    }

    public Debugger getDebugger() {
        return Debugger.getDebugger();
    }

    public BuildSystem getBuildSystem() {
        return BuildSystem.getBuildSystem();
    }

    public PropertyPageRegistry getPropertyPageRegistry() {
        return PropertyPageRegistry.getPropertyPageRegistry();
    }

    public GUIUtilities getGUIUtilities() {
        return GUIUtilities.getGUIUtilities();
    }

    private void addIDEListener(IDEListener iDEListener) {
        this._listeners.add(iDEListener);
    }

    protected final void fireIDEActivated() {
        ArrayList arrayList = new ArrayList(this._listeners);
        IDEEvent iDEEvent = new IDEEvent(this);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            IDEListener iDEListener = (IDEListener)iterator.next();
            iDEListener.activated(iDEEvent);
        }
    }

    protected final void fireIDEDeactivated() {
        ArrayList arrayList = new ArrayList(this._listeners);
        IDEEvent iDEEvent = new IDEEvent(this);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            IDEListener iDEListener = (IDEListener)iterator.next();
            iDEListener.deactivated(iDEEvent);
        }
    }

    protected void initialize() {
        IDEListenerHook iDEListenerHook = (IDEListenerHook)ExtensionRegistry.getExtensionRegistry().getHook(IDEListenerHook.ELEMENT);
        Collection collection = iDEListenerHook.getListeners();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            MetaClass metaClass = (MetaClass)iterator.next();
            try {
                IDEListener iDEListener = (IDEListener)metaClass.newInstance();
                this.addIDEListener(iDEListener);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static IDE getIDE() {
        try {
            return (IDE)IDE.getService(IDE.class);
        }
        catch (ProviderNotFoundException providerNotFoundException) {
            providerNotFoundException.printStackTrace();
            throw new IllegalStateException("No IDE service");
        }
    }
}

