/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.build;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.ide.Service;
import javax.ide.build.AbortBuildException;
import javax.ide.build.BuildEvent;
import javax.ide.build.BuildListener;
import javax.ide.build.spi.BuildSystemHook;
import javax.ide.command.Context;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.spi.ProviderNotFoundException;

public abstract class BuildSystem
extends Service {
    private final List _listeners = new ArrayList();

    protected BuildSystem() {
    }

    protected final boolean hasListeners() {
        return !this._listeners.isEmpty();
    }

    protected void initialize() {
        BuildSystemHook buildSystemHook = (BuildSystemHook)ExtensionRegistry.getExtensionRegistry().getHook(BuildSystemHook.ELEMENT);
        this._listeners.addAll(buildSystemHook.getListeners());
    }

    public final void addBuildListener(BuildListener buildListener) {
        this._listeners.add(buildListener);
    }

    public final void removeBuildListener(BuildListener buildListener) {
        this._listeners.remove(buildListener);
    }

    public abstract void build(Context var1);

    public abstract boolean isBuilding();

    protected final void firePreBuild(BuildEvent buildEvent) throws AbortBuildException {
        ArrayList arrayList = new ArrayList(this._listeners.size());
        arrayList.addAll(this._listeners);
        ListIterator listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            BuildListener buildListener = (BuildListener)listIterator.next();
            try {
                buildListener.preBuild(buildEvent);
            }
            catch (Exception exception) {
                BuildEvent buildEvent2 = new BuildEvent(buildEvent.getBuildSystem(), buildEvent.getContext(), false);
                while (listIterator.hasPrevious()) {
                    buildListener = (BuildListener)listIterator.previous();
                    buildListener.postBuild(buildEvent2);
                }
                throw new AbortBuildException(exception.getMessage(), exception);
            }
        }
    }

    protected final void firePostBuild(BuildEvent buildEvent) {
        ArrayList arrayList = new ArrayList(this._listeners.size());
        arrayList.addAll(this._listeners);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            BuildListener buildListener = (BuildListener)iterator.next();
            try {
                buildListener.postBuild(buildEvent);
            }
            catch (Exception exception) {
                buildEvent = new BuildEvent(buildEvent.getBuildSystem(), buildEvent.getContext(), false);
            }
        }
    }

    public static BuildSystem getBuildSystem() {
        try {
            return (BuildSystem)BuildSystem.getService(BuildSystem.class);
        }
        catch (ProviderNotFoundException providerNotFoundException) {
            providerNotFoundException.printStackTrace();
            throw new IllegalStateException("No build system service.");
        }
    }
}

