/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ide.Service;
import javax.ide.command.Context;
import javax.ide.editor.Editor;
import javax.ide.editor.EditorEvent;
import javax.ide.editor.EditorListener;
import javax.ide.editor.spi.EditorHook;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.model.Document;
import javax.ide.spi.ProviderNotFoundException;
import javax.ide.util.MetaClass;

public abstract class EditorManager
extends Service {
    private final Map _listenerMap = new HashMap();
    private boolean _initializedHookListeners = false;

    public abstract Editor getActiveEditor();

    public abstract Set getAllOpenEditors();

    public boolean isOpen(Document document) {
        Iterator iterator = this.getAllOpenEditors().iterator();
        while (iterator.hasNext()) {
            Editor editor = (Editor)iterator.next();
            if (!document.equals(editor.getContext().getDocument())) continue;
            return true;
        }
        return false;
    }

    public Set getOpenEditors(Document document) {
        HashSet<Editor> hashSet = new HashSet<Editor>();
        Iterator iterator = this.getAllOpenEditors().iterator();
        while (iterator.hasNext()) {
            Editor editor = (Editor)iterator.next();
            if (!document.equals(editor.getContext().getDocument())) continue;
            hashSet.add(editor);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public abstract Editor openEditor(Context var1, String var2);

    public abstract void closeEditor(Editor var1);

    public final void addEditorListener(EditorListener editorListener, String string) {
        ArrayList<EditorListener> arrayList;
        if (string == null) {
            string = "_anyListener";
        }
        if ((arrayList = (ArrayList<EditorListener>)this._listenerMap.get(string)) == null) {
            arrayList = new ArrayList<EditorListener>();
            this._listenerMap.put(string, arrayList);
        }
        arrayList.add(editorListener);
    }

    public final void removeEditorListener(EditorListener editorListener, String string) {
        List list;
        if (string == null) {
            string = "_anyListener";
        }
        if ((list = (List)this._listenerMap.get(string)) == null) {
            throw new IllegalArgumentException("No listeners are registered for editor type " + string);
        }
        list.remove(editorListener);
    }

    private final Collection getListeners(Editor editor) {
        this.initializeHookListeners();
        List list = (List)this._listenerMap.get(editor.getClass().getName());
        List list2 = (List)this._listenerMap.get("_anyListener");
        ArrayList arrayList = new ArrayList();
        if (list != null) {
            arrayList.addAll(list);
        }
        if (list2 != null) {
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    protected final void fireEditorOpened(Editor editor) {
        Collection collection = this.getListeners(editor);
        if (!collection.isEmpty()) {
            EditorEvent editorEvent = new EditorEvent(editor);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                ((EditorListener)iterator.next()).opened(editorEvent);
            }
        }
    }

    protected final void fireEditorClosed(Editor editor) {
        Collection collection = this.getListeners(editor);
        if (!collection.isEmpty()) {
            EditorEvent editorEvent = new EditorEvent(editor);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                ((EditorListener)iterator.next()).closed(editorEvent);
            }
        }
    }

    protected final void fireEditorActivated(Editor editor) {
        Collection collection = this.getListeners(editor);
        if (!collection.isEmpty()) {
            EditorEvent editorEvent = new EditorEvent(editor);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                ((EditorListener)iterator.next()).activated(editorEvent);
            }
        }
    }

    protected final void fireEditorDeactivated(Editor editor) {
        Collection collection = this.getListeners(editor);
        if (!collection.isEmpty()) {
            EditorEvent editorEvent = new EditorEvent(editor);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                ((EditorListener)iterator.next()).deactivated(editorEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeHookListeners() {
        if (!this._initializedHookListeners) {
            try {
                EditorHook editorHook = (EditorHook)ExtensionRegistry.getExtensionRegistry().getHook(EditorHook.ELEMENT);
                Map map = editorHook.getListeners();
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    Collection collection = (Collection)map.get(string);
                    Iterator iterator2 = collection.iterator();
                    while (iterator2.hasNext()) {
                        MetaClass metaClass = (MetaClass)iterator2.next();
                        try {
                            EditorListener editorListener = (EditorListener)metaClass.newInstance();
                            this.addEditorListener(editorListener, string);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            }
            finally {
                this._initializedHookListeners = true;
            }
        }
    }

    public static EditorManager getEditorManager() {
        try {
            return (EditorManager)EditorManager.getService(EditorManager.class);
        }
        catch (ProviderNotFoundException providerNotFoundException) {
            providerNotFoundException.printStackTrace();
            throw new IllegalStateException("No editor manager.");
        }
    }
}

