/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.editor.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.ide.editor.spi.DisplayInfo;
import javax.ide.editor.spi.MappingInfo;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.I18NStringVisitor;
import javax.ide.util.MetaClass;

public final class EditorHook
extends ExtensionHook {
    public static final ElementName ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "editor-hook");
    private static final ElementName EDITORS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "editors");
    private static final ElementName EDITOR = new ElementName("http://jcp.org/jsr/198/extension-manifest", "editor");
    private static final ElementName NAME = new ElementName("http://jcp.org/jsr/198/extension-manifest", "name");
    private static final ElementName MAPPINGS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "mappings");
    private static final ElementName MAPPING = new ElementName("http://jcp.org/jsr/198/extension-manifest", "mapping");
    private static final ElementName OPEN_WITH = new ElementName("http://jcp.org/jsr/198/extension-manifest", "open-with");
    private static final ElementName LISTENERS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "editor-listeners");
    private static final ElementName EDITOR_LISTENER = new ElementName("http://jcp.org/jsr/198/extension-manifest", "editor-listener");
    private ElementVisitor _editorsVisitor = new EditorsVisitor();
    private ElementVisitor _editorVisitor = new EditorVisitor();
    private ElementVisitor _mappingsVisitor = new MappingsVisitor();
    private ElementVisitor _mappingVisitor = new MappingVisitor();
    private ElementVisitor _openWithVisitor = new OpenWithVisitor();
    private ElementVisitor _listenersVisitor = new ListenersVisitor();
    private ElementVisitor _listenerVisitor = new ListenerVisitor();
    private static final String KEY_DOCUMENT_CLASS = "documentClass";
    private static final String KEY_OPEN_WITH_COLL = "openWithColl";
    public static final String ANY_EDITOR_CLASS = "_anyListener";
    private Map _editorsByClassName = new HashMap();
    private Map _mappings = new HashMap();
    private Map _listeners = new HashMap();
    private Map _editorDisplayInfo = new HashMap();

    public DisplayInfo getDisplayInfo(MetaClass metaClass) {
        return (DisplayInfo)this._editorDisplayInfo.get(metaClass);
    }

    public Collection getEditors() {
        return this._editorsByClassName.values();
    }

    public MetaClass getEditorClass(String string) {
        return (MetaClass)this._editorsByClassName.get(string);
    }

    public Collection getMappedDocumentClasses() {
        return this._mappings.keySet();
    }

    public Collection getEditorsForDocClass(Class clazz) {
        return (Collection)this._mappings.get(clazz.getName());
    }

    public Map getListeners() {
        return this._listeners;
    }

    public void start(ElementStartContext elementStartContext) {
        elementStartContext.registerChildVisitor(EDITORS, this._editorsVisitor);
        elementStartContext.registerChildVisitor(MAPPINGS, this._mappingsVisitor);
        elementStartContext.registerChildVisitor(LISTENERS, this._listenersVisitor);
    }

    private class ListenerVisitor
    extends ElementVisitor {
        private ListenerVisitor() {
        }

        public void start(ElementStartContext elementStartContext) {
            ArrayList<MetaClass> arrayList;
            String string = elementStartContext.getAttributeValue("source-class");
            String string2 = elementStartContext.getAttributeValue("listener-class");
            if (string2 == null) {
                this.log(elementStartContext, Level.SEVERE, "Required attribute 'listener-class' missing.");
                return;
            }
            ClassLoader classLoader = (ClassLoader)elementStartContext.getScopeData().get("classLoader");
            MetaClass metaClass = new MetaClass(classLoader, string2);
            if (string == null) {
                string = EditorHook.ANY_EDITOR_CLASS;
            }
            if ((arrayList = (ArrayList<MetaClass>)EditorHook.this._listeners.get(string)) == null) {
                arrayList = new ArrayList<MetaClass>();
                EditorHook.this._listeners.put(string, arrayList);
            }
            arrayList.add(metaClass);
        }
    }

    private class ListenersVisitor
    extends ElementVisitor {
        private ListenersVisitor() {
        }

        public void start(ElementStartContext elementStartContext) {
            elementStartContext.registerChildVisitor(EDITOR_LISTENER, EditorHook.this._listenerVisitor);
        }
    }

    private class OpenWithVisitor
    extends ElementVisitor {
        private OpenWithVisitor() {
        }

        public void start(ElementStartContext elementStartContext) {
            String string = elementStartContext.getAttributeValue("editor-class");
            if (string == null || (string = string.trim()).length() == 0) {
                this.log(elementStartContext, Level.SEVERE, "Missing required attribute 'editor-class'");
                return;
            }
            String string2 = elementStartContext.getAttributeValue("preferred");
            boolean bl = string2 == null ? false : Boolean.valueOf(string2);
            MappingInfo mappingInfo = new MappingInfo(string, bl);
            List list = (List)elementStartContext.getScopeData().get(EditorHook.KEY_OPEN_WITH_COLL);
            list.add(mappingInfo);
        }
    }

    private class MappingVisitor
    extends ElementVisitor {
        private MappingVisitor() {
        }

        public void start(ElementStartContext elementStartContext) {
            String string = elementStartContext.getAttributeValue("document-class");
            if (string == null || (string = string.trim()).length() == 0) {
                this.log(elementStartContext, Level.SEVERE, "Missing required 'document-class' attribute.");
            } else {
                elementStartContext.getScopeData().put(EditorHook.KEY_DOCUMENT_CLASS, string);
                ArrayList arrayList = (ArrayList)EditorHook.this._mappings.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    EditorHook.this._mappings.put(string, arrayList);
                }
                elementStartContext.getScopeData().put(EditorHook.KEY_OPEN_WITH_COLL, arrayList);
                elementStartContext.registerChildVisitor(OPEN_WITH, EditorHook.this._openWithVisitor);
            }
        }
    }

    private class MappingsVisitor
    extends ElementVisitor {
        private MappingsVisitor() {
        }

        public void start(ElementStartContext elementStartContext) {
            elementStartContext.registerChildVisitor(MAPPING, EditorHook.this._mappingVisitor);
        }
    }

    private class EditorVisitor
    extends ElementVisitor {
        private EditorVisitor() {
        }

        public void start(ElementStartContext elementStartContext) {
            String string = elementStartContext.getAttributeValue("editor-class");
            if (string == null || (string = string.trim()).length() == 0) {
                this.log(elementStartContext, Level.SEVERE, "Missing required 'editor-class' attribute.");
                return;
            }
            ClassLoader classLoader = (ClassLoader)elementStartContext.getScopeData().get("classLoader");
            final MetaClass metaClass = new MetaClass(classLoader, string);
            EditorHook.this._editorsByClassName.put(string, metaClass);
            elementStartContext.registerChildVisitor(NAME, new I18NStringVisitor(){

                protected void string(ElementContext elementContext, String string) {
                    EditorHook.this._editorDisplayInfo.put(metaClass, new DisplayInfo(string));
                }
            });
        }
    }

    private class EditorsVisitor
    extends ElementVisitor {
        private EditorsVisitor() {
        }

        public void start(ElementStartContext elementStartContext) {
            elementStartContext.registerChildVisitor(EDITOR, EditorHook.this._editorVisitor);
        }
    }
}

