/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.spi.Stack;

public class DynamicHook
extends ExtensionHook {
    public final String sApplicationObjectKey = DynamicHook.class.getName() + ".appObjectKey";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String SET_METHOD_PREFIX = "set";
    private static final String ADD_METHOD_PREFIX = "add";
    private static final Class[] sObjectParamTypes = new Class[]{Object.class};
    private static final Class[] sStringParamTypes = new Class[]{String.class};
    private final Stack _applicationObjectStack = new Stack();
    private final Stack _complexTypeIndicatorStack = new Stack();
    private ClassLoader _classLoader;
    private final List _resolvers = new ArrayList(5);

    public DynamicHook(Object object) {
        this._applicationObjectStack.push(object);
    }

    public DynamicHook(Object object, ClassLoader classLoader) {
        this(object);
        this._classLoader = classLoader;
    }

    public DynamicHook(Object object, ClassLoader classLoader, ElementTypeResolver elementTypeResolver) {
        this(object, classLoader);
        this._resolvers.add(elementTypeResolver);
    }

    public void registerElementTypeResolver(ElementTypeResolver elementTypeResolver) {
        this._resolvers.add(elementTypeResolver);
    }

    public void start(ElementStartContext elementStartContext) {
        Class clazz = this.getRuntimeType(elementStartContext);
        this._complexTypeIndicatorStack.push(new boolean[]{clazz != null});
        if (clazz != null) {
            Object object = this.getApplicationObject(clazz, elementStartContext);
            this.invokePreInitialize(this._applicationObjectStack.peek(), object);
            this._applicationObjectStack.push(object);
            elementStartContext.getScopeData().put(this.sApplicationObjectKey, object);
            this.handleComplexElementStart(object, elementStartContext);
        } else {
            this.handleSimpleElementStart(elementStartContext);
        }
    }

    public void end(ElementEndContext elementEndContext) {
        boolean bl = ((boolean[])this._complexTypeIndicatorStack.pop())[0];
        if (bl) {
            Object object = this._applicationObjectStack.pop();
            this.invokePostInitialize(object);
            this.attachObject(this._applicationObjectStack.peek(), object, elementEndContext);
            this.handleComplexElementEnd(elementEndContext);
        } else {
            this.attachData(this._applicationObjectStack.peek(), elementEndContext.getText(), elementEndContext);
            this.handleSimpleElementEnd(elementEndContext);
        }
    }

    protected void handleComplexElementStart(Object object, ElementStartContext elementStartContext) {
    }

    protected void handleComplexElementEnd(ElementEndContext elementEndContext) {
    }

    protected void handleSimpleElementStart(ElementStartContext elementStartContext) {
    }

    protected void handleSimpleElementEnd(ElementEndContext elementEndContext) {
    }

    protected Class getRuntimeType(ElementStartContext elementStartContext) {
        Class clazz = null;
        String string = elementStartContext.getAttributeValue(ATTRIBUTE_CLASS);
        if (string != null) {
            try {
                clazz = Class.forName(string, true, this._classLoader != null ? this._classLoader : Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.log(elementStartContext, Level.SEVERE, "Unable to load class: " + string);
            }
        } else {
            ListIterator listIterator = this._resolvers.listIterator(this._resolvers.size());
            while (listIterator.hasPrevious() && clazz == null) {
                clazz = ((ElementTypeResolver)listIterator.previous()).resolveType(elementStartContext.getElementName());
            }
        }
        return clazz;
    }

    protected Object getApplicationObject(Class clazz, ElementStartContext elementStartContext) {
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            this.log(elementStartContext, Level.SEVERE, "Unable to instantiate class: " + clazz.getName());
            exception.printStackTrace();
            return null;
        }
    }

    protected void attachObject(Object object, Object object2, ElementEndContext elementEndContext) {
        Method method = this.findMethod(elementEndContext, object, elementEndContext.getElementName().getLocalName(), sObjectParamTypes);
        try {
            method.invoke(object, object2);
        }
        catch (InvocationTargetException invocationTargetException) {
            StringBuffer stringBuffer = new StringBuffer(200);
            stringBuffer.append("Could not attach child object: ").append(object2.toString());
            stringBuffer.append(" to parent: ").append(object.toString());
            stringBuffer.append(". Root cause: ");
            stringBuffer.append(invocationTargetException.getTargetException().getClass().getName()).append(": ");
            stringBuffer.append(invocationTargetException.getTargetException().getMessage());
            this.log(elementEndContext, Level.SEVERE, stringBuffer.toString());
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer(200);
            stringBuffer.append("Could not attach child object: ").append(object2.toString());
            stringBuffer.append(" to parent: ").append(object.toString());
            stringBuffer.append(". Root cause: ");
            stringBuffer.append(exception.getClass().getName()).append(": ").append(exception.getMessage());
            this.log(elementEndContext, Level.SEVERE, stringBuffer.toString());
        }
    }

    protected void attachData(Object object, String string, ElementEndContext elementEndContext) {
        Method method = this.findMethod(elementEndContext, object, elementEndContext.getElementName().getLocalName(), sStringParamTypes);
        try {
            method.invoke(object, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.log(elementEndContext, Level.SEVERE, "Unable to attach data '" + string + "' for simple element " + elementEndContext.getElementName().getLocalName());
            invocationTargetException.getTargetException().printStackTrace();
        }
        catch (Exception exception) {
            this.log(elementEndContext, Level.SEVERE, "Unable to attach data '" + string + "' for simple element " + elementEndContext.getElementName().getLocalName());
            exception.printStackTrace();
        }
    }

    protected void invokePreInitialize(Object object, Object object2) {
    }

    protected void invokePostInitialize(Object object) {
    }

    protected Method findMethod(ElementContext elementContext, Object object, String string, Class[] classArray) {
        try {
            String string2 = this.getMethodName(SET_METHOD_PREFIX, string);
            return object.getClass().getMethod(string2, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                String string3 = this.getMethodName(ADD_METHOD_PREFIX, string);
                return object.getClass().getMethod(string3, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                this.log(elementContext, Level.SEVERE, "Class " + object.getClass().getName() + " has no set or add method for element named " + string);
                noSuchMethodException2.printStackTrace();
                return null;
            }
        }
    }

    protected String getMethodName(String string, String string2) {
        int n;
        char[] cArray = new char[string.length() + string2.length()];
        for (n = 0; n < string.length(); ++n) {
            cArray[n] = string.charAt(n);
        }
        n = 1;
        int n2 = string.length();
        for (int i = 0; i < string2.length(); ++i) {
            if (Character.isJavaIdentifierPart(string2.charAt(i))) {
                if (n != 0) {
                    cArray[n2] = Character.toUpperCase(string2.charAt(i));
                    n = 0;
                } else {
                    cArray[n2] = string2.charAt(i);
                }
                ++n2;
                continue;
            }
            n = 1;
        }
        return new String(cArray).trim();
    }

    public static interface ElementTypeResolver {
        public Class resolveType(ElementName var1);
    }
}

