/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.Service;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementVisitorFactory;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.spi.DefaultElementContext;
import javax.ide.extension.spi.DefaultHookVisitorFactory;
import javax.ide.extension.spi.DependencyTree;
import javax.ide.extension.spi.ExtensionSource;
import javax.ide.extension.spi.ExtensionVisitor;
import javax.ide.extension.spi.SAXManifestParser;
import javax.ide.spi.ProviderNotFoundException;
import javax.ide.util.Version;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class ExtensionRegistry
extends Service {
    private Map _extensions;
    private ElementVisitorFactory _hookFactory;

    public final Extension findExtension(String string) {
        if (this._extensions == null) {
            throw new IllegalStateException("ExtensionRegistry has not been initialized.");
        }
        return (Extension)this._extensions.get(string);
    }

    public final Collection getExtensions() {
        return Collections.unmodifiableCollection(this._extensions.values());
    }

    public ExtensionHook getHook(ElementName elementName) {
        if (elementName == null) {
            throw new NullPointerException("Null hookElement");
        }
        return (ExtensionHook)this._hookFactory.getVisitor(elementName);
    }

    protected abstract Collection findAllExtensionSources();

    protected ElementContext createInitialContext() {
        return new DefaultElementContext();
    }

    protected Collection loadExtensions() {
        Iterator iterator;
        Object object;
        Collection collection = this.findAllExtensionSources();
        ArrayList<ExtensionSource> arrayList = new ArrayList<ExtensionSource>();
        Object object2 = collection.iterator();
        while (object2.hasNext()) {
            object = (ExtensionSource)object2.next();
            if (object.getManifestURI() == null) continue;
            arrayList.add((ExtensionSource)object);
        }
        object2 = DependencyTree.buildTree(arrayList, new DependencyTree.EnabledExtensionLookup(){

            public boolean isExtensionEnabled(Extension extension) {
                return ExtensionRegistry.this.isExtensionEnabled(extension.getID(), extension.getVersion());
            }
        }, this.createExtensionLogger(), (DefaultElementContext)this.createInitialContext());
        object = new ArrayList();
        Object object3 = ((DependencyTree)object2).getSortedExtensionIDs().iterator();
        while (object3.hasNext()) {
            iterator = (String)object3.next();
            ((ArrayList)object).add(((DependencyTree)object2).getSource((String)((Object)iterator)));
        }
        object3 = this.loadExtensions((Collection)object);
        iterator = ((DependencyTree)object2).getCycles().iterator();
        while (iterator.hasNext()) {
            this.cycleEncountered((Collection)iterator.next());
        }
        iterator = ((DependencyTree)object2).getUnsatisfiedExtensions().iterator();
        while (iterator.hasNext()) {
            Extension extension = (Extension)iterator.next();
            Collection collection2 = ((DependencyTree)object2).getUnsatisfiedDependencies(extension);
            this.unsatisfiedExtensionDependencies(extension, collection2);
        }
        return object3;
    }

    protected boolean isExtensionEnabled(String string, Version version) {
        return true;
    }

    protected void cycleEncountered(Collection collection) {
    }

    protected void unsatisfiedExtensionDependencies(Extension extension, Collection collection) {
    }

    protected Collection loadExtensions(Collection collection) {
        if (this._hookFactory == null) {
            this._hookFactory = this.createHookVisitorFactory();
        }
        SAXManifestParser sAXManifestParser = new SAXManifestParser((DefaultElementContext)this.createInitialContext());
        Logger logger = this.createExtensionLogger();
        ((DefaultElementContext)sAXManifestParser.getContext()).setMessageReporter(logger);
        ExtensionVisitor extensionVisitor = this.createExtensionVisitor(this._hookFactory);
        sAXManifestParser.getContext().registerChildVisitor(ExtensionVisitor.ELEMENT, extensionVisitor);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ExtensionSource extensionSource = (ExtensionSource)iterator.next();
            this.loadExtension(sAXManifestParser, logger, extensionSource);
        }
        return extensionVisitor.getExtensions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadExtension(SAXManifestParser sAXManifestParser, Logger logger, ExtensionSource extensionSource) {
        sAXManifestParser.getContext().getScopeData().put("extSource", extensionSource);
        URI uRI = extensionSource.getManifestURI();
        InputStream inputStream = null;
        try {
            inputStream = extensionSource.getInputStream();
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setSystemId(uRI.toString());
            this.addToClassPath(extensionSource);
            sAXManifestParser.parse(inputSource);
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Error loading manifest from " + extensionSource.getName(), iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalStateException("Badly configured jaxb");
        }
        catch (SAXException sAXException) {
            logger.log(Level.SEVERE, "Failed to parse manifest from " + extensionSource.getName(), sAXException);
        }
        catch (RuntimeException runtimeException) {
            logger.log(Level.SEVERE, "RuntimeException parsing manifest from " + extensionSource.getName() + ": " + runtimeException);
            runtimeException.printStackTrace();
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                logger.log(Level.SEVERE, "Error closing stream for " + extensionSource.getName(), iOException);
            }
        }
    }

    protected Logger createExtensionLogger() {
        return Logger.getLogger(ExtensionRegistry.class.getName());
    }

    protected abstract ExtensionVisitor createExtensionVisitor(ElementVisitorFactory var1);

    protected abstract void addToClassPath(ExtensionSource var1);

    protected ElementVisitorFactory createHookVisitorFactory() {
        return new DefaultHookVisitorFactory();
    }

    protected void initialize() {
        Collection collection = this.loadExtensions();
        this._extensions = new LinkedHashMap();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Extension extension = (Extension)iterator.next();
            this._extensions.put(extension.getID(), extension);
        }
    }

    public static ExtensionRegistry getExtensionRegistry() {
        try {
            return (ExtensionRegistry)ExtensionRegistry.getService(ExtensionRegistry.class);
        }
        catch (ProviderNotFoundException providerNotFoundException) {
            providerNotFoundException.printStackTrace();
            throw new IllegalStateException("No extension registry");
        }
    }
}

