/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;

public abstract class I18NStringVisitor
extends ElementVisitor {
    protected static final String KEY_RSKEY = "rskey";

    public void start(ElementStartContext elementStartContext) {
        String string = elementStartContext.getAttributeValue(KEY_RSKEY);
        if (string != null && (string = string.trim()).length() == 0) {
            string = null;
        }
        String string2 = (String)elementStartContext.getScopeData().get("rsbundleclass");
        if (string != null && string2 == null) {
            this.log(elementStartContext, Level.WARNING, "'rskey' used without 'rsbundle' on extension element.");
            string = null;
        }
        elementStartContext.getScopeData().put(KEY_RSKEY, string);
    }

    public void end(ElementEndContext elementEndContext) {
        String string = (String)elementEndContext.getScopeData().get(KEY_RSKEY);
        String string2 = null;
        if (string != null) {
            String string3 = (String)elementEndContext.getScopeData().get("rsbundleclass");
            try {
                string2 = this.lookupResource(elementEndContext, string3, string);
            }
            catch (MissingResourceException missingResourceException) {
                this.log(elementEndContext, Level.WARNING, "Resource key '" + string + "' not found in bundle '" + string3 + "'.");
                string2 = null;
            }
        }
        if (string2 == null && (string2 = elementEndContext.getText()) == null) {
            string2 = "";
        }
        this.string(elementEndContext, string2.trim());
    }

    private String lookupResource(ElementContext elementContext, String string, String string2) {
        ClassLoader classLoader = (ClassLoader)elementContext.getScopeData().get("classLoader");
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string, Locale.getDefault(), classLoader);
        return resourceBundle.getString(string2);
    }

    protected abstract void string(ElementContext var1, String var2);
}

