/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension.spi;

import java.net.URI;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.DefaultExtension;
import javax.ide.extension.spi.ExtensionSource;
import javax.ide.util.Version;

public abstract class BaseExtensionVisitor
extends ElementVisitor {
    public static final ElementName ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "extension");
    protected static final ElementName CLASSPATH_ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "classpath");
    public static final String KEY_EXTENSION_SOURCE = "extSource";
    private static final Version MAX_ESDK_VERSION = new Version("1.0");

    protected DefaultExtension processExtension(ElementStartContext elementStartContext) {
        Version version;
        Version version2;
        String string = elementStartContext.getAttributeValue("id");
        if (string == null || (string = string.trim()) == "") {
            this.log(elementStartContext, Level.SEVERE, "Missing required attribute 'id'");
            return null;
        }
        String string2 = elementStartContext.getAttributeValue("version");
        if (string2 == null || (string2 = string2.trim()) == "") {
            this.log(elementStartContext, Level.SEVERE, "Missing required attribute 'version'");
            return null;
        }
        try {
            version2 = new Version(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.log(elementStartContext, Level.SEVERE, "Incorrectly formed version: " + string2);
            return null;
        }
        String string3 = elementStartContext.getAttributeValue("esdk-version");
        if (string3 == null || (string3 = string3.trim()) == "") {
            this.log(elementStartContext, Level.SEVERE, "Missing required attribute 'esdk-version'");
            return null;
        }
        try {
            version = new Version(string3);
        }
        catch (NumberFormatException numberFormatException) {
            this.log(elementStartContext, Level.SEVERE, "Incorrectly formed version: " + string3);
            return null;
        }
        if (version.compareTo(MAX_ESDK_VERSION) > 0) {
            this.log(elementStartContext, Level.SEVERE, "ESDK version " + string3 + " is too high. Maximum supported version is " + MAX_ESDK_VERSION);
            return null;
        }
        DefaultExtension defaultExtension = new DefaultExtension(string);
        defaultExtension.setVersion(version2);
        defaultExtension.setEDKVersion(version);
        defaultExtension.setSource((ExtensionSource)elementStartContext.getScopeData().get(KEY_EXTENSION_SOURCE));
        elementStartContext.getScopeData().put("extension", defaultExtension);
        return defaultExtension;
    }

    protected final DefaultExtension getExtension(ElementContext elementContext) {
        return (DefaultExtension)elementContext.getScopeData().get("extension");
    }

    protected final ExtensionSource getSource(ElementContext elementContext) {
        return (ExtensionSource)elementContext.getScopeData().get(KEY_EXTENSION_SOURCE);
    }

    protected abstract void addToClasspath(ElementContext var1, Extension var2, URI var3);

    private final class ClasspathVisitor
    extends ElementVisitor {
        private ClasspathVisitor() {
        }

        public void end(ElementEndContext elementEndContext) {
            String string = elementEndContext.getText().trim();
            if (string.length() == 0) {
                this.log(elementEndContext, Level.WARNING, "Empty classpath definition");
            }
            DefaultExtension defaultExtension = BaseExtensionVisitor.this.getExtension(elementEndContext);
            BaseExtensionVisitor.this.addToClasspath(elementEndContext, defaultExtension, BaseExtensionVisitor.this.getSource(elementEndContext).resolvePath(defaultExtension, string));
        }
    }

    public final class ClasspathsVisitor
    extends ElementVisitor {
        private final ClasspathVisitor _cpVisitor;

        public ClasspathsVisitor() {
            this._cpVisitor = new ClasspathVisitor();
        }

        public void start(ElementStartContext elementStartContext) {
            elementStartContext.registerChildVisitor(CLASSPATH_ELEMENT, this._cpVisitor);
        }
    }
}

