/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension.spi;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ElementVisitorFactory;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.ExtensionLogRecord;
import javax.ide.extension.spi.ExtensionSource;
import javax.ide.extension.spi.ScopedMap;
import javax.ide.extension.spi.Stack;
import javax.ide.net.URIFactory;
import org.xml.sax.Attributes;

public class DefaultElementContext
implements ElementContext,
ElementStartContext,
ElementEndContext {
    private Attributes _attributes;
    private ElementName _name;
    private final Stack _elementPathStack = new Stack();
    private final ScopedMap _contextMap = new ScopedMap();
    private final Stack _elementText = new Stack();
    private final Stack _childHandlers = new Stack();
    private Map _ceChildHandlers = null;
    private Logger _logger;
    private final Stack _visitorFactoryStack = new Stack();

    public DefaultElementContext() {
        this._childHandlers.push(null);
        this._visitorFactoryStack.push(new ArrayList());
    }

    public ElementName getElementName() {
        return this._name;
    }

    public String getText() {
        StringBuffer stringBuffer = (StringBuffer)this._elementText.peek();
        if (stringBuffer == null) {
            return null;
        }
        return this.processText(stringBuffer.toString());
    }

    public String getAttributeValue(String string) {
        if (this._attributes == null) {
            throw new IllegalStateException("Cannot call from handleEndElement");
        }
        if (string == null) {
            throw new IllegalArgumentException("attributeName must not be null");
        }
        return this.processText(this._attributes.getValue(string));
    }

    public Collection getAttributeNames() {
        if (this._attributes == null) {
            throw new IllegalStateException();
        }
        ArrayList<String> arrayList = new ArrayList<String>(this._attributes.getLength());
        for (int i = 0; i < this._attributes.getLength(); ++i) {
            arrayList.add(this._attributes.getLocalName(i));
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public Map getScopeData() {
        return this._contextMap;
    }

    public void registerChildVisitor(ElementName elementName, ElementVisitor elementVisitor) {
        if (this._ceChildHandlers == null) {
            this._ceChildHandlers = new HashMap();
        }
        this._ceChildHandlers.put(elementName, elementVisitor);
    }

    public void registerVisitorFactory(ElementVisitorFactory elementVisitorFactory) {
        List list = (List)this._visitorFactoryStack.peek();
        list.add(elementVisitorFactory);
    }

    public ElementVisitor getScopedHandler() {
        ElementName elementName = this._name;
        ElementName elementName2 = new ElementName(null, this._name.getLocalName());
        ElementVisitor elementVisitor = null;
        Map map = (Map)this._childHandlers.peek();
        if (map != null) {
            elementVisitor = (ElementVisitor)map.get(elementName);
            if (elementVisitor == null) {
                elementVisitor = (ElementVisitor)map.get(elementName2);
            }
            if (elementVisitor != null) {
                return elementVisitor;
            }
        }
        Iterator iterator = this._visitorFactoryStack.iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            if (list == null) continue;
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                ElementVisitorFactory elementVisitorFactory = (ElementVisitorFactory)iterator2.next();
                ElementVisitor elementVisitor2 = elementVisitorFactory.getVisitor(this._name);
                if (elementVisitor2 == null) continue;
                return elementVisitor2;
            }
        }
        return elementVisitor;
    }

    private void setElement(String string, String string2) {
        this._name = new ElementName(string, string2);
    }

    void beginElement(String string, String string2, Attributes attributes) {
        this.setElement(string, string2);
        this._attributes = attributes;
        this._contextMap.enterScope();
        this._childHandlers.push(this._ceChildHandlers);
        this._visitorFactoryStack.push(new ArrayList());
        this._ceChildHandlers = null;
    }

    void appendCharacters(char[] cArray, int n, int n2) {
        if (this._elementText.isEmpty()) {
            throw new IllegalStateException();
        }
        StringBuffer stringBuffer = (StringBuffer)this._elementText.peek();
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer();
            this._elementText.replace(stringBuffer);
        }
        stringBuffer.append(cArray, n, n2);
    }

    void postEndElement() {
        this._contextMap.exitScope();
        this._elementText.pop();
        this._ceChildHandlers = (Map)this._childHandlers.peek();
        this._childHandlers.pop();
        this._visitorFactoryStack.pop();
        this._name = null;
        this._attributes = null;
    }

    void endElement(String string, String string2) {
        this.setElement(string, string2);
        this._attributes = null;
        this._elementPathStack.pop();
    }

    void postBeginElement() {
        this._elementPathStack.push(this._name);
        this._elementText.push(null);
    }

    public Logger getLogger() {
        if (this._logger == null) {
            this._logger = new NullLogger();
        }
        return this._logger;
    }

    public void setMessageReporter(Logger logger) {
        this._logger = logger;
    }

    public Extension getExtension() {
        return (Extension)this.getScopeData().get("extension");
    }

    public URI getExtensionSourceURI() {
        ExtensionSource extensionSource = (ExtensionSource)this.getScopeData().get("extSource");
        return extensionSource.getURI();
    }

    protected String processText(String string) {
        if (string == null) {
            return null;
        }
        String string2 = this.substituteMacros(string);
        if (string2.startsWith("res:")) {
            return this.resolveResource(string2);
        }
        if (string2.startsWith("uri:")) {
            return this.resolveUri(string2);
        }
        return string2;
    }

    private String resolveUri(String string) {
        if (string.length() > 4) {
            String string2 = string.substring(4);
            Extension extension = (Extension)this.getScopeData().get("extension");
            ExtensionSource extensionSource = (ExtensionSource)this.getScopeData().get("extSource");
            URI uRI = extensionSource.resolvePath(extension, string2);
            if (uRI == null) {
                this.getLogger().log(new ExtensionLogRecord(this, Level.WARNING, "Unresolved uri: '" + string2 + "'."));
                return string;
            }
            return "uri:" + uRI.toString();
        }
        this.getLogger().log(new ExtensionLogRecord(this, Level.SEVERE, "No uri specified."));
        return string;
    }

    private String resolveResource(String string) {
        if (string.length() > 4) {
            String string2 = string.substring(4);
            if (string2.charAt(0) == '/' && string2.length() > 1) {
                ClassLoader classLoader = this.getContextClassLoader();
                URL uRL = classLoader.getResource(string2.substring(1));
                if (uRL != null) {
                    URI uRI = URIFactory.newURI(uRL);
                    return "uri:" + uRI.toString();
                }
            } else {
                URL uRL;
                ResourceBundle resourceBundle = this.getContextResourceBundle();
                if (resourceBundle != null && (uRL = resourceBundle.getClass().getResource(string2)) != null) {
                    URI uRI = URIFactory.newURI(uRL);
                    return "uri:" + uRI.toString();
                }
            }
            this.getLogger().log(new ExtensionLogRecord(this, Level.SEVERE, "Resource not found: '" + string2 + "'."));
            return string;
        }
        this.getLogger().log(new ExtensionLogRecord(this, Level.SEVERE, "No resource specified"));
        return string;
    }

    protected final String substituteMacros(String string) {
        int n;
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while ((n = string.indexOf(36, n2)) != -1) {
            stringBuffer.append(string.substring(n2, n));
            if (n == string.length() - 1) break;
            if (string.charAt(n + 1) == '{') {
                int n3 = string.indexOf(125, n + 1);
                if (n3 == -1) {
                    stringBuffer.append("$");
                    n2 = n + 1;
                    continue;
                }
                String string2 = string.substring(n + 2, n3);
                String string3 = this.getMacroValue(string2);
                if (string3 == null) {
                    stringBuffer.append("${" + string2 + "}");
                } else {
                    stringBuffer.append(string3);
                }
                n2 = n3 + 1;
                continue;
            }
            stringBuffer.append(string.substring(n, n + 2));
            n2 += 2;
        }
        if (n2 < string.length()) {
            stringBuffer.append(string.substring(n2));
        }
        return stringBuffer.toString();
    }

    protected String getMacroValue(String string) {
        ResourceBundle resourceBundle = this.getContextResourceBundle();
        if (resourceBundle != null) {
            try {
                return resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                return null;
            }
        }
        return null;
    }

    private ResourceBundle getContextResourceBundle() {
        ClassLoader classLoader = this.getContextClassLoader();
        String string = (String)this.getScopeData().get("rsbundleclass");
        if (string == null) {
            return null;
        }
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string, Locale.getDefault(), classLoader);
            return resourceBundle;
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    private ClassLoader getContextClassLoader() {
        ClassLoader classLoader = (ClassLoader)this.getScopeData().get("classLoader");
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        return classLoader;
    }

    private class NullLogger
    extends Logger {
        public NullLogger() {
            super(null, null);
        }

        public void log(LogRecord logRecord) {
        }
    }
}

