/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension.spi;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.ide.build.spi.BuildSystemHook;
import javax.ide.editor.spi.EditorHook;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ElementVisitorFactory;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.spi.FeatureHook;
import javax.ide.extension.spi.HookHandlerHook;
import javax.ide.log.spi.LogHook;
import javax.ide.menu.spi.MenuHook;
import javax.ide.model.spi.DocumentHook;
import javax.ide.net.spi.VFSHook;
import javax.ide.property.spi.PropertyHook;
import javax.ide.spi.IDEListenerHook;
import javax.ide.wizard.spi.WizardHook;

public class DefaultHookVisitorFactory
implements ElementVisitorFactory {
    private final Map _hookVisitors = new HashMap();

    public DefaultHookVisitorFactory() {
        this.registerStandardVisitors();
    }

    public final Collection getHooks() {
        return Collections.unmodifiableCollection(this._hookVisitors.values());
    }

    protected final void registerStandardVisitors() {
        this.registerHook(HookHandlerHook.ELEMENT, this.createHookHandlerHook());
        this.registerHook(BuildSystemHook.ELEMENT, this.createBuildSystemHook());
        this.registerHook(FeatureHook.ELEMENT, this.createFeatureHook());
        this.registerHook(LogHook.ELEMENT, this.createLogHook());
        this.registerHook(MenuHook.ELEMENT, this.createMenuHook());
        this.registerHook(DocumentHook.ELEMENT, this.createDocumentHook());
        this.registerHook(PropertyHook.ELEMENT, this.createPropertyHook());
        this.registerHook(IDEListenerHook.ELEMENT, this.createIdeListenerHook());
        this.registerHook(WizardHook.ELEMENT, this.createWizardHook());
        this.registerHook(VFSHook.ELEMENT, this.createVFSHook());
        this.registerHook(EditorHook.ELEMENT, this.createEditorHook());
    }

    protected ExtensionHook createEditorHook() {
        return new EditorHook();
    }

    protected ExtensionHook createVFSHook() {
        return new VFSHook();
    }

    protected ExtensionHook createHookHandlerHook() {
        return new HookHandlerHook(this);
    }

    protected ExtensionHook createWizardHook() {
        return new WizardHook();
    }

    protected ExtensionHook createIdeListenerHook() {
        return new IDEListenerHook();
    }

    protected ExtensionHook createPropertyHook() {
        return new PropertyHook();
    }

    protected ExtensionHook createDocumentHook() {
        return new DocumentHook();
    }

    protected ExtensionHook createMenuHook() {
        return new MenuHook();
    }

    protected ExtensionHook createLogHook() {
        return new LogHook();
    }

    protected ExtensionHook createFeatureHook() {
        return new FeatureHook();
    }

    protected ExtensionHook createBuildSystemHook() {
        return new BuildSystemHook();
    }

    public final ElementVisitor getVisitor(ElementName elementName) {
        return (ElementVisitor)this._hookVisitors.get(elementName);
    }

    boolean isNameRegistered(ElementName elementName) {
        return this._hookVisitors.containsKey(elementName);
    }

    final void registerHook(ElementName elementName, ExtensionHook extensionHook) {
        this._hookVisitors.put(elementName, extensionHook);
    }
}

