/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension.spi;

import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionDependency;
import javax.ide.extension.spi.DefaultExtension;
import javax.ide.util.Version;

public class DependenciesVisitor
extends ElementVisitor {
    public static final ElementName ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "dependencies");
    private static final ElementName IMPORT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "import");
    private ElementVisitor _importVisitor = new ImportVisitor();
    private static final String MIN_VERSION = "minVersion";
    private static final String MAX_VERSION = "maxVersion";

    public final void start(ElementStartContext elementStartContext) {
        elementStartContext.registerChildVisitor(IMPORT, this._importVisitor);
    }

    public final void end(ElementEndContext elementEndContext) {
    }

    protected void addDependency(ElementContext elementContext, DefaultExtension defaultExtension, ExtensionDependency extensionDependency) {
        defaultExtension.addDependency(extensionDependency);
    }

    private class ImportVisitor
    extends ElementVisitor {
        private ImportVisitor() {
        }

        public void start(ElementStartContext elementStartContext) {
            String string = elementStartContext.getAttributeValue(DependenciesVisitor.MIN_VERSION);
            String string2 = elementStartContext.getAttributeValue(DependenciesVisitor.MAX_VERSION);
            Version version = null;
            if (string != null) {
                version = new Version(string);
            }
            Version version2 = null;
            if (string2 != null) {
                version2 = new Version(string2);
            }
            elementStartContext.getScopeData().put(DependenciesVisitor.MIN_VERSION, version);
            elementStartContext.getScopeData().put(DependenciesVisitor.MAX_VERSION, version2);
        }

        public void end(ElementEndContext elementEndContext) {
            String string = elementEndContext.getText().trim();
            if (string.length() == 0) {
                elementEndContext.getLogger().severe("Missing extension id.");
                return;
            }
            ExtensionDependency extensionDependency = new ExtensionDependency(string, (Version)elementEndContext.getScopeData().get(DependenciesVisitor.MIN_VERSION), (Version)elementEndContext.getScopeData().get(DependenciesVisitor.MAX_VERSION));
            DefaultExtension defaultExtension = (DefaultExtension)elementEndContext.getScopeData().get("extension");
            DependenciesVisitor.this.addDependency(elementEndContext, defaultExtension, extensionDependency);
        }
    }
}

