/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension.spi;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionDependency;
import javax.ide.extension.spi.BaseExtensionVisitor;
import javax.ide.extension.spi.DefaultElementContext;
import javax.ide.extension.spi.DefaultExtension;
import javax.ide.extension.spi.DependenciesVisitor;
import javax.ide.extension.spi.ExtensionSource;
import javax.ide.extension.spi.ExtensionVisitor;
import javax.ide.extension.spi.LocatorImpl;
import javax.ide.extension.spi.SAXManifestParser;
import javax.ide.util.Version;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class DependencyTree {
    private static final String SOURCE = "source";
    private final Map _sourcesByExtension;
    private final Map _extensionsById = new HashMap();
    private List _topologicalExtensionList;
    private final Map _unsatisfiedDependencies = new HashMap();
    private final List _cycles = new ArrayList();
    private Object STATE_NOT_VISITED = "notvisited";
    private Object STATE_VISITING = "visiting";
    private Object STATE_VISITED = "visited";

    DependencyTree(List list, Map map) {
        Object object;
        this._sourcesByExtension = map;
        this.removeDuplicates();
        Object object2 = this._sourcesByExtension.keySet().iterator();
        while (object2.hasNext()) {
            object = (Extension)object2.next();
            this._extensionsById.put(object.getID(), object);
        }
        object2 = new TopoSortState();
        object = this._sourcesByExtension.keySet().iterator();
        while (object.hasNext()) {
            Extension extension = (Extension)object.next();
            if (!((TopoSortState)object2).isUnvisited(extension)) continue;
            this.topologicalSort((TopoSortState)object2, extension);
        }
        this._topologicalExtensionList = ((TopoSortState)object2).getTopoList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DependencyTree buildTree(Collection collection, EnabledExtensionLookup enabledExtensionLookup, Logger logger, DefaultElementContext defaultElementContext) {
        Object object;
        Object object2;
        SAXManifestParser sAXManifestParser = new SAXManifestParser(defaultElementContext);
        ((DefaultElementContext)sAXManifestParser.getContext()).setMessageReporter(logger);
        MinimalExtensionVisitor minimalExtensionVisitor = new MinimalExtensionVisitor();
        sAXManifestParser.getContext().registerChildVisitor(ExtensionVisitor.ELEMENT, minimalExtensionVisitor);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object3 = collection.iterator();
        while (object3.hasNext()) {
            object2 = (ExtensionSource)object3.next();
            sAXManifestParser.getContext().getScopeData().put(SOURCE, object2);
            object = null;
            try {
                object = object2.getInputStream();
                InputSource inputSource = new InputSource((InputStream)object);
                inputSource.setSystemId(object2.getManifestURI().toString());
                sAXManifestParser.parse(inputSource);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new IllegalStateException("JAXP is misconfigured");
            }
            catch (SAXException sAXException) {
                sAXManifestParser.getContext().getLogger().log(Level.SEVERE, "Failed to process extension source " + object2.getName() + ": " + sAXException.getLocalizedMessage(), new LocatorImpl(object2.getManifestURI().toString()));
                arrayList.add(object2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                sAXManifestParser.getContext().getLogger().log(Level.SEVERE, object2.getName() + " does not contain an extension manifest.", new LocatorImpl(object2.getManifestURI().toString()));
            }
            catch (IOException iOException) {
                sAXManifestParser.getContext().getLogger().log(Level.SEVERE, "Failed to process extension source " + object2.getName() + ": " + iOException.getLocalizedMessage(), new LocatorImpl(object2.getManifestURI().toString()));
                arrayList.add(object2);
            }
            finally {
                try {
                    if (object == null) continue;
                    ((InputStream)object).close();
                }
                catch (IOException iOException) {
                    sAXManifestParser.getContext().getLogger().log(Level.SEVERE, "Exception closing stream", iOException);
                }
            }
        }
        object3 = minimalExtensionVisitor.getSourcesByExtension();
        object2 = object3.keySet().iterator();
        while (object2.hasNext()) {
            object = (Extension)object2.next();
            if (enabledExtensionLookup.isExtensionEnabled((Extension)object)) continue;
            object2.remove();
        }
        return new DependencyTree(arrayList, (Map)object3);
    }

    private void removeDuplicates() {
        Extension extension;
        HashMap<String, Extension> hashMap = new HashMap<String, Extension>();
        ArrayList<Extension> arrayList = new ArrayList<Extension>();
        Iterator<Object> iterator = this._sourcesByExtension.keySet().iterator();
        while (iterator.hasNext()) {
            extension = (Extension)iterator.next();
            Extension extension2 = (Extension)hashMap.get(extension.getID());
            if (extension2 == null) {
                hashMap.put(extension.getID(), extension);
                continue;
            }
            if (extension.getVersion().compareTo(extension2.getVersion()) > 0) {
                arrayList.add(extension2);
                hashMap.put(extension.getID(), extension);
                continue;
            }
            arrayList.add(extension);
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            extension = (Extension)iterator.next();
            this._sourcesByExtension.remove(extension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void topologicalSort(TopoSortState topoSortState, Extension extension) {
        try {
            topoSortState.startVisiting(extension);
            Iterator iterator = extension.getDependencies().iterator();
            while (iterator.hasNext()) {
                ExtensionDependency extensionDependency = (ExtensionDependency)iterator.next();
                Extension extension2 = (Extension)this._extensionsById.get(extensionDependency.getID());
                if (extension2 == null || topoSortState.isUnsatisfied(extension2) || !this.isVersionSatisfied(extensionDependency, extension2)) {
                    topoSortState.markUnsatisfiedChain();
                    ArrayList<ExtensionDependency> arrayList = (ArrayList<ExtensionDependency>)this._unsatisfiedDependencies.get(extension);
                    if (arrayList == null) {
                        arrayList = new ArrayList<ExtensionDependency>();
                        this._unsatisfiedDependencies.put(extension, arrayList);
                    }
                    arrayList.add(extensionDependency);
                }
                if (extension2 == null) continue;
                if (topoSortState.isVisiting(extension2)) {
                    topoSortState.markCycleChain(extension2);
                }
                if (!topoSortState.isUnvisited(extension2)) continue;
                this.topologicalSort(topoSortState, extension2);
            }
        }
        finally {
            if (!topoSortState.isUnsatisfied(extension)) {
                topoSortState.addToTopo(extension);
            }
            topoSortState.endVisiting(extension);
        }
    }

    private boolean isVersionSatisfied(ExtensionDependency extensionDependency, Extension extension) {
        if (extension != null) {
            if (extensionDependency.getMinimumVersion() != null && extensionDependency.getMinimumVersion().compareTo(extension.getVersion()) > 0) {
                return false;
            }
            if (extensionDependency.getMaximumVersion() != null && extensionDependency.getMaximumVersion().compareTo(extension.getVersion()) < 0) {
                return false;
            }
        }
        return true;
    }

    public List getSortedExtensionIDs() {
        ArrayList<String> arrayList = new ArrayList<String>(this._topologicalExtensionList.size());
        Iterator iterator = this._topologicalExtensionList.iterator();
        while (iterator.hasNext()) {
            Extension extension = (Extension)iterator.next();
            arrayList.add(extension.getID());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Version getResolvedVersion(String string) {
        Extension extension = (Extension)this._extensionsById.get(string);
        return extension.getVersion();
    }

    public Collection getCycles() {
        return this._cycles;
    }

    public Collection getUnsatisfiedExtensions() {
        return Collections.unmodifiableCollection(this._unsatisfiedDependencies.keySet());
    }

    public Collection getUnsatisfiedDependencies(Extension extension) {
        if (extension == null) {
            throw new NullPointerException("unsatisfied is null");
        }
        Collection collection = (Collection)this._unsatisfiedDependencies.get(extension);
        if (collection == null) {
            throw new IllegalArgumentException("Not in the list of unsatisfied extensions: " + extension);
        }
        return Collections.unmodifiableCollection(collection);
    }

    public ExtensionSource getSource(String string) {
        if (string == null) {
            throw new NullPointerException("id is null");
        }
        Extension extension = (Extension)this._extensionsById.get(string);
        if (extension == null) {
            throw new IllegalArgumentException("Unknown extension id " + string);
        }
        return (ExtensionSource)this._sourcesByExtension.get(extension);
    }

    public static interface EnabledExtensionLookup {
        public boolean isExtensionEnabled(Extension var1);
    }

    private static class MinimalExtensionVisitor
    extends BaseExtensionVisitor {
        private final Map _sourcesByExtension = new HashMap();
        private ElementVisitor _dependenciesVisitor = new DependenciesVisitor();

        private MinimalExtensionVisitor() {
        }

        public Map getSourcesByExtension() {
            return this._sourcesByExtension;
        }

        public void start(ElementStartContext elementStartContext) {
            DefaultExtension defaultExtension = this.processExtension(elementStartContext);
            if (defaultExtension != null) {
                elementStartContext.registerChildVisitor(DependenciesVisitor.ELEMENT, this._dependenciesVisitor);
            }
        }

        public void end(ElementEndContext elementEndContext) {
            ExtensionSource extensionSource = (ExtensionSource)elementEndContext.getScopeData().get(DependencyTree.SOURCE);
            Extension extension = (Extension)elementEndContext.getScopeData().get("extension");
            if (extension != null) {
                this._sourcesByExtension.put(extension, extensionSource);
            }
        }

        public void addToClasspath(ElementContext elementContext, Extension extension, URI uRI) {
        }
    }

    private class TopoSortState {
        private Map _stateByExtension = new HashMap();
        private Set _unsatisfied = new HashSet();
        private List _currentlyVisiting = new ArrayList();
        private List _topoList = new ArrayList();

        private TopoSortState() {
        }

        public List getTopoList() {
            return this._topoList;
        }

        public boolean isVisiting(Extension extension) {
            return this._stateByExtension.get(extension) == DependencyTree.this.STATE_VISITING;
        }

        public boolean isVisited(Extension extension) {
            return this._stateByExtension.get(extension) == DependencyTree.this.STATE_VISITED;
        }

        public boolean isUnvisited(Extension extension) {
            Object v = this._stateByExtension.get(extension);
            return v == null || v == DependencyTree.this.STATE_NOT_VISITED;
        }

        public void addUnsatisfied(Extension extension) {
            this._unsatisfied.add(extension);
        }

        public boolean isUnsatisfied(Extension extension) {
            return this._unsatisfied.contains(extension);
        }

        public void startVisiting(Extension extension) {
            this._currentlyVisiting.add(extension);
            this._stateByExtension.put(extension, DependencyTree.this.STATE_VISITING);
        }

        public void endVisiting(Extension extension) {
            this._currentlyVisiting.remove(extension);
            this._stateByExtension.put(extension, DependencyTree.this.STATE_VISITED);
        }

        public void markUnsatisfiedChain() {
            Iterator iterator = this._currentlyVisiting.iterator();
            while (iterator.hasNext()) {
                this.addUnsatisfied((Extension)iterator.next());
            }
        }

        public void markCycleChain(Extension extension) {
            ArrayList<Extension> arrayList = new ArrayList<Extension>();
            arrayList.addAll(this._currentlyVisiting);
            arrayList.add(extension);
            DependencyTree.this._cycles.add(arrayList);
        }

        public void addToTopo(Extension extension) {
            this._topoList.add(extension);
        }
    }
}

