/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension.spi;

import java.util.ArrayList;
import java.util.Collection;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ElementVisitorFactory;
import javax.ide.extension.Extension;
import javax.ide.extension.I18NStringVisitor;
import javax.ide.extension.spi.BaseExtensionVisitor;
import javax.ide.extension.spi.DefaultExtension;
import javax.ide.extension.spi.DependenciesVisitor;

public abstract class ExtensionVisitor
extends BaseExtensionVisitor {
    private static final ElementName NAME = new ElementName("http://jcp.org/jsr/198/extension-manifest", "name");
    private static final ElementName OWNER = new ElementName("http://jcp.org/jsr/198/extension-manifest", "owner");
    private static final ElementName HOOKS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "hooks");
    private static final ElementName CLASSPATHS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "classpaths");
    private ElementVisitor _nameVisitor = this.createNameVisitor();
    private ElementVisitor _ownerVisitor = this.createOwnerVisitor();
    private ElementVisitor _hooksVisitor = this.createHooksVisitor();
    private ElementVisitor _classpathsVisitor = this.createClasspathsVisitor();
    private ElementVisitor _dependenciesVisitor = this.createDependenciesVisitor();
    public static final String KEY_CLASSLOADER = "classLoader";
    private Collection _extensions = new ArrayList();
    private final ElementVisitorFactory _hookVisitorFactory;

    protected ExtensionVisitor(ElementVisitorFactory elementVisitorFactory) {
        this._hookVisitorFactory = elementVisitorFactory;
    }

    public final Collection getExtensions() {
        return this._extensions;
    }

    public final void start(ElementStartContext elementStartContext) {
        DefaultExtension defaultExtension = this.processExtension(elementStartContext);
        if (defaultExtension == null) {
            return;
        }
        elementStartContext.getScopeData().put(KEY_CLASSLOADER, this.getClassLoader(defaultExtension));
        String string = elementStartContext.getAttributeValue("rsbundle-class");
        if (string != null && (string = string.trim()) != "") {
            elementStartContext.getScopeData().put("rsbundleclass", string);
        }
        elementStartContext.registerChildVisitor(NAME, this._nameVisitor);
        elementStartContext.registerChildVisitor(OWNER, this._ownerVisitor);
        elementStartContext.registerChildVisitor(HOOKS, this._hooksVisitor);
        elementStartContext.registerChildVisitor(CLASSPATHS, this._classpathsVisitor);
        elementStartContext.registerChildVisitor(DependenciesVisitor.ELEMENT, this._dependenciesVisitor);
    }

    public final void end(ElementEndContext elementEndContext) {
        this._extensions.add((Extension)elementEndContext.getScopeData().get("extension"));
    }

    protected ElementVisitor createNameVisitor() {
        return new I18NStringVisitor(){

            public void string(ElementContext elementContext, String string) {
                ExtensionVisitor.this.getExtension(elementContext).setName(string);
            }
        };
    }

    protected ElementVisitor createOwnerVisitor() {
        return new I18NStringVisitor(){

            public void string(ElementContext elementContext, String string) {
                ExtensionVisitor.this.getExtension(elementContext).setOwner(string);
            }
        };
    }

    protected ElementVisitor createClasspathsVisitor() {
        return new BaseExtensionVisitor.ClasspathsVisitor();
    }

    protected ElementVisitor createHooksVisitor() {
        return new HooksVisitor();
    }

    protected ElementVisitor createDependenciesVisitor() {
        return new DependenciesVisitor();
    }

    protected ClassLoader getClassLoader(Extension extension) {
        return Thread.currentThread().getContextClassLoader();
    }

    private final class HooksVisitor
    extends ElementVisitor {
        private HooksVisitor() {
        }

        public void start(ElementStartContext elementStartContext) {
            elementStartContext.registerVisitorFactory(ExtensionVisitor.this._hookVisitorFactory);
        }
    }
}

