/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension.spi;

import java.util.HashMap;
import java.util.Map;
import javax.ide.extension.BooleanVisitor;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.I18NStringVisitor;
import javax.ide.extension.spi.Feature;

public final class FeatureHook
extends ExtensionHook {
    public static final ElementName ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "feature-hook");
    private static final ElementName LICENSE = new ElementName("http://jcp.org/jsr/198/extension-manifest", "license");
    private static final ElementName COPYRIGHT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "copyright");
    private static final ElementName ICONPATH = new ElementName("http://jcp.org/jsr/198/extension-manifest", "iconpath");
    private static final ElementName DESCRIPTION = new ElementName("http://jcp.org/jsr/198/extension-manifest", "description");
    private static final ElementName OPTIONAL = new ElementName("http://jcp.org/jsr/198/extension-manifest", "optional");
    private static final ElementName PART_OF = new ElementName("http://jcp.org/jsr/198/extension-manifest", "part-of");
    private ElementVisitor _copyrightHandler = new CopyrightHandler();
    private ElementVisitor _descriptionHandler = new DescriptionHandler();
    private ElementVisitor _licenseHandler = new LicenseHandler();
    private ElementVisitor _iconpathHandler = new IconPathHandler();
    private ElementVisitor _optionalHandler = new OptionalHandler();
    private ElementVisitor _partOfHandler = new PartOfHandler();
    private String KEY_FEATURE = "featurehook.feature";
    private Map _featureMap = new HashMap();

    public Map getFeatures() {
        return this._featureMap;
    }

    public void start(ElementStartContext elementStartContext) {
        elementStartContext.registerChildVisitor(COPYRIGHT, this._copyrightHandler);
        elementStartContext.registerChildVisitor(DESCRIPTION, this._descriptionHandler);
        elementStartContext.registerChildVisitor(ICONPATH, this._iconpathHandler);
        elementStartContext.registerChildVisitor(LICENSE, this._licenseHandler);
        elementStartContext.registerChildVisitor(OPTIONAL, this._optionalHandler);
        elementStartContext.registerChildVisitor(PART_OF, this._partOfHandler);
        Feature feature = new Feature();
        elementStartContext.getScopeData().put(this.KEY_FEATURE, feature);
    }

    public void end(ElementEndContext elementEndContext) {
        this._featureMap.put(super.getExtension(elementEndContext).getID(), this.getFeature(elementEndContext));
    }

    private Feature getFeature(ElementContext elementContext) {
        return (Feature)elementContext.getScopeData().get(this.KEY_FEATURE);
    }

    class OptionalHandler
    extends BooleanVisitor {
        OptionalHandler() {
        }

        public void booleanValue(ElementContext elementContext, boolean bl) {
            FeatureHook.this.getFeature(elementContext).setOptional(bl);
        }
    }

    class PartOfHandler
    extends ElementVisitor {
        PartOfHandler() {
        }

        public void end(ElementEndContext elementEndContext) {
            FeatureHook.this.getFeature(elementEndContext).setPartOf(elementEndContext.getText());
        }
    }

    class IconPathHandler
    extends I18NStringVisitor {
        IconPathHandler() {
        }

        protected void string(ElementContext elementContext, String string) {
        }
    }

    class DescriptionHandler
    extends I18NStringVisitor {
        DescriptionHandler() {
        }

        protected void string(ElementContext elementContext, String string) {
            FeatureHook.this.getFeature(elementContext).setDescription(string);
        }
    }

    class CopyrightHandler
    extends I18NStringVisitor {
        CopyrightHandler() {
        }

        protected void string(ElementContext elementContext, String string) {
            FeatureHook.this.getFeature(elementContext).setCopyright(string);
        }
    }

    class LicenseHandler
    extends I18NStringVisitor {
        LicenseHandler() {
        }

        protected void string(ElementContext elementContext, String string) {
            FeatureHook.this.getFeature(elementContext).setLicense(string);
        }
    }
}

