/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension.spi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.ExtensionSource;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;

public class JARExtensionSource
implements ExtensionSource {
    private static final String MANIFEST_ENTRY = "META-INF/extension.xml";
    private static final String MANIFEST_ALT_ENTRY = "meta-inf/extension.xml";
    private final URI _jarURI;
    private URI _manifestURI;

    public JARExtensionSource(URI uRI) {
        this._jarURI = uRI;
    }

    public final URI getURI() {
        return this._jarURI;
    }

    public final URI getClasspathEntry() {
        return this._jarURI;
    }

    public URI getManifestURI() {
        if (this._manifestURI == null) {
            this._manifestURI = URIFactory.newJarURI(this._jarURI, MANIFEST_ENTRY);
            if (!VirtualFileSystem.getVirtualFileSystem().exists(this._manifestURI)) {
                this._manifestURI = URIFactory.newJarURI(this._jarURI, MANIFEST_ALT_ENTRY);
            }
        }
        return this._manifestURI;
    }

    public URI resolvePath(Extension extension, String string) {
        File file = new File(string);
        if (file.isAbsolute() && file.exists()) {
            return URIFactory.newFileURI(file);
        }
        if (string.length() >= 2 && string.charAt(0) == '/') {
            return URIFactory.newJarURI(this._jarURI, string.substring(1));
        }
        URI uRI = VirtualFileSystem.getVirtualFileSystem().getParent(this._jarURI);
        return URIFactory.newURI(uRI, string);
    }

    public String getName() {
        return VirtualFileSystem.getVirtualFileSystem().toDisplayString(this._jarURI);
    }

    public InputStream getInputStream() throws IOException {
        return VirtualFileSystem.getVirtualFileSystem().openInputStream(this.getManifestURI());
    }
}

