/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension.spi;

import java.io.IOException;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.spi.DefaultElementContext;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class SAXManifestParser {
    private final DefaultElementContext _context;
    private SAXParser _parser = null;
    private Handler _handler = null;
    private Locator _locator;

    public SAXManifestParser(DefaultElementContext defaultElementContext) {
        this._context = defaultElementContext;
    }

    public ElementContext getContext() {
        return this._context;
    }

    public void parse(InputSource inputSource) throws ParserConfigurationException, SAXException, IOException {
        if (this._parser == null) {
            this._handler = new Handler();
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            this._parser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = this._parser.getXMLReader();
            xMLReader.setContentHandler(this._handler);
            xMLReader.setErrorHandler(this._handler);
        }
        this._parser.getXMLReader().parse(inputSource);
    }

    private class Handler
    extends DefaultHandler {
        private Handler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            SAXManifestParser.this._context.beginElement(string, string2, attributes);
            ElementVisitor elementVisitor = SAXManifestParser.this._context.getScopedHandler();
            if (elementVisitor != null) {
                this.recordPosition(SAXManifestParser.this._context);
                try {
                    elementVisitor.start(SAXManifestParser.this._context);
                }
                catch (RuntimeException runtimeException) {
                    SAXManifestParser.this._context.getLogger().log(Level.SEVERE, "Runtime exception processing manifest: " + runtimeException.getClass().getName() + ":" + runtimeException.getMessage(), SAXManifestParser.this._locator);
                    runtimeException.printStackTrace();
                }
            }
            SAXManifestParser.this._context.postBeginElement();
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            SAXManifestParser.this._context.endElement(string, string2);
            ElementVisitor elementVisitor = SAXManifestParser.this._context.getScopedHandler();
            if (elementVisitor != null) {
                this.recordPosition(SAXManifestParser.this._context);
                try {
                    elementVisitor.end(SAXManifestParser.this._context);
                }
                catch (RuntimeException runtimeException) {
                    SAXManifestParser.this._context.getLogger().log(Level.SEVERE, "Runtime exception processing manifest: " + runtimeException.getClass().getName() + ": " + runtimeException.getMessage(), SAXManifestParser.this._locator);
                    runtimeException.printStackTrace();
                }
            }
            SAXManifestParser.this._context.postEndElement();
        }

        public void characters(char[] cArray, int n, int n2) {
            SAXManifestParser.this._context.appendCharacters(cArray, n, n2);
        }

        public void setDocumentLocator(Locator locator) {
            SAXManifestParser.this._locator = locator;
        }

        private void recordPosition(ElementContext elementContext) {
            elementContext.getScopeData().put("xml.locator", SAXManifestParser.this._locator);
        }
    }
}

