/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension.spi;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public final class Stack
extends AbstractCollection {
    private ArrayList _list;

    public Stack() {
    }

    public Stack(Collection collection) {
        this.addAll(collection);
    }

    private List getList() {
        if (this._list == null) {
            this._list = new ArrayList();
        }
        return this._list;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean push(Object object) {
        return this.getList().add(object);
    }

    public Object peek() {
        int n = this.size();
        if (n == 0) {
            throw new IllegalStateException("Illegal peek()");
        }
        return this.getList().get(n - 1);
    }

    public void replace(Object object) {
        int n = this.size();
        if (n == 0) {
            throw new IllegalStateException("Illegal replace()");
        }
        this.getList().set(n - 1, object);
    }

    public Object pop() {
        int n = this.size();
        if (n == 0) {
            throw new IllegalStateException("Illegal pop()");
        }
        Object e = this._list.remove(n - 1);
        if (n == 1) {
            this._list = null;
        }
        return e;
    }

    public Iterator reverseIterator() {
        if (this.isEmpty()) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this._list.iterator();
    }

    public boolean add(Object object) {
        return this.push(object);
    }

    public void clear() {
        if (this._list != null) {
            this._list.clear();
        }
    }

    public Iterator iterator() {
        if (this.isEmpty()) {
            return Collections.EMPTY_LIST.iterator();
        }
        return new ReverseListIterator(this._list);
    }

    public int size() {
        return this._list == null ? 0 : this._list.size();
    }

    private static final class ReverseListIterator
    implements Iterator {
        private final ListIterator _listIterator;

        public ReverseListIterator(List list) {
            this._listIterator = list.listIterator(list.size());
        }

        public boolean hasNext() {
            return this._listIterator.hasPrevious();
        }

        public Object next() {
            return this._listIterator.previous();
        }

        public void remove() {
            this._listIterator.remove();
        }
    }
}

