/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.menu.spi;

import java.util.logging.Level;
import javax.ide.command.Controller;
import javax.ide.extension.BooleanVisitor;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.I18NCharVisitor;
import javax.ide.extension.I18NStringVisitor;
import javax.ide.extension.IconVisitor;
import javax.ide.extension.MetaClassVisitor;
import javax.ide.menu.IDEAction;
import javax.ide.menu.spi.MenuModel;
import javax.ide.util.IconDescription;
import javax.ide.util.MetaClass;

final class ActionsVisitor
extends ElementVisitor {
    static final String KEY_ACTION = "action";
    private static final ElementName ACTION = new ElementName("http://jcp.org/jsr/198/extension-manifest", "action");
    private static final ElementName LABEL = new ElementName("http://jcp.org/jsr/198/extension-manifest", "label");
    private static final ElementName MNEMONIC = new ElementName("http://jcp.org/jsr/198/extension-manifest", "mnemonic");
    private static final ElementName TOOLTIP = new ElementName("http://jcp.org/jsr/198/extension-manifest", "tooltip");
    private static final ElementName ICONPATH = new ElementName("http://jcp.org/jsr/198/extension-manifest", "iconpath");
    private static final ElementName ENABLED = new ElementName("http://jcp.org/jsr/198/extension-manifest", "enabled");
    private static final ElementName CHECKED = new ElementName("http://jcp.org/jsr/198/extension-manifest", "checked");
    private static final ElementName INVOKE_CLASS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "invoke-class");
    private static final ElementName UPDATE_CLASS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "update-class");
    private static final ElementName ACTION_OVERRIDE = new ElementName("http://jcp.org/jsr/198/extension-manifest", "action-override");
    private ElementVisitor _actionHandler = new ActionVisitor();
    private ElementVisitor _labelHandler = new LabelHandler();
    private ElementVisitor _mnemonicHandler = new MnemonicHandler();
    private ElementVisitor _tooltipHandler = new TooltipHandler();
    private ElementVisitor _iconpathHandler = new IconpathHandler();
    private ElementVisitor _enabledHandler = new EnabledHandler();
    private ElementVisitor _checkedHandler = new CheckedHandler();
    private ElementVisitor _invokeClassVisitor = new InvokeClassVisitor();
    private ElementVisitor _updateClassVisitor = new UpdateClassVisitor();
    private ElementVisitor _actionOverrideVisitor = new ActionOverrideVisitor();
    private static final String KEY_CONTROLLER_HOLDER = "controllerHolder";
    private static final String KEY_ACTION_REF = "actionRef";

    ActionsVisitor() {
    }

    public void start(ElementStartContext elementStartContext) {
        elementStartContext.registerChildVisitor(ACTION, this._actionHandler);
        elementStartContext.registerChildVisitor(ACTION_OVERRIDE, this._actionOverrideVisitor);
    }

    private IDEAction getAction(ElementContext elementContext) {
        return (IDEAction)elementContext.getScopeData().get(KEY_ACTION);
    }

    private final class ControllerHolder {
        private MetaClass invokeClass;
        private MetaClass updateClass;

        private ControllerHolder() {
        }
    }

    private class InvokeClassVisitor
    extends MetaClassVisitor {
        private InvokeClassVisitor() {
        }

        public void metaClass(ElementContext elementContext, MetaClass metaClass) {
            ControllerHolder controllerHolder = (ControllerHolder)elementContext.getScopeData().get(ActionsVisitor.KEY_CONTROLLER_HOLDER);
            controllerHolder.invokeClass = metaClass;
        }
    }

    private class UpdateClassVisitor
    extends MetaClassVisitor {
        private UpdateClassVisitor() {
        }

        public void metaClass(ElementContext elementContext, MetaClass metaClass) {
            ControllerHolder controllerHolder = (ControllerHolder)elementContext.getScopeData().get(ActionsVisitor.KEY_CONTROLLER_HOLDER);
            controllerHolder.updateClass = metaClass;
        }
    }

    private class CheckedHandler
    extends BooleanVisitor {
        private CheckedHandler() {
        }

        public void booleanValue(ElementContext elementContext, boolean bl) {
            ActionsVisitor.this.getAction(elementContext).setChecked(bl);
        }
    }

    private class EnabledHandler
    extends BooleanVisitor {
        private EnabledHandler() {
        }

        public void booleanValue(ElementContext elementContext, boolean bl) {
            ActionsVisitor.this.getAction(elementContext).setEnabled(bl);
        }
    }

    private class IconpathHandler
    extends IconVisitor {
        private IconpathHandler() {
        }

        public void icon(ElementContext elementContext, IconDescription iconDescription) {
            ActionsVisitor.this.getAction(elementContext).setIcon(iconDescription);
        }
    }

    private class TooltipHandler
    extends I18NStringVisitor {
        private TooltipHandler() {
        }

        public void string(ElementContext elementContext, String string) {
            ActionsVisitor.this.getAction(elementContext).setToolTip(string);
        }
    }

    private class MnemonicHandler
    extends I18NCharVisitor {
        private MnemonicHandler() {
        }

        public void characterValue(ElementContext elementContext, char c) {
            ActionsVisitor.this.getAction(elementContext).setMnemonic(c);
        }
    }

    private class LabelHandler
    extends I18NStringVisitor {
        private LabelHandler() {
        }

        public void string(ElementContext elementContext, String string) {
            ActionsVisitor.this.getAction(elementContext).setLabel(string);
        }
    }

    private class ActionOverrideVisitor
    extends ElementVisitor {
        private ActionOverrideVisitor() {
        }

        public void start(ElementStartContext elementStartContext) {
            String string = elementStartContext.getAttributeValue("action-ref");
            if (string == null || (string = string.trim()).length() == 0) {
                this.log(elementStartContext, Level.SEVERE, "Missing required attribute 'action-ref'.");
                return;
            }
            elementStartContext.getScopeData().put(ActionsVisitor.KEY_ACTION_REF, string);
            elementStartContext.getScopeData().put(ActionsVisitor.KEY_CONTROLLER_HOLDER, new ControllerHolder());
            elementStartContext.registerChildVisitor(UPDATE_CLASS, ActionsVisitor.this._updateClassVisitor);
            elementStartContext.registerChildVisitor(INVOKE_CLASS, ActionsVisitor.this._invokeClassVisitor);
        }

        public void end(ElementEndContext elementEndContext) {
            ControllerHolder controllerHolder = (ControllerHolder)elementEndContext.getScopeData().get(ActionsVisitor.KEY_CONTROLLER_HOLDER);
            if (controllerHolder.invokeClass == null) {
                this.log(elementEndContext, Level.SEVERE, "Missing required element 'invoke-class'.");
                return;
            }
            String string = (String)elementEndContext.getScopeData().get(ActionsVisitor.KEY_ACTION_REF);
            MenuModel menuModel = (MenuModel)elementEndContext.getScopeData().get("menuModel");
            menuModel.addController(string, new Controller(controllerHolder.invokeClass, controllerHolder.updateClass));
        }
    }

    private class ActionVisitor
    extends ElementVisitor {
        private ActionVisitor() {
        }

        public void start(ElementStartContext elementStartContext) {
            String string = elementStartContext.getAttributeValue("id").trim();
            if (string == null) {
                this.log(elementStartContext, Level.SEVERE, "Missing attribute 'id'");
            } else {
                MenuModel menuModel = (MenuModel)elementStartContext.getScopeData().get("menuModel");
                if (!menuModel.isUniqueActionId(string)) {
                    this.log(elementStartContext, Level.SEVERE, "Duplicate definition of action id '" + string + "'");
                    return;
                }
                String string2 = elementStartContext.getAttributeValue("toggle");
                boolean bl = string2 == null ? false : Boolean.valueOf(string2.trim());
                IDEAction iDEAction = new IDEAction(string);
                iDEAction.setToggleItem(bl);
                elementStartContext.getScopeData().put(ActionsVisitor.KEY_ACTION, iDEAction);
                elementStartContext.getScopeData().put(ActionsVisitor.KEY_CONTROLLER_HOLDER, new ControllerHolder());
                elementStartContext.registerChildVisitor(LABEL, ActionsVisitor.this._labelHandler);
                elementStartContext.registerChildVisitor(MNEMONIC, ActionsVisitor.this._mnemonicHandler);
                elementStartContext.registerChildVisitor(TOOLTIP, ActionsVisitor.this._tooltipHandler);
                elementStartContext.registerChildVisitor(ICONPATH, ActionsVisitor.this._iconpathHandler);
                elementStartContext.registerChildVisitor(ENABLED, ActionsVisitor.this._enabledHandler);
                elementStartContext.registerChildVisitor(CHECKED, ActionsVisitor.this._checkedHandler);
                elementStartContext.registerChildVisitor(UPDATE_CLASS, ActionsVisitor.this._updateClassVisitor);
                elementStartContext.registerChildVisitor(INVOKE_CLASS, ActionsVisitor.this._invokeClassVisitor);
            }
        }

        public void end(ElementEndContext elementEndContext) {
            IDEAction iDEAction = ActionsVisitor.this.getAction(elementEndContext);
            ControllerHolder controllerHolder = (ControllerHolder)elementEndContext.getScopeData().get(ActionsVisitor.KEY_CONTROLLER_HOLDER);
            if (iDEAction.getLabel() == null) {
                this.log(elementEndContext, Level.SEVERE, "Required element 'label' missing.");
                return;
            }
            MenuModel menuModel = (MenuModel)elementEndContext.getScopeData().get("menuModel");
            if (controllerHolder.invokeClass != null) {
                Controller controller = new Controller(controllerHolder.invokeClass, controllerHolder.updateClass);
                menuModel.addController(iDEAction.getID(), controller);
            }
            menuModel.addAction(ActionsVisitor.this.getAction(elementEndContext));
        }
    }
}

