/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.menu.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ide.command.Controller;
import javax.ide.menu.IDEAction;
import javax.ide.menu.spi.MenuBar;
import javax.ide.menu.spi.PopupMenu;
import javax.ide.menu.spi.Toolbar;
import javax.ide.util.MetaClass;

public final class MenuModel {
    private final Map _actions = new HashMap();
    private final Map _pullDownMenus = new HashMap();
    private final Map _popupMenus = new HashMap();
    private final Map _toolbars = new HashMap();
    private final Map _actionControllers = new HashMap();
    private final Set _itemFactories = new HashSet();

    void addAction(IDEAction iDEAction) {
        this._actions.put(iDEAction.getID(), iDEAction);
    }

    boolean isUniqueActionId(String string) {
        return !this._actions.containsKey(string);
    }

    Toolbar findOrCreateToolbar(String string) {
        Toolbar toolbar = (Toolbar)this._toolbars.get(string);
        if (toolbar == null) {
            toolbar = new Toolbar(string);
            this._toolbars.put(string, toolbar);
        }
        return toolbar;
    }

    MenuBar findOrCreatePullDownMenu(String string) {
        MenuBar menuBar = (MenuBar)this._pullDownMenus.get(string);
        if (menuBar == null) {
            menuBar = new MenuBar(string);
            this._pullDownMenus.put(string, menuBar);
        }
        return menuBar;
    }

    PopupMenu findOrCreatePopupMenu(String string) {
        PopupMenu popupMenu = (PopupMenu)this._popupMenus.get(string);
        if (popupMenu == null) {
            popupMenu = new PopupMenu(string);
            this._popupMenus.put(string, popupMenu);
        }
        return popupMenu;
    }

    void addItemFactory(MetaClass metaClass) {
        this._itemFactories.add(new MetaClassWrapper(metaClass));
    }

    public Set getActionsWithControllers() {
        return this._actionControllers.keySet();
    }

    public List getControllers(String string) {
        List list = (List)this._actionControllers.get(string);
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(list);
    }

    void addController(String string, Controller controller) {
        ArrayList<Controller> arrayList = (ArrayList<Controller>)this._actionControllers.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<Controller>();
            this._actionControllers.put(string, arrayList);
        }
        arrayList.add(controller);
    }

    public Map getActions() {
        return this._actions;
    }

    public Map getMenuBars() {
        return this._pullDownMenus;
    }

    public Map getPopupMenus() {
        return this._popupMenus;
    }

    public Map getToolbars() {
        return this._toolbars;
    }

    public Collection getItemFactories() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = this._itemFactories.iterator();
        while (iterator.hasNext()) {
            MetaClassWrapper metaClassWrapper = (MetaClassWrapper)iterator.next();
            try {
                arrayList.add(metaClassWrapper.getInstance());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    private class MetaClassWrapper {
        private MetaClass _metaClass;
        private Object _instance;

        MetaClassWrapper(MetaClass metaClass) {
            this._metaClass = metaClass;
        }

        public Object getInstance() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
            if (this._instance == null) {
                this._instance = this._metaClass.newInstance();
            }
            return this._instance;
        }
    }
}

