/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.menu.spi;

import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.I18NCharVisitor;
import javax.ide.extension.I18NStringVisitor;
import javax.ide.extension.IconVisitor;
import javax.ide.menu.spi.Menu;
import javax.ide.menu.spi.MenuBar;
import javax.ide.menu.spi.PositionableVisitor;
import javax.ide.menu.spi.SectionVisitor;
import javax.ide.util.IconDescription;

class MenuVisitor
extends PositionableVisitor {
    static final ElementName MENU = new ElementName("http://jcp.org/jsr/198/extension-manifest", "menu");
    private static final ElementName LABEL = new ElementName("http://jcp.org/jsr/198/extension-manifest", "label");
    private static final ElementName MNEMONIC = new ElementName("http://jcp.org/jsr/198/extension-manifest", "mnemonic");
    private static final ElementName TOOLTIP = new ElementName("http://jcp.org/jsr/198/extension-manifest", "tooltip");
    private static final ElementName ICONPATH = new ElementName("http://jcp.org/jsr/198/extension-manifest", "iconpath");
    private ElementVisitor _sectionVisitor;

    MenuVisitor() {
    }

    protected void positionable(ElementStartContext elementStartContext, String string, String string2, String string3) {
        MenuBar menuBar = (MenuBar)elementStartContext.getScopeData().get("menuBar");
        Menu menu = menuBar.getMenu(string);
        if (menu == null) {
            menu = new Menu(string);
            menuBar.addMenu(menu);
        }
        this.processMenu(elementStartContext, menu, string2, string3);
    }

    protected final void processMenu(ElementStartContext elementStartContext, final Menu menu, String string, String string2) {
        if (string != null) {
            menu.setBefore(string);
        } else if (string2 != null) {
            menu.setAfter(string2);
        }
        if (this._sectionVisitor == null) {
            this._sectionVisitor = new SectionVisitor();
        }
        elementStartContext.getScopeData().put("sectionContainer", menu);
        elementStartContext.registerChildVisitor(SectionVisitor.SECTION, this._sectionVisitor);
        elementStartContext.registerChildVisitor(LABEL, new I18NStringVisitor(){

            protected void string(ElementContext elementContext, String string) {
                menu.setLabel(string);
            }
        });
        elementStartContext.registerChildVisitor(MNEMONIC, new I18NCharVisitor(){

            protected void characterValue(ElementContext elementContext, char c) {
                menu.setMnemonic(c);
            }
        });
        elementStartContext.registerChildVisitor(TOOLTIP, new I18NStringVisitor(){

            protected void string(ElementContext elementContext, String string) {
                menu.setTooltip(string);
            }
        });
        elementStartContext.registerChildVisitor(ICONPATH, new IconVisitor(){

            protected void icon(ElementContext elementContext, IconDescription iconDescription) {
                menu.setIcon(iconDescription);
            }
        });
    }
}

