/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.menu.spi;

import java.util.logging.Level;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.menu.spi.MenuBar;
import javax.ide.menu.spi.MenuModel;
import javax.ide.menu.spi.MenuVisitor;
import javax.ide.menu.spi.PopupMenu;
import javax.ide.menu.spi.SectionVisitor;

final class MenusVisitor
extends ElementVisitor {
    private static final ElementName MENUBAR = new ElementName("http://jcp.org/jsr/198/extension-manifest", "menubar");
    private static final ElementName POPUP = new ElementName("http://jcp.org/jsr/198/extension-manifest", "popup");
    static final String KEY_MENU_BAR = "menuBar";
    private ElementVisitor _menubarVisitor = new MenuBarVisitor();
    private ElementVisitor _menuVisitor = new MenuVisitor();
    private ElementVisitor _popupVisitor = new PopupVisitor();
    private ElementVisitor _sectionVisitor = new SectionVisitor();

    MenusVisitor() {
    }

    public void start(ElementStartContext elementStartContext) {
        elementStartContext.registerChildVisitor(MENUBAR, this._menubarVisitor);
        elementStartContext.registerChildVisitor(POPUP, this._popupVisitor);
    }

    private final class PopupVisitor
    extends ElementVisitor {
        private PopupVisitor() {
        }

        public void start(ElementStartContext elementStartContext) {
            String string = elementStartContext.getAttributeValue("id");
            if (string == null || (string = string.trim()) == "") {
                this.log(elementStartContext, Level.SEVERE, "Required attribute 'id' missing");
                return;
            }
            MenuModel menuModel = (MenuModel)elementStartContext.getScopeData().get("menuModel");
            PopupMenu popupMenu = menuModel.findOrCreatePopupMenu(string);
            elementStartContext.getScopeData().put("sectionContainer", popupMenu);
            elementStartContext.registerChildVisitor(SectionVisitor.SECTION, MenusVisitor.this._sectionVisitor);
        }
    }

    private final class MenuBarVisitor
    extends ElementVisitor {
        private MenuBarVisitor() {
        }

        public void start(ElementStartContext elementStartContext) {
            String string = elementStartContext.getAttributeValue("id");
            if (string == null || (string = string.trim()) == "") {
                this.log(elementStartContext, Level.SEVERE, "Required attribute 'id' missing");
                return;
            }
            MenuModel menuModel = (MenuModel)elementStartContext.getScopeData().get("menuModel");
            MenuBar menuBar = menuModel.findOrCreatePullDownMenu(string);
            elementStartContext.getScopeData().put(MenusVisitor.KEY_MENU_BAR, menuBar);
            elementStartContext.registerChildVisitor(MenuVisitor.MENU, MenusVisitor.this._menuVisitor);
        }
    }
}

