/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.menu.spi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ide.menu.spi.Positionable;

final class PositionMap {
    private Map _idsToVertices = new LinkedHashMap();
    private Vertex _currentAncestor;
    private List _sortedList;
    private static final Object COLOR_VISITING = "visiting";
    private static final Object COLOR_VISITED = "visited";

    PositionMap() {
    }

    public void add(Positionable positionable) {
        this._sortedList = null;
        Vertex vertex = (Vertex)this._idsToVertices.get(positionable.getID());
        if (vertex == null) {
            vertex = new Vertex(positionable);
            this._idsToVertices.put(positionable.getID(), vertex);
        }
    }

    private void addToGraph(Vertex vertex) {
        Vertex vertex2;
        Iterator iterator;
        Vertex vertex3;
        Positionable positionable = vertex.getPositionable();
        String string = positionable.getBefore();
        String string2 = positionable.getAfter();
        if (string2 == null && string == null && this._currentAncestor != null) {
            string2 = this._currentAncestor.getName();
        }
        if (string2 != null) {
            vertex3 = (Vertex)this._idsToVertices.get(string2);
            if (vertex3 == null) {
                vertex3 = new Vertex(string2);
                this._idsToVertices.put(string2, vertex3);
            }
            vertex.attachAfter(vertex3.getToEdges());
            vertex3.attachAfter(vertex);
            if (vertex.isUndefinedReference()) {
                iterator = vertex.getFromEdges();
                while (iterator.hasNext()) {
                    vertex2 = (Vertex)iterator.next();
                    if (vertex3 == vertex2) continue;
                    vertex3.attachAfter(vertex2);
                }
                vertex.setPositionable(positionable);
            }
        }
        if (string != null) {
            vertex3 = (Vertex)this._idsToVertices.get(string);
            if (vertex3 == null) {
                vertex3 = new Vertex(string);
                this._idsToVertices.put(string, vertex3);
            }
            vertex.attachBefore(vertex3.getFromEdges());
            vertex3.attachBefore(vertex);
            if (vertex.isUndefinedReference()) {
                iterator = vertex.getToEdges();
                while (iterator.hasNext()) {
                    vertex2 = (Vertex)iterator.next();
                    if (vertex3 == vertex2) continue;
                    vertex3.attachBefore(vertex2);
                }
                vertex.setPositionable(positionable);
            }
        }
        this._currentAncestor = vertex;
    }

    public List getSortedItems() {
        if (this._sortedList == null) {
            this._sortedList = this.sort();
        }
        return this._sortedList;
    }

    public Positionable get(String string) {
        Vertex vertex = (Vertex)this._idsToVertices.get(string);
        if (vertex == null || vertex.isUndefinedReference()) {
            return null;
        }
        return vertex.getPositionable();
    }

    private List sort() {
        Object object;
        Object object2;
        Object object3;
        Object object4 = this._idsToVertices.values().iterator();
        while (object4.hasNext()) {
            object3 = (Vertex)object4.next();
            this.addToGraph((Vertex)object3);
        }
        object4 = new HashMap();
        object3 = new ArrayList();
        Object object5 = this._idsToVertices.values().iterator();
        while (object5.hasNext()) {
            object2 = (Vertex)object5.next();
            object = object4.get(object2);
            if (object != null) continue;
            this.visit((Map)object4, (Vertex)object2, (List)object3);
        }
        object5 = new ArrayList(object3.size());
        object2 = object3.listIterator(object3.size());
        while (object2.hasPrevious()) {
            object = (Vertex)object2.previous();
            if (((Vertex)object).isUndefinedReference()) continue;
            ((ArrayList)object5).add(((Vertex)object).getPositionable());
        }
        return object5;
    }

    private void visit(Map map, Vertex vertex, List list) {
        map.put(vertex, COLOR_VISITING);
        Iterator iterator = vertex.getToEdges();
        while (iterator.hasNext()) {
            Vertex vertex2 = (Vertex)iterator.next();
            Object v = map.get(vertex2);
            if (v == COLOR_VISITING || v == COLOR_VISITED) continue;
            this.visit(map, vertex2, list);
        }
        list.add(vertex);
        map.put(vertex, COLOR_VISITED);
    }

    private class Vertex {
        private List _toEdges = new ArrayList();
        private List _fromEdges = new ArrayList();
        private final String _name;
        private Positionable _positionable;

        public Vertex(String string) {
            this._name = string;
        }

        public Vertex(Positionable positionable) {
            this._name = positionable.getID();
            this._positionable = positionable;
        }

        public void setPositionable(Positionable positionable) {
            this._positionable = positionable;
        }

        public Positionable getPositionable() {
            return this._positionable;
        }

        public boolean isUndefinedReference() {
            return this._positionable == null;
        }

        public String getName() {
            return this._name;
        }

        public Iterator getFromEdges() {
            return this._fromEdges.iterator();
        }

        public Iterator getToEdges() {
            return this._toEdges.iterator();
        }

        public void attachBefore(Vertex vertex) {
            if (vertex == this) {
                throw new IllegalArgumentException("Cannot connect a vertex to itself");
            }
            this._fromEdges.add(vertex);
            vertex._toEdges.add(this);
        }

        public void attachAfter(Vertex vertex) {
            if (vertex == this) {
                throw new IllegalArgumentException("Cannot connect a vertex to itself");
            }
            this._toEdges.add(vertex);
            vertex._fromEdges.add(this);
        }

        public void attachAfter(Iterator iterator) {
            while (iterator.hasNext()) {
                Vertex vertex = (Vertex)iterator.next();
                this.attachAfter(vertex);
            }
        }

        public void attachBefore(Iterator iterator) {
            while (iterator.hasNext()) {
                Vertex vertex = (Vertex)iterator.next();
                this.attachBefore(vertex);
            }
        }
    }
}

