/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.menu.spi;

import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.menu.spi.Item;
import javax.ide.menu.spi.Menu;
import javax.ide.menu.spi.MenuVisitor;
import javax.ide.menu.spi.Positionable;
import javax.ide.menu.spi.PositionableVisitor;
import javax.ide.menu.spi.Section;
import javax.ide.menu.spi.SectionContainer;

final class SectionVisitor
extends PositionableVisitor {
    static final ElementName SECTION = new ElementName("http://jcp.org/jsr/198/extension-manifest", "section");
    private static final ElementName ITEM = new ElementName("http://jcp.org/jsr/198/extension-manifest", "item");
    private ElementVisitor _menuVisitor = new MenuInSectionVisitor();
    private ElementVisitor _itemVisitor = new ItemVisitor();
    private static final String KEY_SECTION = "section";

    SectionVisitor() {
    }

    protected void positionable(ElementStartContext elementStartContext, String string, String string2, String string3) {
        SectionContainer sectionContainer = (SectionContainer)elementStartContext.getScopeData().get("sectionContainer");
        Section section = sectionContainer.getSection(string);
        if (section == null) {
            section = new Section(string);
            sectionContainer.addSection(section);
        }
        if (string2 != null) {
            section.setBefore(string2);
        } else if (string3 != null) {
            section.setAfter(string3);
        }
        elementStartContext.getScopeData().put(KEY_SECTION, section);
        elementStartContext.registerChildVisitor(MenuVisitor.MENU, this._menuVisitor);
        elementStartContext.registerChildVisitor(ITEM, this._itemVisitor);
    }

    private Section getSection(ElementContext elementContext) {
        return (Section)elementContext.getScopeData().get(KEY_SECTION);
    }

    private final class MenuInSectionVisitor
    extends MenuVisitor {
        private MenuInSectionVisitor() {
        }

        protected void positionable(ElementStartContext elementStartContext, String string, String string2, String string3) {
            Section section = SectionVisitor.this.getSection(elementStartContext);
            Positionable positionable = section.getItem(string);
            if (positionable == null) {
                positionable = new Menu(string);
                section.addItem(positionable);
            } else if (positionable instanceof Item) {
                this.log(elementStartContext, Level.SEVERE, "'" + string + "' is already defined as an item in section '" + section.getID() + "'");
                return;
            }
            Menu menu = (Menu)positionable;
            this.processMenu(elementStartContext, menu, string2, string3);
        }
    }

    private final class ItemVisitor
    extends PositionableVisitor {
        ItemVisitor() {
            super("action-ref");
        }

        protected void positionable(ElementStartContext elementStartContext, String string, String string2, String string3) {
            Section section = SectionVisitor.this.getSection(elementStartContext);
            Positionable positionable = section.getItem(string);
            if (positionable == null) {
                positionable = new Item(string);
                section.addItem(positionable);
            } else if (positionable instanceof Menu) {
                this.log(elementStartContext, Level.SEVERE, "'" + string + "' is already defined as a menu in section '" + section.getID() + "'");
                return;
            }
            Item item = (Item)positionable;
            String string4 = elementStartContext.getAttributeValue("radiogroup-id");
            if (string4 != null) {
                string4 = string4.trim();
                item.setRadioGroupID(string4);
            }
            if (string2 != null) {
                item.setBefore(string2);
            } else if (string3 != null) {
                item.setAfter(string3);
            }
        }
    }
}

