/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.model.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.spi.ListenerInfo;
import javax.ide.model.spi.SuffixRecognizer;
import javax.ide.model.spi.XMLDocType;
import javax.ide.model.spi.XMLDocTypeRecognizer;
import javax.ide.model.spi.XMLRootElementRecognizer;
import javax.ide.util.MetaClass;

public class DocumentHook
extends ExtensionHook {
    public static final ElementName ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "document-hook");
    private static final ElementName DOCUMENTS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "documents");
    private static final ElementName BY_SUFFIX = new ElementName("http://jcp.org/jsr/198/extension-manifest", "by-suffix");
    private static final ElementName SUFFIX = new ElementName("http://jcp.org/jsr/198/extension-manifest", "suffix");
    private static final ElementName BY_XML_ROOT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "by-xml-root");
    private static final ElementName BY_XML_DOCTYPE = new ElementName("http://jcp.org/jsr/198/extension-manifest", "by-xml-doctype");
    private static final ElementName ROOT_ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "root-element");
    private static final ElementName DOCTYPE = new ElementName("http://jcp.org/jsr/198/extension-manifest", "doctype");
    private static final ElementName BY_RECOGNIZER = new ElementName("http://jcp.org/jsr/198/extension-manifest", "by-recognizer");
    private static final ElementName LISTENERS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "listeners");
    private static final ElementName DOCUMENT_LISTENER = new ElementName("http://jcp.org/jsr/198/extension-manifest", "document-listener");
    private static final ElementName PROPERTY_LISTENER = new ElementName("http://jcp.org/jsr/198/extension-manifest", "property-listener");
    private final ElementVisitor _documentsVisitor = new DocumentsVisitor();
    private final ElementVisitor _bySuffixVisitor = new BySuffixVisitor();
    private final ElementVisitor _byXMLRootVisitor = new ByXMLRootVisitor();
    private final ElementVisitor _byXMLDocTypeVisitor = new ByXMLDocTypeVisitor();
    private final ElementVisitor _byRecognizerVisitor = new ByRecognizerVisitor();
    private final ElementVisitor _rootElementVisitor = new RootElementVisitor();
    private final ElementVisitor _docTypeVisitor = new DocTypeVisitor();
    private final ElementVisitor _suffixVisitor = new SuffixVisitor();
    private final ElementVisitor _listenersVisitor = new ListenersVisitor();
    private final List _documentListeners = new ArrayList();
    private final List _propertyListeners = new ArrayList();
    private final List _suffixRecognizers = new ArrayList();
    private final List _xmlRecognizers = new ArrayList();
    private final List _customRecognizers = new ArrayList();
    private static final String KEY_CURRENT_SUFFIX_RECOGNIZER = "currentSuffixRecognizer";

    public Collection getDocumentListeners() {
        return Collections.unmodifiableCollection(this._documentListeners);
    }

    public Collection getSuffixRecognizers() {
        return Collections.unmodifiableCollection(this._suffixRecognizers);
    }

    public Collection getXMLRecognizers() {
        return Collections.unmodifiableCollection(this._xmlRecognizers);
    }

    public Collection getCustomRecognizers() {
        return Collections.unmodifiableCollection(this._customRecognizers);
    }

    public void start(ElementStartContext elementStartContext) {
        elementStartContext.registerChildVisitor(DOCUMENTS, this._documentsVisitor);
        elementStartContext.registerChildVisitor(LISTENERS, this._listenersVisitor);
    }

    private final SuffixRecognizer getSuffixRecognizer(ElementContext elementContext) {
        return (SuffixRecognizer)elementContext.getScopeData().get(KEY_CURRENT_SUFFIX_RECOGNIZER);
    }

    private MetaClass createMetaClass(ElementContext elementContext, String string) {
        ClassLoader classLoader = (ClassLoader)elementContext.getScopeData().get("classLoader");
        return new MetaClass(classLoader, string);
    }

    private abstract class AbstractListenerVisitor
    extends ElementVisitor {
        private AbstractListenerVisitor() {
        }

        public final void start(ElementStartContext elementStartContext) {
            String string = elementStartContext.getAttributeValue("listener-class");
            if (string == null || (string = string.trim()).length() == 0) {
                this.log(elementStartContext, Level.SEVERE, "Missing required attribute 'listener-class'.");
                return;
            }
            String string2 = elementStartContext.getAttributeValue("source-class");
            ListenerInfo listenerInfo = new ListenerInfo();
            listenerInfo.setListenerClass(DocumentHook.this.createMetaClass(elementStartContext, string));
            listenerInfo.setSourceID(string2);
            this.listenerInfo(elementStartContext, listenerInfo);
        }

        protected abstract void listenerInfo(ElementContext var1, ListenerInfo var2);
    }

    private final class ListenersVisitor
    extends ElementVisitor {
        private ListenersVisitor() {
        }

        public void start(ElementStartContext elementStartContext) {
            elementStartContext.registerChildVisitor(DOCUMENT_LISTENER, new AbstractListenerVisitor(){

                protected void listenerInfo(ElementContext elementContext, ListenerInfo listenerInfo) {
                    DocumentHook.this._documentListeners.add(listenerInfo);
                }
            });
            elementStartContext.registerChildVisitor(PROPERTY_LISTENER, new AbstractListenerVisitor(){

                protected void listenerInfo(ElementContext elementContext, ListenerInfo listenerInfo) {
                    DocumentHook.this._propertyListeners.add(listenerInfo);
                }
            });
        }
    }

    private class ByRecognizerVisitor
    extends ElementVisitor {
        private ByRecognizerVisitor() {
        }

        public void start(ElementStartContext elementStartContext) {
            String string = elementStartContext.getAttributeValue("recognizer-class");
            if (string == null || (string = string.trim()).length() == 0) {
                this.log(elementStartContext, Level.SEVERE, "Missing required attribute 'recognizer-class'.");
                return;
            }
            MetaClass metaClass = DocumentHook.this.createMetaClass(elementStartContext, string);
            DocumentHook.this._customRecognizers.add(metaClass);
        }
    }

    private class DocTypeVisitor
    extends ElementVisitor {
        private DocTypeVisitor() {
        }

        public void start(ElementStartContext elementStartContext) {
            String string;
            XMLDocTypeRecognizer xMLDocTypeRecognizer = (XMLDocTypeRecognizer)DocumentHook.this.getSuffixRecognizer(elementStartContext);
            String string2 = elementStartContext.getAttributeValue("public-id");
            if (string2 != null && string2.trim().length() == 0) {
                string2 = null;
            }
            if ((string = elementStartContext.getAttributeValue("system-id")) != null && string.trim().length() == 0) {
                string = null;
            }
            XMLDocType xMLDocType = new XMLDocType(string2, string);
            xMLDocTypeRecognizer.addDocType(xMLDocType);
        }
    }

    private class RootElementVisitor
    extends ElementVisitor {
        private RootElementVisitor() {
        }

        public void start(ElementStartContext elementStartContext) {
            String string;
            XMLRootElementRecognizer xMLRootElementRecognizer = (XMLRootElementRecognizer)DocumentHook.this.getSuffixRecognizer(elementStartContext);
            String string2 = elementStartContext.getAttributeValue("namespace");
            if (string2 != null && string2.trim().length() == 0) {
                string2 = null;
            }
            if ((string = elementStartContext.getAttributeValue("local-name")) == null || (string = string.trim()).length() == 0) {
                this.log(elementStartContext, Level.SEVERE, "Missing required attribute 'local-name'.");
                return;
            }
            ElementName elementName = new ElementName(string2, string);
            xMLRootElementRecognizer.addRootElement(elementName);
        }
    }

    private final class ByXMLDocTypeVisitor
    extends BySuffixVisitor {
        private ByXMLDocTypeVisitor() {
        }

        protected boolean isSuffixRequired() {
            return false;
        }

        protected String getDefaultDocumentClassType() {
            return "javax.ide.model.xml.XMLDocument";
        }

        protected SuffixRecognizer createSuffixRecognizer(ElementStartContext elementStartContext, MetaClass metaClass) {
            XMLDocTypeRecognizer xMLDocTypeRecognizer = new XMLDocTypeRecognizer(metaClass);
            elementStartContext.registerChildVisitor(DOCTYPE, DocumentHook.this._docTypeVisitor);
            return xMLDocTypeRecognizer;
        }

        protected void registerRecognizer(ElementContext elementContext, SuffixRecognizer suffixRecognizer) {
            XMLDocTypeRecognizer xMLDocTypeRecognizer = (XMLDocTypeRecognizer)suffixRecognizer;
            if (xMLDocTypeRecognizer.getDocTypes().isEmpty()) {
                this.log(elementContext, Level.SEVERE, "Must specify 'doctype'.");
            } else {
                DocumentHook.this._xmlRecognizers.add(xMLDocTypeRecognizer);
            }
        }
    }

    private final class ByXMLRootVisitor
    extends BySuffixVisitor {
        private ByXMLRootVisitor() {
        }

        protected boolean isSuffixRequired() {
            return false;
        }

        protected String getDefaultDocumentClassType() {
            return "javax.ide.model.xml.XMLDocument";
        }

        protected SuffixRecognizer createSuffixRecognizer(ElementStartContext elementStartContext, MetaClass metaClass) {
            XMLRootElementRecognizer xMLRootElementRecognizer = new XMLRootElementRecognizer(metaClass);
            elementStartContext.registerChildVisitor(ROOT_ELEMENT, DocumentHook.this._rootElementVisitor);
            return xMLRootElementRecognizer;
        }

        protected void registerRecognizer(ElementContext elementContext, SuffixRecognizer suffixRecognizer) {
            XMLRootElementRecognizer xMLRootElementRecognizer = (XMLRootElementRecognizer)suffixRecognizer;
            if (xMLRootElementRecognizer.getRootElements().isEmpty()) {
                this.log(elementContext, Level.SEVERE, "Must specify 'root-element'.");
            } else {
                DocumentHook.this._xmlRecognizers.add(xMLRootElementRecognizer);
            }
        }
    }

    private final class SuffixVisitor
    extends ElementVisitor {
        private SuffixVisitor() {
        }

        public void end(ElementEndContext elementEndContext) {
            String string = elementEndContext.getText();
            if (string == null || (string = string.trim()).length() == 0) {
                this.log(elementEndContext, Level.SEVERE, "Must provide text content for 'suffix'.");
                return;
            }
            SuffixRecognizer suffixRecognizer = DocumentHook.this.getSuffixRecognizer(elementEndContext);
            suffixRecognizer.addSuffix(string);
        }
    }

    private class BySuffixVisitor
    extends ElementVisitor {
        private BySuffixVisitor() {
        }

        public final void start(ElementStartContext elementStartContext) {
            String string = elementStartContext.getAttributeValue("document-class");
            if ((string == null || (string = string.trim()).length() == 0) && (string = this.getDefaultDocumentClassType()) == null) {
                this.log(elementStartContext, Level.SEVERE, "Missing attribute 'document-class'.");
                return;
            }
            MetaClass metaClass = DocumentHook.this.createMetaClass(elementStartContext, string);
            SuffixRecognizer suffixRecognizer = this.createSuffixRecognizer(elementStartContext, metaClass);
            elementStartContext.getScopeData().put(DocumentHook.KEY_CURRENT_SUFFIX_RECOGNIZER, suffixRecognizer);
            elementStartContext.registerChildVisitor(SUFFIX, DocumentHook.this._suffixVisitor);
        }

        protected String getDefaultDocumentClassType() {
            return null;
        }

        protected boolean isSuffixRequired() {
            return true;
        }

        public final void end(ElementEndContext elementEndContext) {
            SuffixRecognizer suffixRecognizer = DocumentHook.this.getSuffixRecognizer(elementEndContext);
            if (this.isSuffixRequired() && suffixRecognizer.getSuffixes().isEmpty()) {
                this.log(elementEndContext, Level.SEVERE, "Missing 'suffix' element.");
            } else {
                this.registerRecognizer(elementEndContext, suffixRecognizer);
            }
        }

        protected void registerRecognizer(ElementContext elementContext, SuffixRecognizer suffixRecognizer) {
            DocumentHook.this._suffixRecognizers.add(suffixRecognizer);
        }

        protected SuffixRecognizer createSuffixRecognizer(ElementStartContext elementStartContext, MetaClass metaClass) {
            return new SuffixRecognizer(metaClass);
        }
    }

    private class DocumentsVisitor
    extends ElementVisitor {
        private DocumentsVisitor() {
        }

        public void start(ElementStartContext elementStartContext) {
            elementStartContext.registerChildVisitor(BY_SUFFIX, DocumentHook.this._bySuffixVisitor);
            elementStartContext.registerChildVisitor(BY_XML_ROOT, DocumentHook.this._byXMLRootVisitor);
            elementStartContext.registerChildVisitor(BY_XML_DOCTYPE, DocumentHook.this._byXMLDocTypeVisitor);
            elementStartContext.registerChildVisitor(BY_RECOGNIZER, DocumentHook.this._byRecognizerVisitor);
        }
    }
}

