/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.model.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.ide.model.Element;
import javax.ide.model.spi.ElementImpl;
import javax.ide.spi.LookupProvider;
import javax.ide.spi.ProviderNotFoundException;

public abstract class ModelAdapterFactory {
    private static ModelAdapterFactory _impl;

    public abstract ElementImpl getImpl(Element var1);

    public static ModelAdapterFactory getModelAdapterFactory() {
        try {
            if (_impl == null) {
                Collection collection = LookupProvider.lookupAll(Thread.currentThread().getContextClassLoader(), ModelAdapterFactory.class);
                if (collection.size() == 1) {
                    _impl = (ModelAdapterFactory)collection.iterator().next();
                } else {
                    ArrayList arrayList = new ArrayList(collection);
                    Collections.reverse(arrayList);
                    _impl = new ChainedFactories(arrayList);
                }
            }
        }
        catch (ProviderNotFoundException providerNotFoundException) {
            throw new IllegalStateException("No model adapter factory.");
        }
        return _impl;
    }

    private static final class ChainedFactories
    extends ModelAdapterFactory {
        private final List _factories;

        ChainedFactories(List list) {
            this._factories = list;
        }

        public ElementImpl getImpl(Element element) {
            Iterator iterator = this._factories.iterator();
            while (iterator.hasNext()) {
                ModelAdapterFactory modelAdapterFactory = (ModelAdapterFactory)iterator.next();
                ElementImpl elementImpl = modelAdapterFactory.getImpl(element);
                if (elementImpl == null) continue;
                return elementImpl;
            }
            return null;
        }
    }
}

