/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.net;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import javax.ide.net.VirtualFileSystem;

public final class URIFactory {
    public static final String JAR_URI_SEPARATOR = "!/";
    static final /* synthetic */ boolean $assertionsDisabled;

    public static URI newURI(URI uRI, String string) {
        String string2 = URIFactory.resolveRelative(uRI.getPath(), string);
        if (URIFactory.isJarURI(uRI) && string2.indexOf(JAR_URI_SEPARATOR) < 0) {
            return URIFactory.newJarFileURIImpl(string2);
        }
        return URIFactory.replacePathPart(uRI, string2);
    }

    public static URI newDirURI(URI uRI, String string) {
        return string.endsWith("/") ? URIFactory.newURI(uRI, string) : URIFactory.newURI(uRI, string + "/");
    }

    public static URI newURI(String string, String string2) {
        return URIFactory.newURI(string, null, null, -1, string2, null, null);
    }

    public static URI newDirURI(String string, String string2) {
        return string2.endsWith("/") ? URIFactory.newURI(string, string2) : URIFactory.newURI(string, string2 + "/");
    }

    public static URI newUniqueURI(URI uRI, NameGenerator nameGenerator) {
        URI uRI2;
        do {
            String string;
            if ((uRI2 = URIFactory.newURI(uRI, string = nameGenerator.nextName())) != null) continue;
            return null;
        } while (VirtualFileSystem.getVirtualFileSystem().isBound(uRI2));
        return uRI2;
    }

    public static URI replaceSchemePart(URI uRI, String string) {
        String string2 = uRI.getUserInfo();
        String string3 = uRI.getHost();
        int n = uRI.getPort();
        String string4 = uRI.getPath();
        String string5 = uRI.getQuery();
        String string6 = uRI.getFragment();
        return URIFactory.newURI(string, string2, string3, n, string4, string5, string6);
    }

    public static URI replacePortPart(URI uRI, int n) {
        String string = uRI.getScheme();
        String string2 = uRI.getUserInfo();
        String string3 = uRI.getHost();
        String string4 = uRI.getPath();
        String string5 = uRI.getQuery();
        String string6 = uRI.getFragment();
        return URIFactory.newURI(string, string2, string3, n, string4, string5, string6);
    }

    public static URI replaceHostPart(URI uRI, String string) {
        String string2 = uRI.getScheme();
        String string3 = uRI.getUserInfo();
        int n = uRI.getPort();
        String string4 = uRI.getPath();
        String string5 = uRI.getQuery();
        String string6 = uRI.getFragment();
        return URIFactory.newURI(string2, string3, string, n, string4, string5, string6);
    }

    public static URI replacePathPart(URI uRI, String string) {
        String string2 = uRI.getScheme();
        String string3 = uRI.getUserInfo();
        String string4 = uRI.getHost();
        int n = uRI.getPort();
        String string5 = uRI.getQuery();
        String string6 = uRI.getFragment();
        return URIFactory.newURI(string2, string3, string4, n, string, string5, string6);
    }

    public static URI replaceFragmentPart(URI uRI, String string) {
        String string2 = uRI.getScheme();
        String string3 = uRI.getUserInfo();
        String string4 = uRI.getHost();
        int n = uRI.getPort();
        String string5 = uRI.getPath();
        String string6 = uRI.getQuery();
        return URIFactory.newURI(string2, string3, string4, n, string5, string6, string);
    }

    public static URI replaceQueryPart(URI uRI, String string) {
        String string2 = uRI.getScheme();
        String string3 = uRI.getUserInfo();
        String string4 = uRI.getHost();
        int n = uRI.getPort();
        String string5 = uRI.getPath();
        String string6 = uRI.getFragment();
        return URIFactory.newURI(string2, string3, string4, n, string5, string, string6);
    }

    public static URI newURI(String string) {
        return URIFactory.newURI(string, false, false);
    }

    static URI newURI(String string, boolean bl, boolean bl2) {
        int n;
        if (string == null) {
            return null;
        }
        if (bl && !string.endsWith("/")) {
            string = string + "/";
        }
        if ((n = string.length()) > 0 && (string.charAt(0) == File.separatorChar || n > 1 && string.charAt(1) == ':' || string.indexOf(58) < 0 && bl2)) {
            return URIFactory.newFileURI(string);
        }
        if (string.toLowerCase().startsWith("file:")) {
            return URIFactory.newFileURI(string.substring(5));
        }
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public static URI newFileURI(String string) {
        if (string == null) {
            return null;
        }
        String string2 = URIFactory.sanitizePath(string);
        return URIFactory.newURI("file", string2);
    }

    public static URI newFileURI(File file) {
        if (file == null) {
            return null;
        }
        String string = file.getAbsolutePath();
        if (file.isDirectory()) {
            return URIFactory.newDirURI(string);
        }
        return URIFactory.newFileURI(string);
    }

    public static URI newDirURI(String string) {
        if (string == null) {
            return null;
        }
        String string2 = URIFactory.sanitizePath(string);
        if (!string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        return URIFactory.newURI("file", string2);
    }

    public static URI newDirURI(File file) {
        return file != null ? URIFactory.newDirURI(file.getAbsolutePath()) : null;
    }

    public static URI newJarURI(File file, String string) {
        URI uRI = URIFactory.newFileURI(file);
        return URIFactory.newJarURI(uRI, string);
    }

    public static boolean isJarURI(URI uRI) {
        return uRI != null ? uRI.getScheme().equals("jar") : false;
    }

    public static boolean isArchive(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return false;
        }
        String string2 = string.substring(n).toLowerCase();
        return string2.equals(".jar") || string2.equals(".zip");
    }

    public static URI newJarURI(URI uRI, String string) {
        if (URIFactory.isJarURI(uRI)) {
            String string2 = uRI.getPath();
            int n = string2.indexOf(JAR_URI_SEPARATOR);
            if (n < 0) {
                throw new IllegalArgumentException("Bad jar uri: " + uRI);
            }
            StringBuffer stringBuffer = new StringBuffer(string2);
            if (!string2.endsWith("/")) {
                stringBuffer.append('/');
            }
            if (string != null) {
                stringBuffer.append(string);
            }
            return URIFactory.replacePathPart(uRI, stringBuffer.toString());
        }
        try {
            StringBuffer stringBuffer = new StringBuffer(URLDecoder.decode(uRI.toString(), "UTF-8"));
            stringBuffer.insert(0, '/');
            stringBuffer.append(JAR_URI_SEPARATOR);
            if (string != null) {
                stringBuffer.append(string);
            }
            return URIFactory.newURI("jar", stringBuffer.toString());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
    }

    public static URI newURI(String string, String string2, String string3, int n, String string4, String string5, String string6) {
        try {
            return new URI(string, string2, string3, n, string4, string5, string6);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static URI newURI(URL uRL) {
        String string = uRL.getPath();
        if ("jar".equalsIgnoreCase(uRL.getProtocol())) {
            string = "/" + string;
        }
        return URIFactory.newURI(uRL.getProtocol(), uRL.getUserInfo(), uRL.getHost(), uRL.getPort(), string, uRL.getQuery(), uRL.getRef());
    }

    private static String sanitizePath(String string) {
        if (File.separatorChar != '/') {
            string = string.replace(File.separatorChar, '/');
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        return string;
    }

    private static String resolveRelative(String string, String string2) {
        int n;
        int n2;
        int n3;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n4 = 0;
        while (true) {
            String string3;
            n2 = (n3 = string.indexOf(47, n4)) == -1 ? 1 : 0;
            String string4 = string3 = n2 != 0 ? string.substring(n4) : string.substring(n4, n3);
            if (string3.length() > 0 || n3 == n4 + 1) {
                arrayList.add(string3);
            }
            if (n2 != 0) break;
            n4 = n3 + 1;
        }
        n4 = 0;
        n3 = 0;
        while (true) {
            String string5;
            boolean bl = (n2 = string2.indexOf(47, n3)) == -1;
            String string6 = string5 = bl ? string2.substring(n3) : string2.substring(n3, n2);
            if (string5.length() > 0) {
                if (string5.equals("..")) {
                    int n5 = arrayList.size();
                    if (n5 > 0) {
                        arrayList.remove(n5 - 1);
                    }
                    n4 = 1;
                } else if (string5.equals(".")) {
                    n4 = 1;
                } else {
                    arrayList.add(string5);
                    n4 = 0;
                }
            }
            if (bl) break;
            n3 = n2 + 1;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (string.startsWith("//")) {
            stringBuffer.append("//");
        } else if (string.startsWith("/")) {
            stringBuffer.append('/');
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString()).append('/');
        }
        if (n4 == 0 && !string2.endsWith("/") && string2.length() != 0 && (n = stringBuffer.length()) > 0) {
            stringBuffer.setLength(n - 1);
        }
        return stringBuffer.toString();
    }

    private static URI newJarFileURIImpl(String string) {
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            return null;
        }
    }

    private URIFactory() {
    }

    static {
        $assertionsDisabled = !URIFactory.class.desiredAssertionStatus();
    }

    public static interface NameGenerator {
        public String nextName();
    }
}

