/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.net;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;

public final class URIPath {
    private final ArrayList _entriesList;

    public URIPath() {
        this._entriesList = new ArrayList();
    }

    public URIPath(int n) {
        this._entriesList = new ArrayList(n);
    }

    public URIPath(URI uRI) {
        this();
        this.add(uRI);
    }

    public URIPath(URI[] uRIArray) {
        this();
        this.add(uRIArray);
    }

    public URIPath(URIPath uRIPath) {
        this();
        if (uRIPath != null) {
            this._entriesList.addAll(uRIPath._entriesList);
        }
    }

    public URIPath(String string) {
        this();
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            this._entriesList.add(this.pathToURI(string2));
        }
    }

    public void add(URI uRI) {
        if (uRI != null && !this.contains(uRI)) {
            this._entriesList.add(uRI);
        }
    }

    public void add(URI[] uRIArray) {
        if (uRIArray != null) {
            int n = uRIArray.length;
            for (int i = 0; i < n; ++i) {
                this.add(uRIArray[i]);
            }
        }
    }

    public void add(URIPath uRIPath) {
        if (uRIPath != null) {
            this.add(uRIPath.getEntries());
        }
    }

    public URI[] getEntries() {
        return this._entriesList.toArray(new URI[this._entriesList.size()]);
    }

    public boolean contains(URI uRI) {
        return this.findEntry(uRI) >= 0;
    }

    public void remove(URI uRI) {
        int n;
        if (uRI != null && (n = this.findEntry(uRI)) >= 0) {
            this._entriesList.remove(n);
        }
    }

    public Iterator iterator() {
        return this._entriesList.iterator();
    }

    public String toRelativePath(URI uRI) {
        if (uRI != null) {
            URI[] uRIArray = this.getEntries();
            int n = uRIArray.length;
            for (int i = 0; i < n; ++i) {
                URI uRI2 = uRIArray[i];
                String string = VirtualFileSystem.getVirtualFileSystem().toRelativeSpec(uRI, uRI2, true);
                if (string == null) continue;
                return string;
            }
        }
        return null;
    }

    public URI toQualifiedURI(String string) {
        if (string != null) {
            URI[] uRIArray = this.getEntries();
            for (int i = 0; i < uRIArray.length; ++i) {
                URI uRI = uRIArray[i];
                URI uRI2 = uRI.getScheme().equals("jar") ? URIFactory.newJarURI(uRI, string) : URIFactory.newURI(uRI, string);
                if (!VirtualFileSystem.getVirtualFileSystem().exists(uRI2)) continue;
                return uRI2;
            }
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((URIPath)object);
    }

    protected final boolean equalsImpl(URIPath uRIPath) {
        if (this == uRIPath) {
            return true;
        }
        if (this._entriesList.size() != uRIPath._entriesList.size()) {
            return false;
        }
        Iterator iterator = this._entriesList.iterator();
        Iterator iterator2 = uRIPath._entriesList.iterator();
        while (iterator.hasNext()) {
            URI uRI = (URI)iterator.next();
            URI uRI2 = (URI)iterator2.next();
            if (VirtualFileSystem.getVirtualFileSystem().equals(uRI, uRI2)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        URI[] uRIArray = this.getEntries();
        int n2 = uRIArray.length;
        for (n = 0; n < n2; ++n) {
            URI uRI = uRIArray[n];
            String string = VirtualFileSystem.getVirtualFileSystem().getPlatformPathName(uRI);
            stringBuffer.append(string).append(File.pathSeparatorChar);
        }
        n = stringBuffer.length();
        if (n > 0) {
            stringBuffer.setLength(n - 1);
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private int findEntry(URI uRI) {
        if (uRI != null) {
            URI[] uRIArray = this.getEntries();
            int n = uRIArray.length;
            for (int i = 0; i < n; ++i) {
                if (!VirtualFileSystem.getVirtualFileSystem().equals(uRI, uRIArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    private URI pathToURI(String string) {
        if (URIFactory.isArchive(string)) {
            URI uRI = URIFactory.newFileURI(string);
            return URIFactory.newJarURI(uRI, "");
        }
        File file = new File(string);
        try {
            return URIFactory.newDirURI(file.getCanonicalPath());
        }
        catch (IOException iOException) {
            return URIFactory.newDirURI(file.getAbsolutePath());
        }
    }
}

