/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.net;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.ide.Service;
import javax.ide.net.URIExistsTest;
import javax.ide.net.URIFilter;
import javax.ide.net.VirtualFileSystemHelper;
import javax.ide.spi.ProviderNotFoundException;

public class VirtualFileSystem
extends Service {
    private static final int COPY_BUFFER_SIZE = 4096;
    public static final String FILE_SCHEME = "file";
    public static final String HTTP_SCHEME = "http";
    public static final String JAR_SCHEME = "jar";
    private static final boolean _isCaseSensitive;
    private final HashMap _helpers = new HashMap();
    private final VirtualFileSystemHelper _defaultHelper = new VirtualFileSystemHelper();
    private final ArrayList _existsTests = new ArrayList(3);

    public void registerHelper(String string, VirtualFileSystemHelper virtualFileSystemHelper) {
        if (string == null) {
            throw new NullPointerException("scheme must not be null");
        }
        if ((string = string.trim()).length() == 0) {
            throw new IllegalArgumentException("cannot use empty string for scheme");
        }
        if (virtualFileSystemHelper == null) {
            throw new NullPointerException("helper must not be null");
        }
        this._helpers.put(string, virtualFileSystemHelper);
    }

    public VirtualFileSystemHelper findHelper(String string) {
        if (string == null) {
            throw new NullPointerException("scheme must not be null");
        }
        Object v = this._helpers.get(string);
        return v != null ? (VirtualFileSystemHelper)v : this._defaultHelper;
    }

    public VirtualFileSystemHelper findHelper(URI uRI) {
        if (uRI == null) {
            return this._defaultHelper;
        }
        String string = uRI.getScheme();
        return this.findHelper(string);
    }

    public void addExistsTest(URIExistsTest uRIExistsTest) {
        if (uRIExistsTest == null) {
            throw new NullPointerException("existsTest must not be null");
        }
        this._existsTests.add(uRIExistsTest);
    }

    public URI canonicalize(URI uRI) throws IOException {
        return this.findHelper(uRI).canonicalize(uRI);
    }

    public boolean canRead(URI uRI) {
        return this.findHelper(uRI).canRead(uRI);
    }

    public boolean canWrite(URI uRI) {
        return this.findHelper(uRI).canWrite(uRI);
    }

    public boolean canCreate(URI uRI) {
        return this.findHelper(uRI).canCreate(uRI);
    }

    public boolean isValid(URI uRI) {
        return this.findHelper(uRI).isValid(uRI);
    }

    public URI convertSuffix(URI uRI, String string, String string2) {
        return this.findHelper(uRI).convertSuffix(uRI, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(URI uRI, URI uRI2) throws IOException {
        if (uRI == null) {
            throw new NullPointerException("src uri must not be null");
        }
        if (uRI2 == null) {
            throw new NullPointerException("dst uri must not be null");
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = this.openInputStream(uRI);
            outputStream = this.openOutputStream(uRI2);
            if (!this.mkdirs(uRI2)) {
                throw new IOException("Failed to create parent directories for " + uRI2);
            }
            VirtualFileSystem.copy(inputStream, outputStream);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(InputStream inputStream, URI uRI) throws IOException {
        if (inputStream == null) {
            throw new NullPointerException("in must not be null");
        }
        if (uRI == null) {
            throw new NullPointerException("dst must not be null");
        }
        OutputStream outputStream = null;
        try {
            outputStream = this.openOutputStream(uRI);
            this.mkdirs(uRI);
            VirtualFileSystem.copy(inputStream, outputStream);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(URI uRI, File file) throws IOException {
        if (uRI == null) {
            throw new NullPointerException("src must not be null");
        }
        if (file == null) {
            throw new NullPointerException("dst must not be null");
        }
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            inputStream = this.openInputStream(uRI);
            fileOutputStream = new FileOutputStream(file);
            file.mkdirs();
            VirtualFileSystem.copy(inputStream, fileOutputStream);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            try {
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    public boolean delete(URI uRI) {
        return this.findHelper(uRI).delete(uRI);
    }

    public URI ensureSuffix(URI uRI, String string) {
        if (uRI == null) {
            throw new NullPointerException("uri must not be null");
        }
        if (string == null) {
            throw new NullPointerException("suffix must not be null");
        }
        return this.findHelper(uRI).ensureSuffix(uRI, string);
    }

    public boolean equals(URI uRI, URI uRI2) {
        if (uRI == uRI2) {
            return true;
        }
        if (!VirtualFileSystem.schemesAreEqual(uRI, uRI2)) {
            return false;
        }
        return this.findHelper(uRI).equals(uRI, uRI2);
    }

    public boolean exists(URI uRI) {
        if (uRI == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uRI).exists(uRI);
    }

    public String getFileName(URI uRI) {
        if (uRI == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uRI).getFileName(uRI);
    }

    public long getLength(URI uRI) {
        if (uRI == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uRI).getLength(uRI);
    }

    public String getName(URI uRI) {
        if (uRI == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uRI).getName(uRI);
    }

    public URI getParent(URI uRI) {
        if (uRI == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uRI).getParent(uRI);
    }

    public String getPath(URI uRI) {
        if (uRI == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uRI).getPath(uRI);
    }

    public String getPathNoExt(URI uRI) {
        if (uRI == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uRI).getPathNoExt(uRI);
    }

    public String getPlatformPathName(URI uRI) {
        if (uRI == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uRI).getPlatformPathName(uRI);
    }

    public String getSuffix(URI uRI) {
        if (uRI == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uRI).getSuffix(uRI);
    }

    public boolean hasSuffix(URI uRI, String string) {
        if (uRI == null) {
            throw new NullPointerException("uri must not be null");
        }
        if (string == null) {
            throw new NullPointerException("suffix must not be null");
        }
        return this.findHelper(uRI).hasSuffix(uRI, string);
    }

    public boolean isBaseURIFor(URI uRI, URI uRI2) {
        if (uRI == null || uRI2 == null) {
            return false;
        }
        if (uRI == uRI2) {
            return true;
        }
        if (!VirtualFileSystem.schemesAreEqual(uRI, uRI2)) {
            return false;
        }
        return this.findHelper(uRI).isBaseURIFor(uRI, uRI2);
    }

    public boolean isBound(URI uRI) {
        if (uRI == null) {
            throw new NullPointerException("uri must not be null");
        }
        Iterator iterator = this._existsTests.iterator();
        while (iterator.hasNext()) {
            URIExistsTest uRIExistsTest = (URIExistsTest)iterator.next();
            if (!uRIExistsTest.uriExists(uRI)) continue;
            return true;
        }
        return this.exists(uRI);
    }

    public static boolean isLocalFileSystemCaseSensitive() {
        return _isCaseSensitive;
    }

    public boolean isDirectory(URI uRI) {
        if (uRI == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uRI).isDirectory(uRI);
    }

    public boolean isDirectoryPath(URI uRI) {
        if (uRI == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uRI).isDirectoryPath(uRI);
    }

    public boolean isHidden(URI uRI) {
        if (uRI == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uRI).isHidden(uRI);
    }

    public boolean isReadOnly(URI uRI) {
        if (uRI == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uRI).isReadOnly(uRI);
    }

    public boolean isRegularFile(URI uRI) {
        if (uRI == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uRI).isRegularFile(uRI);
    }

    public boolean isRoot(URI uRI) {
        if (uRI == null) {
            throw new NullPointerException("uri must not be null");
        }
        URI[] uRIArray = this.listRoots();
        int n = uRIArray.length;
        for (int i = 0; i < n; ++i) {
            if (!this.equals(uRI, uRIArray[i])) continue;
            return true;
        }
        return false;
    }

    public long lastModified(URI uRI) {
        if (uRI == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uRI).lastModified(uRI);
    }

    public URI[] list(URI uRI) {
        if (uRI == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uRI).list(uRI);
    }

    public URI[] list(URI uRI, URIFilter uRIFilter) {
        if (uRI == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uRI).list(uRI, uRIFilter);
    }

    public URI[] listRoots() {
        ArrayList<URI> arrayList = new ArrayList<URI>(40);
        ArrayList arrayList2 = new ArrayList(this._helpers.keySet());
        Collections.sort(arrayList2);
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            VirtualFileSystemHelper virtualFileSystemHelper = (VirtualFileSystemHelper)this._helpers.get(string);
            URI[] uRIArray = virtualFileSystemHelper.listRoots();
            if (uRIArray == null) continue;
            arrayList.addAll(Arrays.asList(uRIArray));
        }
        return arrayList.toArray(new URI[arrayList.size()]);
    }

    public boolean mkdir(URI uRI) {
        if (uRI == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uRI).mkdir(uRI);
    }

    public boolean mkdirs(URI uRI) {
        if (uRI == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uRI).mkdirs(uRI);
    }

    public URI createTempFile(String string, String string2, URI uRI) throws IOException {
        if (string == null || string.length() < 3) {
            throw new IllegalArgumentException("prefix must be at least three characters long");
        }
        return uRI != null ? this.findHelper(uRI).createTempFile(string, string2, uRI) : this.findHelper(FILE_SCHEME).createTempFile(string, string2, null);
    }

    public InputStream openInputStream(URI uRI) throws IOException {
        if (uRI == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uRI).openInputStream(uRI);
    }

    public OutputStream openOutputStream(URI uRI) throws IOException {
        if (uRI == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uRI).openOutputStream(uRI);
    }

    public boolean renameTo(URI uRI, URI uRI2) {
        if (uRI == null || uRI2 == null) {
            return false;
        }
        if (uRI == uRI2 || uRI.equals(uRI2)) {
            return false;
        }
        if (!VirtualFileSystem.schemesAreEqual(uRI, uRI2)) {
            try {
                this.copy(uRI, uRI2);
            }
            catch (IOException iOException) {
                return false;
            }
            return this.delete(uRI);
        }
        return this.findHelper(uRI).renameTo(uRI, uRI2);
    }

    public boolean setLastModified(URI uRI, long l) {
        if (uRI == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uRI).setLastModified(uRI, l);
    }

    public boolean setReadOnly(URI uRI, boolean bl) {
        if (uRI == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uRI).setReadOnly(uRI, bl);
    }

    public String toDisplayString(URI uRI) {
        if (uRI == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uRI).toDisplayString(uRI);
    }

    public String toRelativeSpec(URI uRI, URI uRI2) {
        if (uRI == null) {
            throw new NullPointerException("uri must not be null");
        }
        if (uRI2 == null) {
            throw new NullPointerException("base must not be null");
        }
        return this.findHelper(uRI).toRelativeSpec(uRI, uRI2);
    }

    public String toRelativeSpec(URI uRI, URI uRI2, boolean bl) {
        return this.findHelper(uRI).toRelativeSpec(uRI, uRI2, bl);
    }

    public URI getBaseParent(URI uRI, String string) {
        return this.findHelper(uRI).getBaseParent(uRI, string);
    }

    public URL toURL(URI uRI) throws MalformedURLException {
        return this.findHelper(uRI).toURL(uRI);
    }

    private static boolean schemesAreEqual(URI uRI, URI uRI2) {
        if (uRI == null || uRI2 == null) {
            return false;
        }
        String string = uRI.getScheme();
        String string2 = uRI2.getScheme();
        return string.equals(string2);
    }

    public static VirtualFileSystem getVirtualFileSystem() {
        try {
            return (VirtualFileSystem)VirtualFileSystem.getService(VirtualFileSystem.class);
        }
        catch (ProviderNotFoundException providerNotFoundException) {
            providerNotFoundException.printStackTrace();
            throw new IllegalStateException("No virtual file system");
        }
    }

    static {
        File file = new File("A");
        File file2 = new File("a");
        _isCaseSensitive = !file.equals(file2);
    }
}

