/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.ide.net.URIFilter;

public class VirtualFileSystemHelper {
    protected VirtualFileSystemHelper() {
    }

    public URI canonicalize(URI uRI) throws IOException {
        return uRI;
    }

    public boolean canRead(URI uRI) {
        return false;
    }

    public boolean canWrite(URI uRI) {
        return false;
    }

    public boolean canCreate(URI uRI) {
        return true;
    }

    public boolean isValid(URI uRI) {
        if (this.exists(uRI)) {
            return true;
        }
        return this.canCreate(uRI);
    }

    public URI convertSuffix(URI uRI, String string, String string2) {
        String string3;
        String string4 = uRI.getPath();
        if (string4.endsWith(string)) {
            int n = string4.length() - string.length();
            string3 = string4.substring(0, n) + string2;
        } else {
            string3 = string4 + string2;
        }
        return this.replacePathPart(uRI, string3);
    }

    public boolean delete(URI uRI) {
        return false;
    }

    public URI ensureSuffix(URI uRI, String string) {
        if (this.hasSuffix(uRI, string)) {
            return uRI;
        }
        String string2 = uRI.getPath();
        return this.replacePathPart(uRI, string2 + string);
    }

    public boolean equals(URI uRI, URI uRI2) {
        return uRI.equals(uRI2);
    }

    public boolean exists(URI uRI) {
        return false;
    }

    public String getFileName(URI uRI) {
        if (uRI == null) {
            return "";
        }
        String string = uRI.getPath();
        if (string == null || string.length() == 0) {
            return "";
        }
        if (string.equals("/")) {
            return "/";
        }
        int n = string.lastIndexOf(47);
        if (n == string.length() - 1) {
            int n2 = string.lastIndexOf(47, n - 1);
            return string.substring(n2 + 1, n);
        }
        return string.substring(n + 1);
    }

    public long getLength(URI uRI) {
        return -1L;
    }

    public String getName(URI uRI) {
        String string = this.getFileName(uRI);
        int n = string.indexOf(46);
        return n > 0 ? string.substring(0, n) : string;
    }

    public URI getParent(URI uRI) {
        return uRI != null ? uRI.resolve("..") : null;
    }

    public String getPath(URI uRI) {
        return uRI.getPath();
    }

    public String getPathNoExt(URI uRI) {
        String string = this.getPath(uRI);
        int n = string.lastIndexOf("/");
        int n2 = string.lastIndexOf(".");
        if (n2 <= n) {
            return string;
        }
        return string.substring(0, n2);
    }

    public String getPlatformPathName(URI uRI) {
        return uRI != null ? uRI.toString() : "";
    }

    public String getSuffix(URI uRI) {
        String string = uRI.getPath();
        int n = string.lastIndexOf(46);
        int n2 = string.lastIndexOf(47);
        return n >= 0 && n > n2 ? string.substring(n) : "";
    }

    public boolean hasSuffix(URI uRI, String string) {
        String string2 = uRI.getPath();
        return string2.endsWith(string);
    }

    public boolean isBaseURIFor(URI uRI, URI uRI2) {
        if (!this.isDirectoryPath(uRI)) {
            return false;
        }
        String string = uRI.toString();
        String string2 = uRI2.toString();
        return string2.startsWith(string);
    }

    public boolean isDirectory(URI uRI) {
        return false;
    }

    public boolean isDirectoryPath(URI uRI) {
        return uRI != null && uRI.getPath().endsWith("/") && uRI.getQuery() == null && uRI.getFragment() == null;
    }

    public boolean isHidden(URI uRI) {
        return false;
    }

    public boolean isReadOnly(URI uRI) {
        return true;
    }

    public boolean isRegularFile(URI uRI) {
        return this.exists(uRI) && !this.isDirectory(uRI);
    }

    public long lastModified(URI uRI) {
        return -1L;
    }

    public URI[] list(URI uRI) {
        return new URI[0];
    }

    public URI[] list(URI uRI, URIFilter uRIFilter) {
        URI[] uRIArray = this.list(uRI);
        if (uRIArray == null) {
            return null;
        }
        if (uRIFilter == null) {
            return uRIArray;
        }
        ArrayList<URI> arrayList = new ArrayList<URI>();
        for (int i = uRIArray.length - 1; i >= 0; --i) {
            URI uRI2 = uRIArray[i];
            if (!uRIFilter.accept(uRI2)) continue;
            arrayList.add(uRI2);
        }
        return arrayList.toArray(new URI[arrayList.size()]);
    }

    public URI[] listRoots() {
        return null;
    }

    public boolean mkdir(URI uRI) {
        return false;
    }

    public boolean mkdirs(URI uRI) {
        return false;
    }

    public URI createTempFile(String string, String string2, URI uRI) throws IOException {
        return null;
    }

    public InputStream openInputStream(URI uRI) throws IOException {
        throw new UnknownServiceException();
    }

    public OutputStream openOutputStream(URI uRI) throws IOException {
        throw new UnknownServiceException();
    }

    public boolean renameTo(URI uRI, URI uRI2) {
        return false;
    }

    public boolean setLastModified(URI uRI, long l) {
        return false;
    }

    public boolean setReadOnly(URI uRI, boolean bl) {
        return false;
    }

    public String toDisplayString(URI uRI) {
        return uRI == null ? "" : uRI.toString();
    }

    public String toRelativeSpec(URI uRI, URI uRI2) {
        return this.toRelativeSpec(uRI, uRI2, false);
    }

    public String toRelativeSpec(URI uRI, URI uRI2, boolean bl) {
        if (!this.haveSameScheme(uRI, uRI2) || !this.haveSameAuthority(uRI, uRI2)) {
            return bl ? null : uRI.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = this.appendRelativePath(uRI, uRI2, stringBuffer, bl);
        if (bl && !bl2) {
            return null;
        }
        return stringBuffer.toString();
    }

    public URI getBaseParent(URI uRI, String string) {
        String string2 = uRI.getPath();
        int n = string2.lastIndexOf(47);
        if (n < string2.length() - 1) {
            uRI = this.getParent(uRI);
            string2 = uRI.getPath();
        }
        String string3 = string2.substring(0, n);
        int n2 = string.lastIndexOf(47);
        if (n2 < 0) {
            return uRI;
        }
        String string4 = string.substring(0, string.lastIndexOf(47));
        StringTokenizer stringTokenizer = new StringTokenizer(string4, "/");
        String string5 = stringTokenizer.nextToken();
        StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "/");
        int n3 = 0;
        boolean bl = false;
        while (stringTokenizer2.hasMoreTokens()) {
            String string6 = stringTokenizer2.nextToken();
            if (this.areEqualPathElems(string5, string6)) {
                int n4;
                int n5 = stringTokenizer2.countTokens();
                if (n5 != (n4 = stringTokenizer.countTokens())) continue;
                if (n4 != 0) {
                    string5 = stringTokenizer.nextToken();
                    ++n3;
                    continue;
                }
                bl = true;
                break;
            }
            if (n3 == 0) continue;
            n3 = 0;
            break;
        }
        if (bl) {
            for (int i = n3; i >= 0; --i) {
                uRI = this.getParent(uRI);
            }
        }
        return uRI;
    }

    public URL toURL(URI uRI) throws MalformedURLException {
        return uRI.toURL();
    }

    protected boolean haveSameUserInfo(URI uRI, URI uRI2) {
        return this.areEqual(uRI.getUserInfo(), uRI2.getUserInfo());
    }

    protected boolean haveSameHost(URI uRI, URI uRI2) {
        return this.areEqual(uRI.getHost(), uRI2.getHost());
    }

    protected boolean haveSamePath(URI uRI, URI uRI2) {
        return this.areEqual(uRI.getPath(), uRI2.getPath());
    }

    protected boolean haveSameQuery(URI uRI, URI uRI2) {
        return this.areEqual(uRI.getQuery(), uRI2.getQuery());
    }

    protected boolean haveSameRef(URI uRI, URI uRI2) {
        return this.areEqual(uRI.getFragment(), uRI2.getFragment());
    }

    protected boolean haveSamePort(URI uRI, URI uRI2) {
        return uRI.getPort() == uRI2.getPort();
    }

    protected final boolean areEqual(String string, String string2) {
        return string == string2 || string != null && string.equals(string2);
    }

    protected boolean haveSameScheme(URI uRI, URI uRI2) {
        if (uRI == null || uRI2 == null) {
            return false;
        }
        String string = uRI.getScheme();
        String string2 = uRI2.getScheme();
        return string.equals(string2);
    }

    protected boolean haveSameAuthority(URI uRI, URI uRI2) {
        if (uRI == uRI2) {
            return true;
        }
        if (uRI == null || uRI2 == null) {
            return false;
        }
        String string = uRI.getAuthority();
        String string2 = uRI2.getAuthority();
        if (string == null) {
            return string2 == null;
        }
        if (string2 != null) {
            return string.equals(string2);
        }
        return false;
    }

    protected boolean appendRelativePath(URI uRI, URI uRI2, StringBuffer stringBuffer, boolean bl) {
        boolean bl2;
        String string;
        String string2 = uRI.getPath();
        int n = string2.lastIndexOf(47);
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "/");
        String string5 = uRI2.getPath();
        String string6 = string5.substring(0, string5.lastIndexOf(47));
        StringTokenizer stringTokenizer2 = new StringTokenizer(string6, "/");
        int n2 = stringTokenizer2.countTokens();
        int n3 = 0;
        String string7 = null;
        while (stringTokenizer.hasMoreTokens() && stringTokenizer2.hasMoreTokens() && this.areEqualPathElems(string7 = stringTokenizer.nextToken(), string = stringTokenizer2.nextToken())) {
            ++n3;
            string7 = null;
        }
        boolean bl3 = bl2 = n2 == n3;
        if (bl && !bl2) {
            return false;
        }
        if (n3 == 0) {
            stringBuffer.append(string2);
        } else {
            int n4;
            for (int i = n4 = n2 - n3; i > 0; --i) {
                stringBuffer.append("../");
            }
            if (string7 != null && string7.length() > 0) {
                if (n4 == 0 && string7.indexOf(58) >= 0) {
                    stringBuffer.append("./");
                }
                stringBuffer.append(string7).append('/');
            }
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(stringTokenizer.nextToken()).append('/');
            }
            stringBuffer.append(string4);
        }
        return bl2;
    }

    protected boolean areEqualPathElems(String string, String string2) {
        return string.equals(string2);
    }

    private URI replacePathPart(URI uRI, String string) {
        try {
            return new URI(uRI.getScheme(), uRI.getUserInfo(), uRI.getHost(), uRI.getPort(), string, uRI.getQuery(), uRI.getFragment());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

