/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.net.spi;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.MetaClassVisitor;
import javax.ide.util.MetaClass;

public final class VFSHook
extends ExtensionHook {
    public static final ElementName ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "vfs-hook");
    private static final ElementName SCHEME = new ElementName("http://jcp.org/jsr/198/extension-manifest", "scheme");
    private static final ElementName HELPER = new ElementName("http://jcp.org/jsr/198/extension-manifest", "helper");
    private static final ElementName HELPER_CLASS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "helper-class");
    private static final String CURRENT_HOLDER = "currentHolder";
    private final ElementVisitor _helperVisitor = new HelperVisitor();
    private final ElementVisitor _schemeVisitor = new SchemeVisitor();
    private final ElementVisitor _helperClassVisitor = new HelperClassVisitor();
    private Map _helperMetaClassesByScheme = new HashMap();

    public void start(ElementStartContext elementStartContext) {
        elementStartContext.registerChildVisitor(HELPER, this._helperVisitor);
    }

    private final class Holder {
        private String scheme;
        private MetaClass metaClass;

        private Holder() {
        }
    }

    private final class HelperClassVisitor
    extends MetaClassVisitor {
        private HelperClassVisitor() {
        }

        protected void metaClass(ElementContext elementContext, MetaClass metaClass) {
            Holder holder = (Holder)elementContext.getScopeData().get(VFSHook.CURRENT_HOLDER);
            holder.metaClass = metaClass;
        }
    }

    private final class SchemeVisitor
    extends ElementVisitor {
        private SchemeVisitor() {
        }

        public void end(ElementEndContext elementEndContext) {
            if (elementEndContext.getText() != null) {
                String string = elementEndContext.getText().trim();
                Holder holder = (Holder)elementEndContext.getScopeData().get(VFSHook.CURRENT_HOLDER);
                holder.scheme = string;
            }
        }
    }

    private final class HelperVisitor
    extends ElementVisitor {
        private HelperVisitor() {
        }

        public void start(ElementStartContext elementStartContext) {
            elementStartContext.getScopeData().put(VFSHook.CURRENT_HOLDER, new Holder());
            elementStartContext.registerChildVisitor(SCHEME, VFSHook.this._schemeVisitor);
            elementStartContext.registerChildVisitor(HELPER_CLASS, VFSHook.this._helperClassVisitor);
        }

        public void end(ElementEndContext elementEndContext) {
            Holder holder = (Holder)elementEndContext.getScopeData().get(VFSHook.CURRENT_HOLDER);
            if (holder.scheme == null) {
                this.log(elementEndContext, Level.SEVERE, "Missing required element 'scheme'.");
                return;
            }
            if (holder.metaClass == null) {
                this.log(elementEndContext, Level.SEVERE, "Missing required element 'helper-class'.");
                return;
            }
            if (VFSHook.this._helperMetaClassesByScheme.containsKey(holder.scheme)) {
                this.log(elementEndContext, Level.WARNING, "Multiple virtual file system helpers for scheme '" + holder.scheme + "'. " + holder.metaClass.getClassName() + " takes precedence.");
            }
            VFSHook.this._helperMetaClassesByScheme.put(holder.scheme, holder.metaClass);
        }
    }
}

